/*
 * Decompiled with CFR 0.152.
 */
package com.aip.gateway.api;

import com.aip.gateway.api.LicenseManager;
import com.aip.gateway.api.app.AppUtils;
import com.aip.gateway.api.config.ApplicationConfig;
import com.aip.gateway.api.process.DbmsDataProcess;
import com.aip.gateway.api.repository.AipFileRepository;
import java.io.File;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.Banner;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.ApplicationPidFileWriter;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.scheduling.annotation.EnableAsync;

@EnableAsync
@SpringBootApplication
@ComponentScan(basePackages={"com.aip.gateway.api.config", "com.aip.gateway.api.dao.mapper", "com.aip.gateway.api"})
public class AipGatewayApiApplication
implements CommandLineRunner,
ApplicationListener<ContextClosedEvent>,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(AipGatewayApiApplication.class);
    private static String applicationName = "AipGatewayApi";

    public static void main(String[] args) {
        System.setProperty("file.encoding", "UTF-8");
        try {
            Field charset = Charset.class.getDeclaredField("defaultCharset");
            charset.setAccessible(true);
            charset.set(null, null);
        }
        catch (Exception charset) {
            // empty catch block
        }
        File file1 = new File("./conf/" + applicationName + ".pid");
        if (file1.exists()) {
            System.out.println(System.getProperty("Program Already Running....."));
            log.error("Program Already Running.....");
        }
        SpringApplication application = new SpringApplicationBuilder(new Class[0]).sources(new Class[]{AipGatewayApiApplication.class}).listeners(new ApplicationListener[]{new ApplicationPidFileWriter("./conf/" + applicationName + ".pid")}).build();
        application.setBannerMode(Banner.Mode.OFF);
        application.run(args);
    }

    public void run(String ... args) throws Exception {
        ApplicationConfig applicationConfig = (ApplicationConfig)AppUtils.getBean(ApplicationConfig.class);
        log.info("");
        log.info("************************************************************************************");
        log.info("**                                                                                **");
        log.info("**                       Azure Information Protection                             **");
        log.info("**                AIP API Interface RESTFull Application Server.                  *");
        log.info("**                                                                                **");
        log.info("**                                                                   [ver.1.0]    **");
        log.info("** startup: {}", (Object)applicationConfig.getBootingDateTime());
        log.info("************************************************************************************");
        log.info("");
        if (!LicenseManager.validateLicense()) {
            log.error("License Validation Failed.");
            System.exit(0);
        }
        DbmsDataProcess dbmsDataProcess = (DbmsDataProcess)AppUtils.getBean(DbmsDataProcess.class);
        dbmsDataProcess.run();
        AipFileRepository aipFileRepository = (AipFileRepository)AppUtils.getBean(AipFileRepository.class);
        if (!aipFileRepository.initialize()) {
            log.error("AipFileRepository.initialize Failed. System Terminated.");
            System.exit(0);
        }
        applicationConfig.setStartSchedule(true);
    }

    public void terminateApplication() {
    }

    public void onApplicationEvent(ContextClosedEvent event) {
        log.error("Application Terminated: {}", (Object)event.getTimestamp());
        this.terminateApplication();
    }

    public void afterPropertiesSet() throws Exception {
    }

    public void destroy() throws Exception {
    }
}

