/*
 * Decompiled with CFR 0.152.
 */
package com.aip.gateway.api.aip;

import com.aip.gateway.api.aip.model.AipConfig;
import com.aip.gateway.api.aip.utils.MemoryTokenCacheWithEviction;
import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ClientCredentialParameters;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IClientCredential;
import com.microsoft.aad.msal4j.ITokenCacheAccessAspect;
import com.microsoft.aad.msal4j.MsalException;
import com.microsoft.informationprotection.IAuthDelegate;
import com.microsoft.informationprotection.Identity;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthDelegateImpl
implements IAuthDelegate {
    private static final Logger log = LoggerFactory.getLogger(AuthDelegateImpl.class);
    private int lastErrNo;
    private String lastErrMsg;
    private AipConfig aipConfig;
    private ConfidentialClientApplication confidentialApp;
    private final String instance = "https://login.microsoftonline.com/";
    private final String authority = "https://login.windows.net/";
    private final String scope = "https://graph.microsoft.com/.default";

    public AuthDelegateImpl(AipConfig aipConfig) throws Exception {
        this.aipConfig = aipConfig;
        this.resetError();
        String cacheKey = aipConfig.getClientId() + "_" + aipConfig.getTenantId() + "_AppTokenCache";
        MemoryTokenCacheWithEviction memoryTokenCacheWithEviction = new MemoryTokenCacheWithEviction(cacheKey);
        if (aipConfig.getLoginType() == 1) {
            this.confidentialApp = ((ConfidentialClientApplication.Builder)((ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)aipConfig.getClientId(), (IClientCredential)ClientCredentialFactory.createFromSecret((String)aipConfig.getSecretValue())).authority("https://login.microsoftonline.com/" + aipConfig.getTenantId())).setTokenCacheAccessAspect((ITokenCacheAccessAspect)memoryTokenCacheWithEviction)).build();
        } else if (aipConfig.getLoginType() == 2) {
            ByteArrayInputStream certStream = new ByteArrayInputStream(Files.readAllBytes(Paths.get(aipConfig.getCertThumbPrint(), new String[0])));
            String password = "hanteinfo1234!";
            this.confidentialApp = ((ConfidentialClientApplication.Builder)((ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)aipConfig.getClientId(), (IClientCredential)ClientCredentialFactory.createFromCertificate((InputStream)certStream, (String)password)).authority("https://login.windows.net/" + aipConfig.getTenantId())).setTokenCacheAccessAspect((ITokenCacheAccessAspect)memoryTokenCacheWithEviction)).build();
        } else {
            throw new Exception("\uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 AIP \uc778\uc99d \ubc29\ubc95 \uc785\ub2c8\ub2e4.");
        }
    }

    public void resetError() {
        this.lastErrNo = 0;
        this.lastErrMsg = "";
    }

    public void setError(int errNo, String errMsg1, String errMsg2) {
        this.lastErrNo = errNo;
        this.lastErrMsg = errMsg2 == null || errMsg2.isEmpty() ? errMsg1 : errMsg1 + "\r\n" + errMsg2;
        log.error("AuthDelegateImpl::setError ==> {}, {}", (Object)errNo, (Object)this.lastErrMsg);
    }

    public String acquireToken(Identity identity, String authority, String resource, String claim) {
        return this.AcquireTokenByCertificate(identity, authority, resource, claim);
    }

    private String AcquireTokenByCertificate(Identity identity, String authority, String resource, String claims) {
        Set<Object> scope = Collections.singleton("");
        scope = resource.endsWith("/") ? Collections.singleton(resource + ".default") : Collections.singleton(resource + "/.default");
        try {
            ClientCredentialParameters clientCredentialParam = ClientCredentialParameters.builder(scope).build();
            CompletableFuture future = this.confidentialApp.acquireToken(clientCredentialParam);
            IAuthenticationResult result = (IAuthenticationResult)future.get();
            return result.accessToken();
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof MsalException) {
                this.setError(1, "AcquireTokenByCertificate::AcquireTokenByCertificate, Scope provided is not supported.", ex.getMessage());
            } else {
                this.setError(1, "AcquireTokenByCertificate::AcquireTokenByCertificate Failed.", ex.getMessage());
            }
            return null;
        }
    }

    public int getLastErrNo() {
        return this.lastErrNo;
    }

    public String getLastErrMsg() {
        return this.lastErrMsg;
    }

    public AipConfig getAipConfig() {
        return this.aipConfig;
    }

    public ConfidentialClientApplication getConfidentialApp() {
        return this.confidentialApp;
    }

    public String getInstance() {
        Objects.requireNonNull(this);
        return "https://login.microsoftonline.com/";
    }

    public String getAuthority() {
        Objects.requireNonNull(this);
        return "https://login.windows.net/";
    }

    public String getScope() {
        Objects.requireNonNull(this);
        return "https://graph.microsoft.com/.default";
    }

    public void setLastErrNo(int lastErrNo) {
        this.lastErrNo = lastErrNo;
    }

    public void setLastErrMsg(String lastErrMsg) {
        this.lastErrMsg = lastErrMsg;
    }

    public void setAipConfig(AipConfig aipConfig) {
        this.aipConfig = aipConfig;
    }

    public void setConfidentialApp(ConfidentialClientApplication confidentialApp) {
        this.confidentialApp = confidentialApp;
    }
}

