/*
 * Decompiled with CFR 0.152.
 */
package com.aip.gateway.api.aip.manager;

import com.aip.gateway.api.aip.AuthDelegateImpl;
import com.aip.gateway.api.aip.manager.AbstractManager;
import com.microsoft.informationprotection.CacheStorageType;
import com.microsoft.informationprotection.IAuthDelegate;
import com.microsoft.informationprotection.Identity;
import com.microsoft.informationprotection.Label;
import com.microsoft.informationprotection.MIP;
import com.microsoft.informationprotection.MipContext;
import com.microsoft.informationprotection.policy.IPolicyEngine;
import com.microsoft.informationprotection.policy.IPolicyProfile;
import com.microsoft.informationprotection.policy.PolicyEngineSettings;
import com.microsoft.informationprotection.policy.PolicyProfileSettings;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyManager
extends AbstractManager {
    private static final Logger log = LoggerFactory.getLogger(PolicyManager.class);
    private IPolicyProfile _profile = null;
    private IPolicyEngine _engine = null;

    public void dispose() {
        this.dispose(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose(boolean disposing) {
        PolicyManager policyManager = this;
        synchronized (policyManager) {
            if (this._profile == null || this._engine != null) {
                // empty if block
            }
            this._engine = null;
            this._profile = null;
        }
    }

    public boolean createProfile(MipContext mipContext) {
        try {
            PolicyProfileSettings profileSettings = new PolicyProfileSettings(mipContext, CacheStorageType.ON_DISK_ENCRYPTED);
            CompletableFuture policyProfile = MIP.loadPolicyProfileAsync((PolicyProfileSettings)profileSettings);
            this._profile = (IPolicyProfile)policyProfile.get();
        }
        catch (InterruptedException ie) {
            this.setError(1, "PolicyManager::createProfile InterruptedException Exception.", ie.getMessage());
            return false;
        }
        catch (ExecutionException eex) {
            this.setError(2, "PolicyManager::createProfile ExecutionException Exception.", eex.getMessage());
            return false;
        }
        catch (Exception e) {
            this.setError(3, "PolicyManager::createProfile Exception.", e.getMessage());
            return false;
        }
        return this._profile != null;
    }

    public boolean createEngine(Identity identity, AuthDelegateImpl authDelegate) {
        try {
            authDelegate.resetError();
            PolicyEngineSettings engineSettings = new PolicyEngineSettings(identity.getEmail(), (IAuthDelegate)authDelegate, "", "en-US");
            engineSettings.setIdentity(identity);
            CompletableFuture egineFuture = this._profile.addEngineAsync(engineSettings);
            this._engine = (IPolicyEngine)egineFuture.get();
        }
        catch (InterruptedException ie) {
            this.setError(1, "FileManager::createEngine InterruptedException Exception.", ie.getMessage());
            return false;
        }
        catch (ExecutionException eex) {
            this.setError(2, "FileManager::createEngine ExecutionException Exception.", eex.getMessage());
            return false;
        }
        catch (Exception e) {
            this.setError(3, "FileManager::createEngine Exception.", e.getMessage());
            return false;
        }
        return this._engine != null;
    }

    public List<Label> getPolicySensitivityLabels() {
        return this._engine.getSensitivityLabels();
    }
}

