/*
 * Decompiled with CFR 0.152.
 */
package com.aip.gateway.api.aip.manager;

import com.aip.gateway.api.aip.AuthDelegateImpl;
import com.aip.gateway.api.aip.ConsentDelegateImpl;
import com.aip.gateway.api.aip.manager.AbstractManager;
import com.microsoft.informationprotection.CacheStorageType;
import com.microsoft.informationprotection.IAuthDelegate;
import com.microsoft.informationprotection.IConsentDelegate;
import com.microsoft.informationprotection.Identity;
import com.microsoft.informationprotection.MIP;
import com.microsoft.informationprotection.MipContext;
import com.microsoft.informationprotection.internal.protection.ProtectionEngineSettings;
import com.microsoft.informationprotection.internal.protection.ProtectionProfileSettings;
import com.microsoft.informationprotection.internal.protection.TemplateDescriptor;
import com.microsoft.informationprotection.protection.IProtectionEngine;
import com.microsoft.informationprotection.protection.IProtectionProfile;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtectionManager
extends AbstractManager {
    private static final Logger log = LoggerFactory.getLogger(ProtectionManager.class);
    private IProtectionProfile _profile = null;
    private IProtectionEngine _engine = null;

    public void dispose() {
        this.dispose(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose(boolean disposing) {
        ProtectionManager protectionManager = this;
        synchronized (protectionManager) {
            this._profile = null;
            this._engine = null;
        }
    }

    public boolean createProfile(MipContext mipContext) {
        try {
            ConsentDelegateImpl consentDelegate = new ConsentDelegateImpl();
            ProtectionProfileSettings profileSettings = new ProtectionProfileSettings(mipContext, CacheStorageType.ON_DISK_ENCRYPTED, (IConsentDelegate)consentDelegate);
            CompletableFuture profileFuture = MIP.loadProtectionProfileAsync((ProtectionProfileSettings)profileSettings);
            this._profile = (IProtectionProfile)profileFuture.get();
        }
        catch (InterruptedException ie) {
            this.setError(1, "ProtectionManager::createProfile InterruptedException Exception.", ie.getMessage());
            return false;
        }
        catch (ExecutionException eex) {
            this.setError(2, "ProtectionManager::createProfile ExecutionException Exception.", eex.getMessage());
            return false;
        }
        catch (Exception e) {
            this.setError(3, "ProtectionManager::createProfile Exception.", e.getMessage());
            return false;
        }
        return this._profile != null;
    }

    public boolean createEngine(Identity identity, AuthDelegateImpl authDelegate) {
        try {
            authDelegate.resetError();
            ProtectionEngineSettings engineSettings = new ProtectionEngineSettings(identity.getEmail(), (IAuthDelegate)authDelegate, "", "en-US");
            engineSettings.setIdentity(identity);
            CompletableFuture egineFuture = this._profile.addEngineAsync(engineSettings);
            this._engine = (IProtectionEngine)egineFuture.get();
        }
        catch (InterruptedException ie) {
            this.setError(1, "ProtectionManager::createEngine InterruptedException Exception.", ie.getMessage());
            return false;
        }
        catch (ExecutionException eex) {
            this.setError(2, "ProtectionManager::createEngine ExecutionException Exception.", eex.getMessage());
            return false;
        }
        catch (Exception e) {
            this.setError(3, "ProtectionManager::createEngine Exception.", e.getMessage());
            return false;
        }
        return this._engine != null;
    }

    public List<TemplateDescriptor> getTemplates() {
        return this._engine.getTemplates();
    }
}

