/*
 * Decompiled with CFR 0.152.
 */
package com.aip.gateway.api.aip.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class AipFileUtils {
    private static final Logger log = LoggerFactory.getLogger(AipFileUtils.class);

    public static long getSize(String fileName) {
        File file = new File(fileName);
        return file.length();
    }

    public static boolean isExists(String fileName) {
        File file = new File(fileName);
        return file.exists();
    }

    public static String getFileName(String fileName) {
        return FilenameUtils.getName((String)fileName);
    }

    public static String getFileNameWithoutExtension(String fileName) {
        return StringUtils.stripFilenameExtension((String)AipFileUtils.getFileName((String)fileName));
    }

    public static String getExtension(String fileName) {
        String fileExt = StringUtils.getFilenameExtension((String)fileName);
        if (fileExt == null) {
            return ".";
        }
        return "." + fileExt.toLowerCase();
    }

    public static boolean delete(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            return file.delete();
        }
        return false;
    }

    public static String getFileDataString(String fileName) {
        String result = "";
        try {
            byte[] fileBytes = Files.readAllBytes(Path.of(fileName, new String[0]));
            result = Base64.getEncoder().encodeToString(fileBytes);
        }
        catch (Exception e) {
            log.error("AipFileUtils.getFileDataString: {}", (Object)e.getMessage());
            result = "";
        }
        return result;
    }

    public static boolean streamToFile(byte[] byteArrayData, String fileName) {
        boolean result = true;
        try {
            FileUtils.writeByteArrayToFile((File)new File(fileName), (byte[])byteArrayData);
        }
        catch (IOException e) {
            log.error("streamToFile: IOException: {}, {}", (Object)fileName, (Object)e.getMessage());
            result = false;
        }
        return result;
    }
}

