/*
 * Decompiled with CFR 0.152.
 */
package com.aip.gateway.api.aip.utils;

import com.microsoft.aad.msal4j.ITokenCacheAccessAspect;
import com.microsoft.aad.msal4j.ITokenCacheAccessContext;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public abstract class MsalAbstractTokenCacheProvider
implements ITokenCacheAccessAspect {
    private final String cacheKey;

    MsalAbstractTokenCacheProvider(String cacheKey) {
        this.cacheKey = cacheKey;
    }

    public void beforeCacheAccess(ITokenCacheAccessContext context) {
        try {
            String content = (String)this.ReadFromCache(this.cacheKey).get();
            context.tokenCache().deserialize(content);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public void afterCacheAccess(ITokenCacheAccessContext context) {
        if (context.hasCacheChanged()) {
            String cacheContent = context.tokenCache().serialize();
            this.WriteToCache(this.cacheKey, cacheContent);
        }
    }

    protected abstract CompletableFuture<Void> WriteToCache(String var1, String var2);

    protected abstract CompletableFuture<String> ReadFromCache(String var1);
}

