/*
 * Decompiled with CFR 0.152.
 */
package com.aip.gateway.api.config;

import jakarta.annotation.PostConstruct;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.AsyncConfigurerSupport;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@EnableAsync
@Configuration
@ConfigurationProperties(prefix="application.thread-pool")
public class ThreadPoolInitializer
extends AsyncConfigurerSupport {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolInitializer.class);
    private int work = 0;
    private int dbms = 0;

    @PostConstruct
    private void init() {
        int maxCore = Math.max(8, Runtime.getRuntime().availableProcessors());
        if (this.work <= 0) {
            this.work = maxCore;
        }
        if (this.dbms <= 0) {
            this.dbms = maxCore;
        }
        log.info("{}", (Object)this);
    }

    public ThreadPoolTaskExecutor getDefaultExecutor(int poolSize) {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
        threadPoolTaskExecutor.setCorePoolSize(poolSize);
        threadPoolTaskExecutor.setMaxPoolSize(poolSize * 2);
        threadPoolTaskExecutor.setQueueCapacity(1000);
        return threadPoolTaskExecutor;
    }

    @Bean(name={"dbmsDataExecutor"})
    public Executor getDbmsDataExecutor() {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = this.getDefaultExecutor(this.dbms);
        threadPoolTaskExecutor.setThreadNamePrefix("dbms-pool-");
        threadPoolTaskExecutor.initialize();
        return threadPoolTaskExecutor;
    }

    @Bean(name={"workDataExecutor"})
    public Executor getWorkDataExecutor() {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = this.getDefaultExecutor(this.work);
        threadPoolTaskExecutor.setThreadNamePrefix("work-pool-");
        threadPoolTaskExecutor.initialize();
        return threadPoolTaskExecutor;
    }

    public int getWork() {
        return this.work;
    }

    public int getDbms() {
        return this.dbms;
    }

    public void setWork(int work) {
        this.work = work;
    }

    public void setDbms(int dbms) {
        this.dbms = dbms;
    }
}

