/*
 * Decompiled with CFR 0.152.
 */
package com.aip.gateway.api.controller;

import com.aip.gateway.api.controller.BaseController;
import com.aip.gateway.api.model.request.RequestBase;
import com.aip.gateway.api.model.request.RequestFile;
import com.aip.gateway.api.model.request.RequestFileAllSet;
import com.aip.gateway.api.model.request.RequestFileDel;
import com.aip.gateway.api.model.request.RequestFileSet;
import com.aip.gateway.api.model.response.ApiResponseModel;
import com.aip.gateway.api.repository.AppRepository;
import com.aip.gateway.api.repository.GlobalConstants;
import com.aip.gateway.api.service.IApiFileService;
import io.swagger.annotations.ApiOperation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Tag(name="ApiFile", description="FILE AIP API")
@RestController
@CrossOrigin
@Validated
@RequestMapping(value={"/v1/aip-api/file"})
public class ApiFileController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(ApiFileController.class);
    private final AppRepository appRepo;
    private final IApiFileService service;

    @Operation(summary="File Info", description="AIP File Information Query.")
    @ApiResponse(responseCode="200", description="AIP File Information query Success.")
    @ApiOperation(value="File Info", response=ApiResponseModel.class)
    @PostMapping(value={"info"}, produces={"application/json; charset=utf8"})
    public ResponseEntity<ApiResponseModel> getInfo(@Parameter(name="req", description="File \uc815\ubcf4 \uc694\uccad \ub370\uc774\ud130", required=true) @RequestBody @Valid RequestFile req, HttpServletRequest request) {
        try {
            GlobalConstants.setAuthorization((HttpServletRequest)request, (int)21, (String)req.getApiKey(), (RequestBase)req);
            int authError = this.appRepo.checkApiKeyValidation(req.getApiKey(), this.getRemoteIP(request));
            if (authError != 0) {
                return this.responseApiKeyValidationError(request, authError);
            }
            return this.responseSuccess(request, this.service.getInfo(req));
        }
        catch (Exception e) {
            log.error("exception: /v1/aip-api/file/info, {}", (Object)e.getMessage());
            return this.responseException(request, e);
        }
    }

    @Operation(summary="File AIP Label \uc124\uc815", description="File AIP Label Set.")
    @ApiResponse(responseCode="200", description="File AIP Label set success.")
    @ApiOperation(value="File AIP Label \uc124\uc815", response=ApiResponseModel.class, responseContainer="ArrayList")
    @PostMapping(value={"set-label"}, produces={"application/json; charset=utf8"})
    public ResponseEntity<ApiResponseModel> setLabel(@Parameter(name="req", description="File AIP Label \uc124\uc815 \uc694\uccad \ub370\uc774\ud130", required=true) @RequestBody @Valid RequestFileSet req, HttpServletRequest request) {
        try {
            GlobalConstants.setAuthorization((HttpServletRequest)request, (int)22, (String)req.getApiKey(), (RequestBase)req);
            int authError = this.appRepo.checkApiKeyValidation(req.getApiKey(), this.getRemoteIP(request));
            if (authError != 0) {
                return this.responseApiKeyValidationError(request, authError);
            }
            return this.responseSuccess(request, this.service.setLabel(req));
        }
        catch (Exception e) {
            log.error("exception: /v1/aip-api/file/set-label, {}", (Object)e.getMessage());
            return this.responseException(request, e);
        }
    }

    @Operation(summary="File AIP Label Delete", description="File AIP Label Delete.")
    @ApiResponse(responseCode="200", description="File AIP Label delete success.")
    @ApiOperation(value="File AIP Label \ud574\uc81c", response=ApiResponseModel.class, responseContainer="ArrayList")
    @PostMapping(value={"delete-label"}, produces={"application/json; charset=utf8"})
    public ResponseEntity<ApiResponseModel> delLabel(@Parameter(name="req", description="File AIP Label \ud574\uc81c \uc694\uccad \ub370\uc774\ud130", required=true) @RequestBody @Valid RequestFileDel req, HttpServletRequest request) {
        try {
            GlobalConstants.setAuthorization((HttpServletRequest)request, (int)23, (String)req.getApiKey(), (RequestBase)req);
            int authError = this.appRepo.checkApiKeyValidation(req.getApiKey(), this.getRemoteIP(request));
            if (authError != 0) {
                return this.responseApiKeyValidationError(request, authError);
            }
            return this.responseSuccess(request, this.service.delLabel(req));
        }
        catch (Exception e) {
            log.error("exception: /v1/aip-api/file/delete-label, {}", (Object)e.getMessage());
            return this.responseException(request, e);
        }
    }

    @Operation(summary="File AIP Protection \uc124\uc815", description="File AIP Protection AIP.")
    @ApiResponse(responseCode="200", description="File AIP Protection set success.")
    @ApiOperation(value="File AIP Protection \uc124\uc815", response=ApiResponseModel.class, responseContainer="ArrayList")
    @PostMapping(value={"set-protection"}, produces={"application/json; charset=utf8"})
    public ResponseEntity<ApiResponseModel> setProtection(@Parameter(name="req", description="File AIP Protection \uc124\uc815 \uc694\uccad \ub370\uc774\ud130", required=true) @RequestBody @Valid RequestFileSet req, HttpServletRequest request) {
        try {
            GlobalConstants.setAuthorization((HttpServletRequest)request, (int)24, (String)req.getApiKey(), (RequestBase)req);
            int authError = this.appRepo.checkApiKeyValidation(req.getApiKey(), this.getRemoteIP(request));
            if (authError != 0) {
                return this.responseApiKeyValidationError(request, authError);
            }
            return this.responseSuccess(request, this.service.setProtection(req));
        }
        catch (Exception e) {
            log.error("exception: /v1/aip-api/file/set-protection, {}", (Object)e.getMessage());
            return this.responseException(request, e);
        }
    }

    @Operation(summary="File AIP Protection Delete", description="File AIP Protection Delete.")
    @ApiResponse(responseCode="200", description="File AIP Protection delete success.")
    @ApiOperation(value="File AIP Protection \ud574\uc81c", response=ApiResponseModel.class, responseContainer="ArrayList")
    @PostMapping(value={"delete-protection"}, produces={"application/json; charset=utf8"})
    public ResponseEntity<ApiResponseModel> delProtection(@Parameter(name="req", description="File AIP Protection \ud574\uc81c \uc694\uccad \ub370\uc774\ud130", required=true) @RequestBody @Valid RequestFileDel req, HttpServletRequest request) {
        try {
            GlobalConstants.setAuthorization((HttpServletRequest)request, (int)25, (String)req.getApiKey(), (RequestBase)req);
            int authError = this.appRepo.checkApiKeyValidation(req.getApiKey(), this.getRemoteIP(request));
            if (authError != 0) {
                return this.responseApiKeyValidationError(request, authError);
            }
            return this.responseSuccess(request, this.service.delProtection(req));
        }
        catch (Exception e) {
            log.error("exception: /v1/aip-api/file/delete-protection, {}", (Object)e.getMessage());
            return this.responseException(request, e);
        }
    }

    @Operation(summary="File AIP Label Or Protection \uc124\uc815", description="File AIP Label Or Protection AIP.")
    @ApiResponse(responseCode="200", description="File AIP Label Or Protection set success.")
    @ApiOperation(value="File AIP Label Or Protection \uc124\uc815", response=ApiResponseModel.class, responseContainer="ArrayList")
    @PostMapping(value={"set-label-protection"}, produces={"application/json; charset=utf8"})
    public ResponseEntity<ApiResponseModel> setLabelProtection(@Parameter(name="req", description="File AIP Label Or Protection \uc124\uc815 \uc694\uccad \ub370\uc774\ud130", required=true) @RequestBody @Valid RequestFileAllSet req, HttpServletRequest request) {
        try {
            GlobalConstants.setAuthorization((HttpServletRequest)request, (int)26, (String)req.getApiKey(), (RequestBase)req);
            int authError = this.appRepo.checkApiKeyValidation(req.getApiKey(), this.getRemoteIP(request));
            if (authError != 0) {
                return this.responseApiKeyValidationError(request, authError);
            }
            return this.responseSuccess(request, this.service.setLabelProtection(req));
        }
        catch (Exception e) {
            log.error("exception: /v1/aip-api/file/set-label-protection, {}", (Object)e.getMessage());
            return this.responseException(request, e);
        }
    }

    @Operation(summary="File AIP Label Or Protection Delete", description="File AIP Label Or Protection Delete.")
    @ApiResponse(responseCode="200", description="File AIP Label Or Protection delete success.")
    @ApiOperation(value="File AIP Label Or Protection \ud574\uc81c", response=ApiResponseModel.class, responseContainer="ArrayList")
    @PostMapping(value={"delete-label-protection"}, produces={"application/json; charset=utf8"})
    public ResponseEntity<ApiResponseModel> delLabelProtection(@Parameter(name="req", description="File AIP Label Or Protection \ud574\uc81c \uc694\uccad \ub370\uc774\ud130", required=true) @RequestBody @Valid RequestFileDel req, HttpServletRequest request) {
        try {
            GlobalConstants.setAuthorization((HttpServletRequest)request, (int)27, (String)req.getApiKey(), (RequestBase)req);
            int authError = this.appRepo.checkApiKeyValidation(req.getApiKey(), this.getRemoteIP(request));
            if (authError != 0) {
                return this.responseApiKeyValidationError(request, authError);
            }
            return this.responseSuccess(request, this.service.delLabelProtection(req));
        }
        catch (Exception e) {
            log.error("exception: /v1/aip-api/file/delete-label-protection, {}", (Object)e.getMessage());
            return this.responseException(request, e);
        }
    }

    @Operation(summary="Encrypt File", description="Encrypt File.")
    @ApiResponse(responseCode="200", description="Encrypt File set success.")
    @ApiOperation(value="Encrypt File", response=ApiResponseModel.class, responseContainer="ArrayList")
    @PostMapping(value={"encrypt"}, consumes={"multipart/form-data"}, produces={"application/json"})
    public ResponseEntity<ApiResponseModel> encryptFile(@Parameter(description="multipart/form-data \ud615\uc2dd\uc758 \ud30c\uc77c\uc744 input \uc73c\ub85c \ubc1b\uc2b5\ub2c8\ub2e4. \uc774\ub54c key \uac12\uc740 multipartFile \uc785\ub2c8\ub2e4.") @RequestParam(value="file") MultipartFile file, @RequestParam(value="apiKey") String apiKey, @RequestParam(value="email") String email, HttpServletRequest request) {
        try {
            RequestBase baseReq = RequestBase.builder().apiKey(apiKey).decryptKey("").email(email).apiGuid("").build();
            GlobalConstants.setAuthorization((HttpServletRequest)request, (int)28, (String)apiKey, (RequestBase)baseReq);
            int authError = this.appRepo.checkApiKeyValidation(apiKey, this.getRemoteIP(request));
            if (authError != 0) {
                return this.responseApiKeyValidationError(request, authError);
            }
            return this.responseSuccess(request, this.service.encryptFile(file, baseReq));
        }
        catch (Exception e) {
            log.error("exception: /v1/aip-api/file/encrypt, {}", (Object)e.getMessage());
            return this.responseException(request, e);
        }
    }

    @Operation(summary="Decrypt File", description="Decrypt File.")
    @ApiResponse(responseCode="200", description="Decrypt File set success.")
    @ApiOperation(value="Decrypt File", response=ApiResponseModel.class, responseContainer="ArrayList")
    @PostMapping(value={"decrypt"}, consumes={"multipart/form-data"}, produces={"application/json"})
    public ResponseEntity<ApiResponseModel> decryptFile(@Parameter(description="multipart/form-data \ud615\uc2dd\uc758 \ud30c\uc77c\uc744 input \uc73c\ub85c \ubc1b\uc2b5\ub2c8\ub2e4. \uc774\ub54c key \uac12\uc740 multipartFile \uc785\ub2c8\ub2e4.") @RequestParam(value="file") MultipartFile file, @RequestParam(value="apiKey") String apiKey, @RequestParam(value="email") String email, HttpServletRequest request) {
        try {
            RequestBase baseReq = RequestBase.builder().apiKey(apiKey).decryptKey("").email(email).apiGuid("").build();
            GlobalConstants.setAuthorization((HttpServletRequest)request, (int)29, (String)apiKey, (RequestBase)baseReq);
            int authError = this.appRepo.checkApiKeyValidation(apiKey, this.getRemoteIP(request));
            if (authError != 0) {
                return this.responseApiKeyValidationError(request, authError);
            }
            return this.responseSuccess(request, this.service.decryptFile(file, baseReq));
        }
        catch (Exception e) {
            log.error("exception: /v1/aip-api/file/decrypt, {}", (Object)e.getMessage());
            return this.responseException(request, e);
        }
    }

    public ApiFileController(AppRepository appRepo, IApiFileService service) {
        this.appRepo = appRepo;
        this.service = service;
    }
}

