/*
 * Decompiled with CFR 0.152.
 */
package com.aip.gateway.api.security;

import com.aip.gateway.api.interceptor.AipApiControllerInterceptor;
import com.aip.gateway.api.process.DbmsDataProcess;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class WebMvcConfig
implements WebMvcConfigurer {
    private final DbmsDataProcess dbmsDataProcess;

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new AipApiControllerInterceptor(this.dbmsDataProcess)).addPathPatterns(new String[]{"/v1/aip-api/**"}).excludePathPatterns(new String[]{"/application/facility/**", "/application/wall/**", "/application/dashboard/**", "/facility/**", "/wall/**", "/dashboard/**", "/api/resource/**", "/api/reload/**", "/api/test/**", "/manual/**"});
    }

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**").allowedOrigins(new String[]{"*"}).allowedMethods(new String[]{"GET", "POST", "PUT", "DELETE"}).maxAge(3600L);
    }

    public void addViewControllers(ViewControllerRegistry registry) {
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        String separator = System.getProperty("file.separator");
        String mapDataDir = System.getProperty("user.dir") + separator + "MAPDATA/";
        String downloadDir = System.getProperty("user.dir") + separator + "download/";
        registry.addResourceHandler(new String[]{"/MAPDATA/**"}).addResourceLocations(new String[]{"file:///" + mapDataDir});
        registry.addResourceHandler(new String[]{"/download/**"}).addResourceLocations(new String[]{"file:///" + downloadDir});
    }

    public static String encUserId(String userId) {
        return userId;
    }

    public static String decUserId(Object encUserId) {
        String decUserId = (String)encUserId;
        return decUserId;
    }

    public WebMvcConfig(DbmsDataProcess dbmsDataProcess) {
        this.dbmsDataProcess = dbmsDataProcess;
    }
}

