/*
 * Decompiled with CFR 0.152.
 */
package com.aip.gateway.api.service.impl;

import com.aip.gateway.api.aip.model.SetFileInfo;
import com.aip.gateway.api.aip.utils.AipFileUtils;
import com.aip.gateway.api.model.app.CheckAip;
import com.aip.gateway.api.model.app.CheckMultipartFile;
import com.aip.gateway.api.model.request.RequestBase;
import com.aip.gateway.api.model.request.RequestStream;
import com.aip.gateway.api.model.request.RequestStreamAllSet;
import com.aip.gateway.api.model.request.RequestStreamDel;
import com.aip.gateway.api.model.request.RequestStreamSet;
import com.aip.gateway.api.model.response.ResponseInfo;
import com.aip.gateway.api.model.response.ResponseStream;
import com.aip.gateway.api.repository.AipFileRepository;
import com.aip.gateway.api.repository.AppRepository;
import com.aip.gateway.api.service.IApiStreamService;
import com.aip.gateway.api.service.impl.AbstractAipService;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ApiStreamService
extends AbstractAipService
implements IApiStreamService {
    private static final Logger log = LoggerFactory.getLogger(ApiStreamService.class);

    public ApiStreamService(AppRepository repo, AipFileRepository aipFile) {
        super(repo, aipFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseInfo getInfo(RequestStream req) {
        ResponseInfo responseInfo;
        String tempOrgFileName = this.getRequestFileName(req.getApiGuid() + AipFileUtils.getExtension((String)req.getDispFileName()));
        String actualFileName = this.getActualFileName(req.getApiGuid() + AipFileUtils.getExtension((String)req.getDispFileName()));
        String newFileExt = this.getSupportedFileType(req.getDispFileName());
        if (newFileExt == null) {
            return new ResponseInfo(102, "\uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 \ud30c\uc77c\ud615\uc2dd \uc785\ub2c8\ub2e4.");
        }
        byte[] fileDataArr = Base64.getDecoder().decode(req.getFileData());
        if (!AipFileUtils.streamToFile((byte[])fileDataArr, (String)tempOrgFileName)) {
            return new ResponseInfo(110, "\uc791\uc5c5 \uc911\uc5d0 \ud30c\uc77c \uc2dc\uc2a4\ud15c \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
        try {
            responseInfo = this.responseGetFileInfo(this.aipFile.getManager().getFileInfo(tempOrgFileName, actualFileName), req.getDispFileName());
        }
        catch (Throwable throwable) {
            try {
                AipFileUtils.delete((String)tempOrgFileName);
                throw throwable;
            }
            catch (Exception e) {
                return this.responseInfoException(e);
            }
        }
        AipFileUtils.delete((String)tempOrgFileName);
        return responseInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseStream setLabel(RequestStreamSet req) {
        ResponseStream responseStream;
        CheckAip check = this.checkAipRequest(req.getApiGuid(), req.getDispFileName(), "", true);
        if (check.getErrorCode() != 0) {
            return new ResponseStream(check.getErrorCode(), check.getErrorMessage(), check.getDispFileName());
        }
        byte[] fileDataArr = Base64.getDecoder().decode(req.getFileData());
        if (!AipFileUtils.streamToFile((byte[])fileDataArr, (String)check.getReqFileName())) {
            return this.responseStreamFail(req.getDispFileName());
        }
        try {
            SetFileInfo result = this.aipFile.getManager().setLabel(check.getReqFileName(), check.getActualFileName(), req.getEmail(), req.getAipGuid(), "", req.getComment());
            responseStream = this.responseSetStream(result, req.getDispFileName(), check.getActualFileName());
        }
        catch (Throwable throwable) {
            try {
                AipFileUtils.delete((String)check.getReqFileName());
                AipFileUtils.delete((String)check.getActualFileName());
                throw throwable;
            }
            catch (Exception e) {
                return this.responseStreamException(e, req.getDispFileName());
            }
        }
        AipFileUtils.delete((String)check.getReqFileName());
        AipFileUtils.delete((String)check.getActualFileName());
        return responseStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseStream delLabel(RequestStreamDel req) {
        ResponseStream responseStream;
        CheckAip check = this.checkAipRequest(req.getApiGuid(), req.getDispFileName(), "", true);
        if (check.getErrorCode() != 0) {
            return new ResponseStream(check.getErrorCode(), check.getErrorMessage(), check.getDispFileName());
        }
        byte[] fileDataArr = Base64.getDecoder().decode(req.getFileData());
        if (!AipFileUtils.streamToFile((byte[])fileDataArr, (String)check.getReqFileName())) {
            return this.responseStreamFail(req.getDispFileName());
        }
        try {
            SetFileInfo result = this.aipFile.getManager().deleteLabel(check.getReqFileName(), check.getActualFileName(), req.getEmail(), req.getComment(), false);
            responseStream = this.responseSetStream(result, req.getDispFileName(), check.getActualFileName());
        }
        catch (Throwable throwable) {
            try {
                AipFileUtils.delete((String)check.getReqFileName());
                AipFileUtils.delete((String)check.getActualFileName());
                throw throwable;
            }
            catch (Exception e) {
                return this.responseStreamException(e, req.getDispFileName());
            }
        }
        AipFileUtils.delete((String)check.getReqFileName());
        AipFileUtils.delete((String)check.getActualFileName());
        return responseStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseStream setProtection(RequestStreamSet req) {
        ResponseStream responseStream;
        CheckAip check = this.checkAipRequest(req.getApiGuid(), req.getDispFileName(), "", true);
        if (check.getErrorCode() != 0) {
            return new ResponseStream(check.getErrorCode(), check.getErrorMessage(), check.getDispFileName());
        }
        byte[] fileDataArr = Base64.getDecoder().decode(req.getFileData());
        if (!AipFileUtils.streamToFile((byte[])fileDataArr, (String)check.getReqFileName())) {
            return this.responseStreamFail(req.getDispFileName());
        }
        try {
            SetFileInfo result = this.aipFile.getManager().setProtection(check.getReqFileName(), check.getActualFileName(), req.getEmail(), req.getAipGuid(), req.getComment());
            responseStream = this.responseSetStream(result, req.getDispFileName(), check.getActualFileName());
        }
        catch (Throwable throwable) {
            try {
                AipFileUtils.delete((String)check.getReqFileName());
                AipFileUtils.delete((String)check.getActualFileName());
                throw throwable;
            }
            catch (Exception e) {
                return this.responseStreamException(e, req.getDispFileName());
            }
        }
        AipFileUtils.delete((String)check.getReqFileName());
        AipFileUtils.delete((String)check.getActualFileName());
        return responseStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseStream delProtection(RequestStreamDel req) {
        ResponseStream responseStream;
        CheckAip check = this.checkAipRequest(req.getApiGuid(), req.getDispFileName(), "", true);
        if (check.getErrorCode() != 0) {
            return new ResponseStream(check.getErrorCode(), check.getErrorMessage(), check.getDispFileName());
        }
        byte[] fileDataArr = Base64.getDecoder().decode(req.getFileData());
        if (!AipFileUtils.streamToFile((byte[])fileDataArr, (String)check.getReqFileName())) {
            return this.responseStreamFail(req.getDispFileName());
        }
        try {
            SetFileInfo result = this.aipFile.getManager().deleteProtection(check.getReqFileName(), check.getActualFileName(), req.getEmail(), req.getComment());
            responseStream = this.responseSetStream(result, req.getDispFileName(), check.getActualFileName());
        }
        catch (Throwable throwable) {
            try {
                AipFileUtils.delete((String)check.getReqFileName());
                AipFileUtils.delete((String)check.getActualFileName());
                throw throwable;
            }
            catch (Exception e) {
                return this.responseStreamException(e, req.getDispFileName());
            }
        }
        AipFileUtils.delete((String)check.getReqFileName());
        AipFileUtils.delete((String)check.getActualFileName());
        return responseStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseStream setLabelProtection(RequestStreamAllSet req) {
        ResponseStream responseStream;
        CheckAip check = this.checkAipRequest(req.getApiGuid(), req.getDispFileName(), "", true);
        if (check.getErrorCode() != 0) {
            return new ResponseStream(check.getErrorCode(), check.getErrorMessage(), check.getDispFileName());
        }
        byte[] fileDataArr = Base64.getDecoder().decode(req.getFileData());
        if (!AipFileUtils.streamToFile((byte[])fileDataArr, (String)check.getReqFileName())) {
            return this.responseStreamFail(req.getDispFileName());
        }
        try {
            SetFileInfo result = this.aipFile.getManager().setLabel(check.getReqFileName(), check.getActualFileName(), req.getEmail(), req.getLabelGuid(), req.getTemplateGuid(), req.getComment());
            responseStream = this.responseSetStream(result, req.getDispFileName(), check.getActualFileName());
        }
        catch (Throwable throwable) {
            try {
                AipFileUtils.delete((String)check.getReqFileName());
                AipFileUtils.delete((String)check.getActualFileName());
                throw throwable;
            }
            catch (Exception e) {
                return this.responseStreamException(e, req.getDispFileName());
            }
        }
        AipFileUtils.delete((String)check.getReqFileName());
        AipFileUtils.delete((String)check.getActualFileName());
        return responseStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseStream delLabelProtection(RequestStreamDel req) {
        ResponseStream responseStream;
        CheckAip check = this.checkAipRequest(req.getApiGuid(), req.getDispFileName(), "", true);
        if (check.getErrorCode() != 0) {
            return new ResponseStream(check.getErrorCode(), check.getErrorMessage(), check.getDispFileName());
        }
        byte[] fileDataArr = Base64.getDecoder().decode(req.getFileData());
        if (!AipFileUtils.streamToFile((byte[])fileDataArr, (String)check.getReqFileName())) {
            return this.responseStreamFail(req.getDispFileName());
        }
        try {
            SetFileInfo result = this.aipFile.getManager().deleteLabel(check.getReqFileName(), check.getActualFileName(), req.getEmail(), req.getComment(), true);
            responseStream = this.responseSetStream(result, req.getDispFileName(), check.getActualFileName());
        }
        catch (Throwable throwable) {
            try {
                AipFileUtils.delete((String)check.getReqFileName());
                AipFileUtils.delete((String)check.getActualFileName());
                throw throwable;
            }
            catch (Exception e) {
                return this.responseStreamException(e, req.getDispFileName());
            }
        }
        AipFileUtils.delete((String)check.getReqFileName());
        AipFileUtils.delete((String)check.getActualFileName());
        return responseStream;
    }

    public ResponseStream encryptFile(MultipartFile file, RequestBase baseReq) {
        CheckMultipartFile result = this.checkMultipartFile(file);
        if (result.getErrorCode() != 0) {
            return new ResponseStream(result.getErrorCode(), result.getErrorMessage(), result.getDispFileName());
        }
        String savedFileName = this.getRequestFileName(result.getSaveFileName());
        RequestStreamSet req = new RequestStreamSet(baseReq.getApiKey(), baseReq.getEmail(), baseReq.getApiGuid(), "", result.getDispFileName(), AipFileUtils.getFileDataString((String)savedFileName));
        req.setAipGuid(this.repo.getSettings().getSetLabelId());
        req.setComment("SetEncryptStream");
        return this.setLabel(req);
    }

    public ResponseStream decryptFile(MultipartFile file, RequestBase baseReq) {
        CheckMultipartFile result = this.checkMultipartFile(file);
        if (result.getErrorCode() != 0) {
            return new ResponseStream(result.getErrorCode(), result.getErrorMessage(), result.getDispFileName());
        }
        RequestStreamDel req = new RequestStreamDel(baseReq.getApiKey(), baseReq.getEmail(), baseReq.getApiGuid(), "", result.getDispFileName(), result.getSaveFileName(), "DelDecryptStream");
        return this.delLabel(req);
    }
}

