/*
 * Decompiled with CFR 0.152.
 */
package com.aip.gateway.api.aip.manager;

import com.aip.gateway.api.aip.AuthDelegateImpl;
import com.aip.gateway.api.aip.manager.AipFileManagerBase;
import com.aip.gateway.api.aip.model.AipConfig;
import com.aip.gateway.api.aip.model.AipFileInfo;
import com.aip.gateway.api.aip.model.AipFileStatus;
import com.aip.gateway.api.aip.model.AipLabel;
import com.aip.gateway.api.aip.model.AipTemplate;
import com.aip.gateway.api.aip.model.SetFileInfo;
import com.aip.gateway.api.aip.utils.Utilities;
import com.microsoft.informationprotection.IStream;
import com.microsoft.informationprotection.Identity;
import com.microsoft.informationprotection.LogLevel;
import com.microsoft.informationprotection.MIP;
import com.microsoft.informationprotection.MipComponent;
import com.microsoft.informationprotection.MipConfiguration;
import com.microsoft.informationprotection.MipContext;
import com.microsoft.informationprotection.file.FileHandler;
import com.microsoft.informationprotection.file.IFileStatus;
import com.microsoft.informationprotection.internal.protection.TemplateDescriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AipFileManager
extends AipFileManagerBase {
    private static final Logger log = LoggerFactory.getLogger(AipFileManager.class);

    public AipFileManager(AipConfig aipConfig) {
        super(aipConfig);
    }

    public void dispose() {
        this.dispose(true);
    }

    public boolean initialize() {
        try {
            this._authDelegate = new AuthDelegateImpl(this.aipConfig);
        }
        catch (Exception e) {
            this.setError(1, "MIP.Initialize Failed. AuthDelegateImpl Create Failed.", e.getMessage());
            return false;
        }
        try {
            String mipLibPath = System.getProperty("user.dir") + File.separator + "amd64";
            MIP.initialize((MipComponent)MipComponent.FILE, (String)mipLibPath);
        }
        catch (Exception ex) {
            this.setError(1, "MIP.Initialize Failed.", ex.getMessage());
            return false;
        }
        MipConfiguration mipConfiguration = new MipConfiguration(this.appInfo, this.aipConfig.getMipData(), LogLevel.INFO, false);
        this._mipContext = MIP.createMipContext((MipConfiguration)mipConfiguration);
        return true;
    }

    public boolean createProfile() {
        if (!this.checkLoading()) {
            return false;
        }
        if (!this._fileManager.createProfile(this._mipContext)) {
            this.setError(11, "AipFileManager::CreateProfile_fileManager Failed.", this._fileManager.getLastErrMsg());
            return false;
        }
        if (!this._policyManager.createProfile(this._mipContext)) {
            this.setError(12, "AipFileManager::CreateProfile_policyManager Failed.", this._policyManager.getLastErrMsg());
            return false;
        }
        if (!this._protectionManager.createProfile(this._mipContext)) {
            this.setError(13, "AipFileManager::CreateProfile_protectionManager Failed.", this._protectionManager.getLastErrMsg());
            return false;
        }
        return true;
    }

    public boolean createEngine() {
        if (!this.checkLoading()) {
            return false;
        }
        Identity identity = new Identity(this.aipConfig.getEMail());
        if (!this._fileManager.createEngine(identity, this._authDelegate)) {
            this.setError(21, "AipFileManager::CreateEngine_fileManager Failed.", this._fileManager.getLastErrMsg());
            return false;
        }
        if (!this._policyManager.createEngine(identity, this._authDelegate)) {
            this.setError(22, "AipFileManager::CreateEngine_policyManager Failed.", this._policyManager.getLastErrMsg());
            return false;
        }
        if (!this._protectionManager.createEngine(identity, this._authDelegate)) {
            this.setError(23, "AipFileManager::CreateEngine_protectionManager Failed.", this._protectionManager.getLastErrMsg());
            return false;
        }
        return true;
    }

    public List<AipLabel> getSensitivityLabels() {
        if (!this.checkLoading()) {
            return null;
        }
        return this.aipLabel2AppLabel(this._fileManager.getSensitivityLabels());
    }

    public List<AipLabel> getPolicySensitivityLabels() {
        if (!this.checkLoading()) {
            return null;
        }
        return this.aipLabel2AppLabel(this._policyManager.getPolicySensitivityLabels());
    }

    public List<AipTemplate> getTemplates() {
        if (!this.checkLoading()) {
            return null;
        }
        try {
            ArrayList<AipTemplate> result = new ArrayList<AipTemplate>();
            List templates = this._protectionManager.getTemplates();
            if (templates == null) {
                return new ArrayList<AipTemplate>();
            }
            templates.forEach(template -> {
                AipTemplate aipTemplate = Utilities.templateToAip((TemplateDescriptor)template);
                if (aipTemplate != null) {
                    result.add(aipTemplate);
                }
            });
            return result;
        }
        catch (Exception ex) {
            this.setError(33, "AipFileManager::GetTemplates Failed.", ex.getMessage());
            return new ArrayList<AipTemplate>();
        }
    }

    public AipFileInfo getFileInfo(String fileName) {
        if (!this.checkLoading()) {
            return new AipFileInfo(10, "AIP \ub77c\uc774\ube0c\ub7ec\ub9ac\uac00 \ucd08\uae30\ud654 \ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        AipFileInfo fileInfo = this._fileManager.getFileInfo(fileName);
        if (fileInfo == null) {
            this.setError(this._fileManager.getLastErrNo(), "AipFileManager::GetFileInfo Failed.", this._fileManager.getLastErrMsg());
            return new AipFileInfo(11, this._fileManager.getLastErrMsg());
        }
        return fileInfo;
    }

    public AipFileInfo getFileInfo(String fileName, String actualFileName) {
        if (!this.checkLoading()) {
            return new AipFileInfo(10, "AIP \ub77c\uc774\ube0c\ub7ec\ub9ac\uac00 \ucd08\uae30\ud654 \ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        AipFileInfo fileInfo = this._fileManager.getFileInfo(fileName, actualFileName);
        if (fileInfo == null) {
            this.setError(this._fileManager.getLastErrNo(), "AipFileManager::GetFileInfo Failed.", this._fileManager.getLastErrMsg());
            return new AipFileInfo(11, this._fileManager.getLastErrMsg());
        }
        return fileInfo;
    }

    public AipFileInfo getFileInfo(IStream fileStream, String outputFileName) {
        if (!this.checkLoading()) {
            return new AipFileInfo(10, "AIP \ub77c\uc774\ube0c\ub7ec\ub9ac\uac00 \ucd08\uae30\ud654 \ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
        }
        AipFileInfo fileInfo = this._fileManager.getFileInfo(fileStream, outputFileName);
        if (fileInfo == null) {
            this.setError(this._fileManager.getLastErrNo(), "AipFileManager::GetFileInfo Failed.", this._fileManager.getLastErrMsg());
            return new AipFileInfo(11, this._fileManager.getLastErrMsg());
        }
        return fileInfo;
    }

    public AipFileStatus getAipFileStatus(String fileName) {
        try {
            IFileStatus fileStatus = FileHandler.GetFileStatus((String)fileName, (MipContext)this._mipContext);
            return AipFileStatus.builder().isLabeled(fileStatus.IsLabeled()).isProtected(fileStatus.IsProtected()).containsProtectedObjects(fileStatus.ContainsProtectedObjects()).build();
        }
        catch (Exception ex) {
            this.setError(81, "AipFileManager::GetAipFileStatus Failed.", ex.getMessage());
            return null;
        }
    }

    public SetFileInfo setLabel(String fileName, String actualFileName, String email, String labelId, String templateId, String comments) {
        if (Objects.equals(comments, "")) {
            comments = "SetLabel";
        }
        return this._fileManager.setLabel(fileName, actualFileName, email, labelId, templateId, comments);
    }

    public SetFileInfo setLabel(IStream fileStream, String actualFileName, String email, String labelId, String templateId, String comments) {
        if (Objects.equals(comments, "")) {
            comments = "SetLabel by " + email;
        }
        return this._fileManager.setLabel(fileStream, actualFileName, email, labelId, templateId, (String)comments);
    }

    public SetFileInfo deleteLabel(String fileName, String actualFileName, String email, String comments, boolean isDelProtection) {
        if (Objects.equals(comments, "")) {
            comments = "Delete Label by " + email;
        }
        return this._fileManager.deleteLabel(fileName, actualFileName, email, (String)comments, isDelProtection);
    }

    public SetFileInfo deleteLabel(IStream fileStream, String actualFileName, String email, String comments, boolean isDelProtection) {
        if (Objects.equals(comments, "")) {
            comments = "Delete Label by " + email;
        }
        return this._fileManager.deleteLabel(fileStream, actualFileName, email, (String)comments, isDelProtection);
    }

    public SetFileInfo setProtection(String fileName, String actualFileName, String email, String templateId, String comments) {
        if (Objects.equals(comments, "")) {
            comments = "SetProtection by " + email;
        }
        return this._fileManager.setProtection(fileName, actualFileName, email, templateId, (String)comments);
    }

    public SetFileInfo setProtection(IStream fileStream, String actualFileName, String email, String templateId, String comments) {
        if (Objects.equals(comments, "")) {
            comments = "SetProtection by " + email;
        }
        return this._fileManager.setProtection(fileStream, actualFileName, email, templateId, (String)comments);
    }

    public SetFileInfo deleteProtection(String fileName, String actualFileName, String email, String comments) {
        if (Objects.equals(comments, "")) {
            comments = "Delete Protection by " + email;
        }
        return this._fileManager.removeProtection(fileName, actualFileName, email, (String)comments);
    }

    public SetFileInfo deleteProtection(IStream fileStream, String actualFileName, String email, String comments) {
        if (Objects.equals(comments, "")) {
            comments = "Delete Protection by " + email;
        }
        return this._fileManager.removeProtection(fileStream, actualFileName, email, (String)comments);
    }

    public boolean isProtected(IStream inputStream, String filePath) {
        IFileStatus status = FileHandler.GetFileStatus((IStream)inputStream, (String)filePath, (MipContext)this._mipContext);
        return status.IsProtected();
    }

    public boolean isLabeledOrProtected(IStream inputStream, String filePath) {
        IFileStatus status = FileHandler.GetFileStatus((IStream)inputStream, (String)filePath, (MipContext)this._mipContext);
        return status.IsLabeled() || status.IsProtected();
    }

    public boolean isProtected(String filePath) {
        IFileStatus status = FileHandler.GetFileStatus((String)filePath, (MipContext)this._mipContext);
        return status.IsProtected();
    }

    public boolean isLabeledOrProtected(String filePath) {
        IFileStatus status = FileHandler.GetFileStatus((String)filePath, (MipContext)this._mipContext);
        return status.IsLabeled() || status.IsProtected();
    }
}

