/*
 * Decompiled with CFR 0.152.
 */
package com.aip.gateway.api.aip.manager;

import com.aip.gateway.api.aip.AuthDelegateImpl;
import com.aip.gateway.api.aip.manager.FileManager;
import com.aip.gateway.api.aip.manager.PolicyManager;
import com.aip.gateway.api.aip.manager.ProtectionManager;
import com.aip.gateway.api.aip.model.AipConfig;
import com.aip.gateway.api.aip.model.AipLabel;
import com.aip.gateway.api.aip.utils.Utilities;
import com.microsoft.informationprotection.ApplicationInfo;
import com.microsoft.informationprotection.Label;
import com.microsoft.informationprotection.MipContext;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AipFileManagerBase {
    private static final Logger log = LoggerFactory.getLogger(AipFileManagerBase.class);
    private int lastErrNo;
    private String lastErrMsg;
    protected final AipConfig aipConfig;
    protected final ApplicationInfo appInfo;
    protected AuthDelegateImpl _authDelegate;
    protected MipContext _mipContext;
    protected final FileManager _fileManager;
    protected final PolicyManager _policyManager;
    protected final ProtectionManager _protectionManager;

    public AipFileManagerBase(AipConfig aipConfig) {
        this.resetError();
        this.aipConfig = aipConfig;
        this.appInfo = new ApplicationInfo(aipConfig.getClientId(), aipConfig.getAppName(), aipConfig.getAppVersion());
        this._fileManager = new FileManager();
        this._policyManager = new PolicyManager();
        this._protectionManager = new ProtectionManager();
    }

    public void dispose() {
        this.dispose(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose(boolean disposing) {
        AipFileManagerBase aipFileManagerBase = this;
        synchronized (aipFileManagerBase) {
            if (this._fileManager != null) {
                this._fileManager.dispose();
            }
            if (this._policyManager != null) {
                this._policyManager.dispose();
            }
            if (this._protectionManager != null) {
                this._protectionManager.dispose();
            }
            this._authDelegate = null;
        }
    }

    protected void resetError() {
        this.lastErrNo = 0;
        this.lastErrMsg = "";
    }

    protected void setError(int errNo, String errMsg1, String errMsg2) {
        this.lastErrNo = errNo;
        this.lastErrMsg = errMsg2 == null || errMsg2.isEmpty() ? errMsg1 : errMsg1 + "\r\n" + errMsg2;
        log.error("AipFileManager::setError ==> {}, {}", (Object)errNo, (Object)this.lastErrMsg);
    }

    protected boolean checkLoading() {
        if (this._authDelegate == null) {
            this.setError(998, "AipFileManager::AuthDelegate Failed.", "AIP AuthDelegate Is not Initialized.");
        }
        if (this._mipContext == null) {
            this.setError(999, "AipFileManager::MipContext Failed.", "AIP MipContext Is not Initialized.");
        }
        return this._authDelegate != null && this._mipContext != null;
    }

    protected List<AipLabel> aipLabel2AppLabel(List<Label> labels) {
        if (labels == null) {
            return new ArrayList<AipLabel>();
        }
        try {
            ArrayList<AipLabel> result = new ArrayList<AipLabel>();
            labels.forEach(label -> {
                AipLabel aipLabel = Utilities.labelToAip((Label)label);
                if (aipLabel != null) {
                    if (!label.getChildren().isEmpty()) {
                        label.getChildren().forEach(child -> {
                            AipLabel aipChildLabel = Utilities.labelToAip((Label)child);
                            if (aipChildLabel != null) {
                                aipLabel.getChildren().add(aipChildLabel);
                            }
                        });
                    }
                    result.add(aipLabel);
                }
            });
            return result;
        }
        catch (Exception ex) {
            this.setError(31, "AipFileManager::aipLabel2AppLabel Failed.", ex.getMessage());
            return new ArrayList<AipLabel>();
        }
    }

    public int getLastErrNo() {
        return this.lastErrNo;
    }

    public String getLastErrMsg() {
        return this.lastErrMsg;
    }

    public AipConfig getAipConfig() {
        return this.aipConfig;
    }

    public ApplicationInfo getAppInfo() {
        return this.appInfo;
    }

    public AuthDelegateImpl get_authDelegate() {
        return this._authDelegate;
    }

    public MipContext get_mipContext() {
        return this._mipContext;
    }

    public FileManager get_fileManager() {
        return this._fileManager;
    }

    public PolicyManager get_policyManager() {
        return this._policyManager;
    }

    public ProtectionManager get_protectionManager() {
        return this._protectionManager;
    }
}

