/*
 * Decompiled with CFR 0.152.
 */
package com.aip.gateway.api.aip.utils;

import com.microsoft.informationprotection.IStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AipFileStream
implements IStream {
    private static final Logger log = LoggerFactory.getLogger(AipFileStream.class);
    private InputStream inputStream;
    private OutputStream outputStream;

    public AipFileStream(String fileDataString) {
        byte[] fileData = Base64.getDecoder().decode(fileDataString);
        this.inputStream = new ByteArrayInputStream(fileData);
    }

    public long read(byte[] buffer, long position) {
        try {
            this.inputStream.skip(position);
            return this.inputStream.read(buffer);
        }
        catch (IOException e) {
            log.error("read failed. {}", (Object)e.getMessage());
            return -1L;
        }
    }

    public long write(byte[] data) {
        try {
            this.outputStream.write(data);
            return data.length;
        }
        catch (IOException e) {
            log.error("write failed. {}", (Object)e.getMessage());
            return -1L;
        }
    }

    public boolean flush() {
        try {
            this.outputStream.flush();
            return true;
        }
        catch (IOException e) {
            log.error("flush failed. {}", (Object)e.getMessage());
            return false;
        }
    }

    public void seek(long position) {
        try {
            this.inputStream.skip(position);
        }
        catch (IOException e) {
            log.error("seek failed. {}", (Object)e.getMessage());
        }
    }

    public boolean canRead() {
        return true;
    }

    public boolean canWrite() {
        return false;
    }

    public long position() {
        try {
            return this.inputStream.available();
        }
        catch (IOException e) {
            log.error("position failed. {}", (Object)e.getMessage());
            return -1L;
        }
    }

    public long size() {
        try {
            return this.inputStream.available();
        }
        catch (IOException e) {
            log.error("size failed. {}", (Object)e.getMessage());
            return -1L;
        }
    }

    public void size(long newSize) {
    }
}

