/*
 * Decompiled with CFR 0.152.
 */
package com.aip.gateway.api.aop;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

@Aspect
@Component
public class LoggingAspect {
    private static final Logger log = LoggerFactory.getLogger(LoggingAspect.class);

    @Around(value="execution( public * com.aip.gateway.api.controller..*.*(..) )")
    public Object loadingElapsedTime(ProceedingJoinPoint joinPoint) throws Throwable {
        String proceedName = String.format("%50s", joinPoint.getTarget().getClass().getSimpleName() + "." + joinPoint.getSignature().getName());
        log.info("[LOADING...] {}: START.", (Object)proceedName);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start(proceedName);
        Object proceed = joinPoint.proceed();
        stopWatch.stop();
        log.warn("[API-RESULT] {}: ..END. {} ms. Completed.", (Object)proceedName, (Object)stopWatch.getTotalTimeMillis());
        return proceed;
    }
}

