/*
 * Decompiled with CFR 0.152.
 */
package com.aip.gateway.api.config;

import com.aip.gateway.api.utils.SysUtils;
import jakarta.annotation.PostConstruct;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="application")
public class ApplicationConfig {
    private static final Logger log = LoggerFactory.getLogger(ApplicationConfig.class);
    private int aipServerId = 0;
    private int availableProcessors = 8;
    private String bootingDateTime;
    private boolean startSchedule;

    @PostConstruct
    private void init() {
        this.startSchedule = false;
        this.availableProcessors = Runtime.getRuntime().availableProcessors() * 2;
        this.bootingDateTime = SysUtils.getSysTimeStr();
        log.info("{}", (Object)this);
    }

    public boolean makeDirectory(String path, String desc) {
        boolean result = false;
        File folder = new File(path);
        if (!folder.exists()) {
            try {
                result = folder.mkdir();
                log.info("{}, ({}) created.", (Object)folder.getAbsolutePath(), (Object)desc);
            }
            catch (Exception e) {
                log.error("{}, ({}) create failed. {}.", new Object[]{folder.getAbsolutePath(), desc, e.getMessage()});
            }
        }
        return result;
    }

    public int getAipServerId() {
        return this.aipServerId;
    }

    public int getAvailableProcessors() {
        return this.availableProcessors;
    }

    public String getBootingDateTime() {
        return this.bootingDateTime;
    }

    public boolean isStartSchedule() {
        return this.startSchedule;
    }

    public void setAipServerId(int aipServerId) {
        this.aipServerId = aipServerId;
    }

    public void setAvailableProcessors(int availableProcessors) {
        this.availableProcessors = availableProcessors;
    }

    public void setBootingDateTime(String bootingDateTime) {
        this.bootingDateTime = bootingDateTime;
    }

    public void setStartSchedule(boolean startSchedule) {
        this.startSchedule = startSchedule;
    }

    public String toString() {
        return "ApplicationConfig(aipServerId=" + this.getAipServerId() + ", availableProcessors=" + this.getAvailableProcessors() + ", bootingDateTime=" + this.getBootingDateTime() + ", startSchedule=" + this.isStartSchedule() + ")";
    }
}

