/*
 * Decompiled with CFR 0.152.
 */
package com.aip.gateway.api.controller;

import com.aip.gateway.api.controller.BaseController;
import com.aip.gateway.api.model.response.ApiResponseModel;
import com.aip.gateway.api.repository.AppRepository;
import com.aip.gateway.api.repository.GlobalConstants;
import com.aip.gateway.api.service.IApiAipService;
import io.swagger.annotations.ApiOperation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="ApiAip", description="AIP API")
@RestController
@CrossOrigin
@Validated
@RequestMapping(value={"/v1/aip-api/aip"})
public class ApiAipController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(ApiAipController.class);
    private final AppRepository appRepo;
    private final IApiAipService service;

    @Operation(summary="AIP Download", description="AIP Download API.")
    @ApiResponse(responseCode="200", description="AIP Download Success.")
    @ApiOperation(value="AIP Download", response=ApiResponseModel.class)
    @PostMapping(value={"download"}, produces={"application/json; charset=utf8"})
    public ResponseEntity<ApiResponseModel> downloadAipInfo(@Parameter(name="apiKey", description="API Key", example="24826125-188B-4875-A841-F9146DD267F0", required=true) @RequestParam(value="apiKey") String apiKey, HttpServletRequest request) {
        GlobalConstants.setAuthorization((HttpServletRequest)request, (int)10, (String)apiKey, null);
        try {
            int authError = this.appRepo.checkApiKeyValidation(apiKey, this.getRemoteIP(request));
            if (authError != 0) {
                return this.responseApiKeyValidationError(request, authError);
            }
            return this.responseSuccess(request, this.service.downloadAipInfo());
        }
        catch (Exception e) {
            log.error("exception: /v1/aip-api/aip/download, {}", (Object)e.getMessage());
            return this.responseException(request, e);
        }
    }

    @Operation(summary="AIP Label \uc870\ud68c", description="AIP Label \uc870\ud68c.")
    @ApiResponse(responseCode="200", description="AIP Label query success.")
    @ApiOperation(value="AIP Label \uc870\ud68c", response=ApiResponseModel.class, responseContainer="ArrayList")
    @GetMapping(value={"labels"}, produces={"application/json; charset=utf8"})
    public ResponseEntity<ApiResponseModel> getLabels(@Parameter(name="apiKey", description="API Key", example="24826125-188B-4875-A841-F9146DD267F0", required=true) String apiKey, HttpServletRequest request) {
        try {
            GlobalConstants.setAuthorization((HttpServletRequest)request, (int)11, (String)apiKey, null);
            int authError = this.appRepo.checkApiKeyValidation(apiKey, this.getRemoteIP(request));
            if (authError != 0) {
                return this.responseApiKeyValidationError(request, authError);
            }
            List response = this.service.getLabels();
            return ResponseEntity.ok().body((Object)ApiResponseModel.builder().success(true).statusCode(HttpStatus.OK.value()).message("Success").result((Object)response).build());
        }
        catch (Exception e) {
            log.error("exception: /v1/aip-api/aip/labels, {}", (Object)e.getMessage());
            return this.responseException(request, e);
        }
    }

    @Operation(summary="AIP Policies \uc870\ud68c", description="AIP Policies \uc870\ud68c.")
    @ApiResponse(responseCode="200", description="AIP Policies query success.")
    @ApiOperation(value="AIP Policies \uc870\ud68c", response=ApiResponseModel.class, responseContainer="ArrayList")
    @GetMapping(value={"policies"}, produces={"application/json; charset=utf8"})
    public ResponseEntity<ApiResponseModel> getPolicies(@Parameter(name="apiKey", description="API Key", example="24826125-188B-4875-A841-F9146DD267F0", required=true) String apiKey, HttpServletRequest request) {
        try {
            GlobalConstants.setAuthorization((HttpServletRequest)request, (int)12, (String)apiKey, null);
            int authError = this.appRepo.checkApiKeyValidation(apiKey, this.getRemoteIP(request));
            if (authError != 0) {
                return this.responseApiKeyValidationError(request, authError);
            }
            List response = this.service.getPolicies();
            return ResponseEntity.ok().body((Object)ApiResponseModel.builder().success(true).statusCode(HttpStatus.OK.value()).message("Success").result((Object)response).build());
        }
        catch (Exception e) {
            log.error("exception: /v1/aip-api/aip/policies, {}", (Object)e.getMessage());
            return this.responseException(request, e);
        }
    }

    @Operation(summary="AIP Protections \uc870\ud68c", description="AIP Protections \uc870\ud68c.")
    @ApiResponse(responseCode="200", description="AIP Protections query success.")
    @ApiOperation(value="AIP Protections \uc870\ud68c", response=ApiResponseModel.class, responseContainer="ArrayList")
    @GetMapping(value={"protections"}, produces={"application/json; charset=utf8"})
    public ResponseEntity<ApiResponseModel> getLinkedApiKeys(@Parameter(name="apiKey", description="API Key", example="24826125-188B-4875-A841-F9146DD267F0", required=true) String apiKey, HttpServletRequest request) {
        try {
            GlobalConstants.setAuthorization((HttpServletRequest)request, (int)13, (String)apiKey, null);
            int authError = this.appRepo.checkApiKeyValidation(apiKey, this.getRemoteIP(request));
            if (authError != 0) {
                return this.responseApiKeyValidationError(request, authError);
            }
            List response = this.service.getProtections();
            return ResponseEntity.ok().body((Object)ApiResponseModel.builder().success(true).statusCode(HttpStatus.OK.value()).message("Success").result((Object)response).build());
        }
        catch (Exception e) {
            log.error("exception: /v1/aip-api/aip/protections, {}", (Object)e.getMessage());
            return this.responseException(request, e);
        }
    }

    public ApiAipController(AppRepository appRepo, IApiAipService service) {
        this.appRepo = appRepo;
        this.service = service;
    }
}

