/*
 * Decompiled with CFR 0.152.
 */
package com.aip.gateway.api.controller;

import com.aip.gateway.api.controller.BaseController;
import com.aip.gateway.api.model.response.ApiResponseModel;
import com.aip.gateway.api.repository.AppRepository;
import com.aip.gateway.api.repository.GlobalConstants;
import com.aip.gateway.api.service.IApiDbService;
import io.swagger.annotations.ApiOperation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="ApiDb", description="DB API")
@RestController
@CrossOrigin
@Validated
@RequestMapping(value={"/v1/aip-api/db"})
public class ApiDbController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(ApiDbController.class);
    private final AppRepository appRepo;
    private final IApiDbService service;

    @Operation(summary="Db Reload", description="Db Reload API.")
    @ApiResponse(responseCode="200", description="DB Re Loading Success.")
    @ApiOperation(value="Db Reload", response=ApiResponseModel.class)
    @PostMapping(value={"reload"}, produces={"application/json; charset=utf8"})
    public ResponseEntity<ApiResponseModel> reloadDatabase(@Parameter(name="apiKey", description="API Key", example="24826125-188B-4875-A841-F9146DD267F0", required=true) @RequestParam(value="apiKey") String apiKey, HttpServletRequest request) {
        try {
            GlobalConstants.setAuthorization((HttpServletRequest)request, (int)1, (String)apiKey, null);
            int authError = this.appRepo.checkApiKeyValidation(apiKey, this.getRemoteIP(request));
            if (authError != 0) {
                return this.responseApiKeyValidationError(request, authError);
            }
            return this.responseSuccess(request, this.service.reloadDatabase());
        }
        catch (Exception e) {
            log.error("exception: /v1/aip-api/db/reload, {}", (Object)e.getMessage());
            return this.responseException(request, e);
        }
    }

    @Operation(summary="\uc5f0\uacc4 \uc2dc\uc2a4\ud15c \uc870\ud68c", description="\uc5f0\uacc4 \uc2dc\uc2a4\ud15c \uc870\ud68c.")
    @ApiResponse(responseCode="200", description="Linked System query success.")
    @ApiOperation(value="\uc5f0\uacc4 \uc2dc\uc2a4\ud15c \uc870\ud68c", response=ApiResponseModel.class, responseContainer="ArrayList")
    @GetMapping(value={"linked-systems"}, produces={"application/json; charset=utf8"})
    public ResponseEntity<ApiResponseModel> getLinkedSystems(@Parameter(name="apiKey", description="API Key", example="24826125-188B-4875-A841-F9146DD267F0", required=true) String apiKey, HttpServletRequest request) {
        try {
            GlobalConstants.setAuthorization((HttpServletRequest)request, (int)3, (String)apiKey, null);
            int authError = this.appRepo.checkApiKeyValidation(apiKey, this.getRemoteIP(request));
            if (authError != 0) {
                return this.responseApiKeyValidationError(request, authError);
            }
            List response = this.service.getLinkedSystems();
            return ResponseEntity.ok().body((Object)ApiResponseModel.builder().success(true).statusCode(HttpStatus.OK.value()).message("Success").result((Object)response).build());
        }
        catch (Exception e) {
            log.error("exception: /v1/aip-api/db/linked-systems, {}", (Object)e.getMessage());
            return this.responseException(request, e);
        }
    }

    @Operation(summary="\uc5f0\uacc4 \uc11c\ubc84 \uc870\ud68c", description="\uc5f0\uacc4 \uc11c\ubc84 \uc870\ud68c.")
    @ApiResponse(responseCode="200", description="Linked Server query success.")
    @ApiOperation(value="\uc5f0\uacc4 \uc11c\ubc84 \uc870\ud68c", response=ApiResponseModel.class, responseContainer="ArrayList")
    @GetMapping(value={"linked-servers"}, produces={"application/json; charset=utf8"})
    public ResponseEntity<ApiResponseModel> getLinkedServers(@Parameter(name="apiKey", description="API Key", example="24826125-188B-4875-A841-F9146DD267F0", required=true) String apiKey, HttpServletRequest request) {
        try {
            GlobalConstants.setAuthorization((HttpServletRequest)request, (int)4, (String)apiKey, null);
            int authError = this.appRepo.checkApiKeyValidation(apiKey, this.getRemoteIP(request));
            if (authError != 0) {
                return this.responseApiKeyValidationError(request, authError);
            }
            List response = this.service.getLinkedServers();
            return ResponseEntity.ok().body((Object)ApiResponseModel.builder().success(true).statusCode(HttpStatus.OK.value()).message("Success").result((Object)response).build());
        }
        catch (Exception e) {
            log.error("exception: /v1/aip-api/db/linked-servers, {}", (Object)e.getMessage());
            return this.responseException(request, e);
        }
    }

    @Operation(summary="\uc5f0\uacc4 \uc11c\ubc84 API KEY \uc870\ud68c", description="\uc5f0\uacc4 \uc11c\ubc84 API KEY \uc870\ud68c.")
    @ApiResponse(responseCode="200", description="Linked Server API KEY query success.")
    @ApiOperation(value="\uc5f0\uacc4 \uc11c\ubc84 API KEY \uc870\ud68c", response=ApiResponseModel.class, responseContainer="ArrayList")
    @GetMapping(value={"linked-api-keys"}, produces={"application/json; charset=utf8"})
    public ResponseEntity<ApiResponseModel> getLinkedApiKeys(@Parameter(name="apiKey", description="API Key", example="24826125-188B-4875-A841-F9146DD267F0", required=true) String apiKey, HttpServletRequest request) {
        try {
            GlobalConstants.setAuthorization((HttpServletRequest)request, (int)5, (String)apiKey, null);
            int authError = this.appRepo.checkApiKeyValidation(apiKey, this.getRemoteIP(request));
            if (authError != 0) {
                return this.responseApiKeyValidationError(request, authError);
            }
            List response = this.service.getLinkedApiKeys();
            return ResponseEntity.ok().body((Object)ApiResponseModel.builder().success(true).statusCode(HttpStatus.OK.value()).message("Success").result((Object)response).build());
        }
        catch (Exception e) {
            log.error("exception: /v1/aip-api/db/linked-api-keys, {}", (Object)e.getMessage());
            return this.responseException(request, e);
        }
    }

    @Operation(summary="\uc5f0\uacc4 \uc11c\ubc84 Decrypt KEY \uc870\ud68c", description="\uc5f0\uacc4 \uc11c\ubc84 Decrypt KEY \uc870\ud68c.")
    @ApiResponse(responseCode="200", description="Linked Server Decrypt KEY query success.")
    @ApiOperation(value="\uc5f0\uacc4 \uc11c\ubc84 Decrypt KEY \uc870\ud68c", response=ApiResponseModel.class, responseContainer="ArrayList")
    @GetMapping(value={"linked-decrypt-keys"}, produces={"application/json; charset=utf8"})
    public ResponseEntity<ApiResponseModel> getLinkedDecryptKeys(@Parameter(name="apiKey", description="API Key", example="24826125-188B-4875-A841-F9146DD267F0", required=true) String apiKey, HttpServletRequest request) {
        try {
            GlobalConstants.setAuthorization((HttpServletRequest)request, (int)6, (String)apiKey, null);
            int authError = this.appRepo.checkApiKeyValidation(apiKey, this.getRemoteIP(request));
            if (authError != 0) {
                return this.responseApiKeyValidationError(request, authError);
            }
            List response = this.service.getLinkedDecryptKeys();
            return ResponseEntity.ok().body((Object)ApiResponseModel.builder().success(true).statusCode(HttpStatus.OK.value()).message("Success").result((Object)response).build());
        }
        catch (Exception e) {
            log.error("exception: /v1/aip-api/db/linked-decrypt-keys, {}", (Object)e.getMessage());
            return this.responseException(request, e);
        }
    }

    public ApiDbController(AppRepository appRepo, IApiDbService service) {
        this.appRepo = appRepo;
        this.service = service;
    }
}

