/*
 * Decompiled with CFR 0.152.
 */
package com.aip.gateway.api.controller;

import com.aip.gateway.api.model.response.ApiResponseModel;
import com.aip.gateway.api.model.response.GeneralResponse;
import com.aip.gateway.api.model.response.ResponseFile;
import com.aip.gateway.api.model.response.ResponseInfo;
import com.aip.gateway.api.model.response.ResponseStream;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;

public class BaseController {
    protected String getRemoteIP(HttpServletRequest request) {
        if (request == null) {
            return "";
        }
        String ipAddr = request.getHeader("X-FORWARDED-FOR");
        if (ipAddr == null || ipAddr.isEmpty()) {
            ipAddr = request.getHeader("Proxy-Client-IP");
        }
        if (ipAddr == null || ipAddr.isEmpty()) {
            ipAddr = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ipAddr == null || ipAddr.isEmpty()) {
            ipAddr = request.getRemoteAddr();
        }
        if (ipAddr.equals("0:0:0:0:0:0:0:1")) {
            ipAddr = "127.0.0.1";
        }
        request.setAttribute("api-ip-address", (Object)ipAddr);
        return ipAddr;
    }

    protected ResponseEntity<ApiResponseModel> responseSuccess(HttpServletRequest request, GeneralResponse response) {
        return ResponseEntity.ok().body((Object)ApiResponseModel.builder().success(true).statusCode(HttpStatus.OK.value()).message("Success").result((Object)response).build());
    }

    protected ResponseEntity<ApiResponseModel> responseSuccess(HttpServletRequest request, ResponseInfo response) {
        request.setAttribute("api-result", (Object)response);
        return ResponseEntity.ok().body((Object)ApiResponseModel.builder().success(true).statusCode(HttpStatus.OK.value()).message("Success").result((Object)response).build());
    }

    protected ResponseEntity<ApiResponseModel> responseSuccess(HttpServletRequest request, ResponseFile response) {
        request.setAttribute("api-result", (Object)response);
        return ResponseEntity.ok().body((Object)ApiResponseModel.builder().success(true).statusCode(HttpStatus.OK.value()).message("Success").result((Object)response).build());
    }

    protected ResponseEntity<ApiResponseModel> responseSuccess(HttpServletRequest request, ResponseStream response) {
        request.setAttribute("api-result", (Object)response);
        return ResponseEntity.ok().body((Object)ApiResponseModel.builder().success(true).statusCode(HttpStatus.OK.value()).message("Success").result((Object)response).build());
    }

    protected ResponseEntity<ApiResponseModel> responseException(HttpServletRequest request, Exception ex) {
        request.setAttribute("api-result-code", (Object)HttpStatus.INTERNAL_SERVER_ERROR.value());
        request.setAttribute("api-result-message", (Object)ex.getMessage());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)ApiResponseModel.builder().success(false).statusCode(HttpStatus.INTERNAL_SERVER_ERROR.value()).message(ex.getMessage()).result(null).build());
    }

    protected ResponseEntity<ApiResponseModel> responseApiKeyValidationError(HttpServletRequest request, int error) {
        String errorMessage = "";
        errorMessage = error == 1 ? "\ub4f1\ub85d\ub418\uc5b4 \uc788\uc9c0 \uc54a\uc740 API KEY \uc785\ub2c8\ub2e4." : (error == 2 ? "API KEY \uc720\ud6a8\uae30\uac04\uc774 \uc9c0\ub0ac\uc2b5\ub2c8\ub2e4." : (error == 3 ? "\ub4f1\ub85d\ub418\uc5b4 \uc788\uc9c0 \uc54a\uc740 IP Address \uc5d0\uc11c \ud638\ucd9c\ub41c API KEY \uc785\ub2c8\ub2e4." : "API KEY \uc720\ud6a8\uc131 \uac80\uc0ac \uc911 \uc2dc\uc2a4\ud15c \ub0b4\ubd80 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4."));
        request.setAttribute("api-result-code", (Object)error);
        request.setAttribute("api-result-message", (Object)errorMessage);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)ApiResponseModel.builder().success(false).statusCode(HttpStatus.BAD_REQUEST.value()).message(errorMessage).result(null).build());
    }
}

