/*
 * Decompiled with CFR 0.152.
 */
package com.aip.gateway.api.model.app;

import com.aip.gateway.api.aip.model.AipConfig;
import com.aip.gateway.api.model.app.AipSettings;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AipSettings {
    private static final Logger log = LoggerFactory.getLogger(AipSettings.class);
    private String appName;
    private String appVersion;
    private String clientId;
    private String tenantId;
    private String mipData;
    private String domain;
    private String eMail;
    private String secretValue;
    private String certThumbPrint;
    private String loginType;
    private String sourceFileDir;
    private String targetFileDir;
    private String setLabelId;
    private String deleteLabelId;
    private String setTemplateId;
    private String deleteTemplateId;
    private String supportedFileExt;
    private String protectedFileExt;

    public AipConfig getConfig() {
        return AipConfig.builder().appName(this.appName).appVersion(this.appVersion).clientId(this.clientId).tenantId(this.tenantId).mipData(this.mipData).loginType(this.getLoginType()).domain(this.domain).eMail(this.eMail).secretValue(this.secretValue).certThumbPrint(this.certThumbPrint).build();
    }

    private int getLoginType() {
        if (this.loginType == null) {
            return 0;
        }
        if (this.loginType.equalsIgnoreCase("authLoginPassword")) {
            return 1;
        }
        if (this.loginType.equalsIgnoreCase("authLoginCert")) {
            return 2;
        }
        return 0;
    }

    public void setValue(String key, String value) {
        if (key.isEmpty()) {
            return;
        }
        String orgKey = key.trim();
        if (orgKey.equalsIgnoreCase("AppName")) {
            this.appName = value;
        } else if (orgKey.equalsIgnoreCase("AppVersion")) {
            this.appVersion = value;
        } else if (orgKey.equalsIgnoreCase("ClientId")) {
            this.clientId = value;
        } else if (orgKey.equalsIgnoreCase("TenantId")) {
            this.tenantId = value;
        } else if (orgKey.equalsIgnoreCase("MipData")) {
            this.mipData = value;
        } else if (orgKey.equalsIgnoreCase("LoginType")) {
            this.loginType = value;
        } else if (orgKey.equalsIgnoreCase("Domain")) {
            this.domain = value;
        } else if (orgKey.equalsIgnoreCase("EMail")) {
            this.eMail = value;
        } else if (orgKey.equalsIgnoreCase("SecretValue")) {
            this.secretValue = value;
        } else if (orgKey.equalsIgnoreCase("CertThumbPrint")) {
            this.certThumbPrint = value;
        } else if (orgKey.equalsIgnoreCase("SourceFileDir")) {
            this.sourceFileDir = value;
            if (!this.sourceFileDir.substring(this.sourceFileDir.length() - 1).equals(File.separator)) {
                this.sourceFileDir = this.sourceFileDir + File.separator;
            }
        } else if (orgKey.equalsIgnoreCase("TargetFileDir")) {
            this.targetFileDir = value;
            if (!this.targetFileDir.substring(this.targetFileDir.length() - 1).equals(File.separator)) {
                this.targetFileDir = this.targetFileDir + File.separator;
            }
        } else if (orgKey.equalsIgnoreCase("SetLabelId")) {
            this.setLabelId = value;
        } else if (orgKey.equalsIgnoreCase("DeleteLabelId")) {
            this.deleteLabelId = value;
        } else if (orgKey.equalsIgnoreCase("SetTemplateId")) {
            this.setTemplateId = value;
        } else if (orgKey.equalsIgnoreCase("DeleteTemplateId")) {
            this.deleteTemplateId = value;
        } else if (orgKey.equalsIgnoreCase("SupportedFileExt")) {
            this.supportedFileExt = value.trim().toLowerCase();
        } else if (orgKey.equalsIgnoreCase("ProtectedFileExt")) {
            this.protectedFileExt = value.trim().toLowerCase();
        }
    }

    public static AipSettingsBuilder builder() {
        return new AipSettingsBuilder();
    }

    public String getAppName() {
        return this.appName;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getMipData() {
        return this.mipData;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getEMail() {
        return this.eMail;
    }

    public String getSecretValue() {
        return this.secretValue;
    }

    public String getCertThumbPrint() {
        return this.certThumbPrint;
    }

    public String getSourceFileDir() {
        return this.sourceFileDir;
    }

    public String getTargetFileDir() {
        return this.targetFileDir;
    }

    public String getSetLabelId() {
        return this.setLabelId;
    }

    public String getDeleteLabelId() {
        return this.deleteLabelId;
    }

    public String getSetTemplateId() {
        return this.setTemplateId;
    }

    public String getDeleteTemplateId() {
        return this.deleteTemplateId;
    }

    public String getSupportedFileExt() {
        return this.supportedFileExt;
    }

    public String getProtectedFileExt() {
        return this.protectedFileExt;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public void setAppVersion(String appVersion) {
        this.appVersion = appVersion;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setMipData(String mipData) {
        this.mipData = mipData;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setEMail(String eMail) {
        this.eMail = eMail;
    }

    public void setSecretValue(String secretValue) {
        this.secretValue = secretValue;
    }

    public void setCertThumbPrint(String certThumbPrint) {
        this.certThumbPrint = certThumbPrint;
    }

    public void setLoginType(String loginType) {
        this.loginType = loginType;
    }

    public void setSourceFileDir(String sourceFileDir) {
        this.sourceFileDir = sourceFileDir;
    }

    public void setTargetFileDir(String targetFileDir) {
        this.targetFileDir = targetFileDir;
    }

    public void setSetLabelId(String setLabelId) {
        this.setLabelId = setLabelId;
    }

    public void setDeleteLabelId(String deleteLabelId) {
        this.deleteLabelId = deleteLabelId;
    }

    public void setSetTemplateId(String setTemplateId) {
        this.setTemplateId = setTemplateId;
    }

    public void setDeleteTemplateId(String deleteTemplateId) {
        this.deleteTemplateId = deleteTemplateId;
    }

    public void setSupportedFileExt(String supportedFileExt) {
        this.supportedFileExt = supportedFileExt;
    }

    public void setProtectedFileExt(String protectedFileExt) {
        this.protectedFileExt = protectedFileExt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AipSettings)) {
            return false;
        }
        AipSettings other = (AipSettings)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$appName = this.getAppName();
        String other$appName = other.getAppName();
        if (this$appName == null ? other$appName != null : !this$appName.equals(other$appName)) {
            return false;
        }
        String this$appVersion = this.getAppVersion();
        String other$appVersion = other.getAppVersion();
        if (this$appVersion == null ? other$appVersion != null : !this$appVersion.equals(other$appVersion)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$mipData = this.getMipData();
        String other$mipData = other.getMipData();
        if (this$mipData == null ? other$mipData != null : !this$mipData.equals(other$mipData)) {
            return false;
        }
        String this$domain = this.getDomain();
        String other$domain = other.getDomain();
        if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
            return false;
        }
        String this$eMail = this.getEMail();
        String other$eMail = other.getEMail();
        if (this$eMail == null ? other$eMail != null : !this$eMail.equals(other$eMail)) {
            return false;
        }
        String this$secretValue = this.getSecretValue();
        String other$secretValue = other.getSecretValue();
        if (this$secretValue == null ? other$secretValue != null : !this$secretValue.equals(other$secretValue)) {
            return false;
        }
        String this$certThumbPrint = this.getCertThumbPrint();
        String other$certThumbPrint = other.getCertThumbPrint();
        if (this$certThumbPrint == null ? other$certThumbPrint != null : !this$certThumbPrint.equals(other$certThumbPrint)) {
            return false;
        }
        if (this.getLoginType() != other.getLoginType()) {
            return false;
        }
        String this$sourceFileDir = this.getSourceFileDir();
        String other$sourceFileDir = other.getSourceFileDir();
        if (this$sourceFileDir == null ? other$sourceFileDir != null : !this$sourceFileDir.equals(other$sourceFileDir)) {
            return false;
        }
        String this$targetFileDir = this.getTargetFileDir();
        String other$targetFileDir = other.getTargetFileDir();
        if (this$targetFileDir == null ? other$targetFileDir != null : !this$targetFileDir.equals(other$targetFileDir)) {
            return false;
        }
        String this$setLabelId = this.getSetLabelId();
        String other$setLabelId = other.getSetLabelId();
        if (this$setLabelId == null ? other$setLabelId != null : !this$setLabelId.equals(other$setLabelId)) {
            return false;
        }
        String this$deleteLabelId = this.getDeleteLabelId();
        String other$deleteLabelId = other.getDeleteLabelId();
        if (this$deleteLabelId == null ? other$deleteLabelId != null : !this$deleteLabelId.equals(other$deleteLabelId)) {
            return false;
        }
        String this$setTemplateId = this.getSetTemplateId();
        String other$setTemplateId = other.getSetTemplateId();
        if (this$setTemplateId == null ? other$setTemplateId != null : !this$setTemplateId.equals(other$setTemplateId)) {
            return false;
        }
        String this$deleteTemplateId = this.getDeleteTemplateId();
        String other$deleteTemplateId = other.getDeleteTemplateId();
        if (this$deleteTemplateId == null ? other$deleteTemplateId != null : !this$deleteTemplateId.equals(other$deleteTemplateId)) {
            return false;
        }
        String this$supportedFileExt = this.getSupportedFileExt();
        String other$supportedFileExt = other.getSupportedFileExt();
        if (this$supportedFileExt == null ? other$supportedFileExt != null : !this$supportedFileExt.equals(other$supportedFileExt)) {
            return false;
        }
        String this$protectedFileExt = this.getProtectedFileExt();
        String other$protectedFileExt = other.getProtectedFileExt();
        return !(this$protectedFileExt == null ? other$protectedFileExt != null : !this$protectedFileExt.equals(other$protectedFileExt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AipSettings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $appName = this.getAppName();
        result = result * 59 + ($appName == null ? 43 : $appName.hashCode());
        String $appVersion = this.getAppVersion();
        result = result * 59 + ($appVersion == null ? 43 : $appVersion.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $mipData = this.getMipData();
        result = result * 59 + ($mipData == null ? 43 : $mipData.hashCode());
        String $domain = this.getDomain();
        result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
        String $eMail = this.getEMail();
        result = result * 59 + ($eMail == null ? 43 : $eMail.hashCode());
        String $secretValue = this.getSecretValue();
        result = result * 59 + ($secretValue == null ? 43 : $secretValue.hashCode());
        String $certThumbPrint = this.getCertThumbPrint();
        result = result * 59 + ($certThumbPrint == null ? 43 : $certThumbPrint.hashCode());
        result = result * 59 + this.getLoginType();
        String $sourceFileDir = this.getSourceFileDir();
        result = result * 59 + ($sourceFileDir == null ? 43 : $sourceFileDir.hashCode());
        String $targetFileDir = this.getTargetFileDir();
        result = result * 59 + ($targetFileDir == null ? 43 : $targetFileDir.hashCode());
        String $setLabelId = this.getSetLabelId();
        result = result * 59 + ($setLabelId == null ? 43 : $setLabelId.hashCode());
        String $deleteLabelId = this.getDeleteLabelId();
        result = result * 59 + ($deleteLabelId == null ? 43 : $deleteLabelId.hashCode());
        String $setTemplateId = this.getSetTemplateId();
        result = result * 59 + ($setTemplateId == null ? 43 : $setTemplateId.hashCode());
        String $deleteTemplateId = this.getDeleteTemplateId();
        result = result * 59 + ($deleteTemplateId == null ? 43 : $deleteTemplateId.hashCode());
        String $supportedFileExt = this.getSupportedFileExt();
        result = result * 59 + ($supportedFileExt == null ? 43 : $supportedFileExt.hashCode());
        String $protectedFileExt = this.getProtectedFileExt();
        result = result * 59 + ($protectedFileExt == null ? 43 : $protectedFileExt.hashCode());
        return result;
    }

    public String toString() {
        return "AipSettings(appName=" + this.getAppName() + ", appVersion=" + this.getAppVersion() + ", clientId=" + this.getClientId() + ", tenantId=" + this.getTenantId() + ", mipData=" + this.getMipData() + ", domain=" + this.getDomain() + ", eMail=" + this.getEMail() + ", secretValue=" + this.getSecretValue() + ", certThumbPrint=" + this.getCertThumbPrint() + ", loginType=" + this.getLoginType() + ", sourceFileDir=" + this.getSourceFileDir() + ", targetFileDir=" + this.getTargetFileDir() + ", setLabelId=" + this.getSetLabelId() + ", deleteLabelId=" + this.getDeleteLabelId() + ", setTemplateId=" + this.getSetTemplateId() + ", deleteTemplateId=" + this.getDeleteTemplateId() + ", supportedFileExt=" + this.getSupportedFileExt() + ", protectedFileExt=" + this.getProtectedFileExt() + ")";
    }

    public AipSettings(String appName, String appVersion, String clientId, String tenantId, String mipData, String domain, String eMail, String secretValue, String certThumbPrint, String loginType, String sourceFileDir, String targetFileDir, String setLabelId, String deleteLabelId, String setTemplateId, String deleteTemplateId, String supportedFileExt, String protectedFileExt) {
        this.appName = appName;
        this.appVersion = appVersion;
        this.clientId = clientId;
        this.tenantId = tenantId;
        this.mipData = mipData;
        this.domain = domain;
        this.eMail = eMail;
        this.secretValue = secretValue;
        this.certThumbPrint = certThumbPrint;
        this.loginType = loginType;
        this.sourceFileDir = sourceFileDir;
        this.targetFileDir = targetFileDir;
        this.setLabelId = setLabelId;
        this.deleteLabelId = deleteLabelId;
        this.setTemplateId = setTemplateId;
        this.deleteTemplateId = deleteTemplateId;
        this.supportedFileExt = supportedFileExt;
        this.protectedFileExt = protectedFileExt;
    }

    public AipSettings() {
    }
}

