/*
 * Decompiled with CFR 0.152.
 */
package com.aip.gateway.api.process;

import com.aip.gateway.api.app.AppUtils;
import com.aip.gateway.api.config.ThreadPoolInitializer;
import com.aip.gateway.api.dao.mapper.BaseDbMapper;
import com.aip.gateway.api.entity.TbAipCallLog;
import com.aip.gateway.api.entity.TbAipFileJobLog;
import com.aip.gateway.api.process.DbmsData;
import com.aip.gateway.api.process.DbmsDataAsyncTask;
import com.aip.gateway.api.process.DbmsDataProcess;
import com.aip.gateway.api.process.DbmsDataType;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DbmsDataProcess {
    private static final Logger log = LoggerFactory.getLogger(DbmsDataProcess.class);
    private final BaseDbMapper mapper;
    private final LinkedBlockingQueue<DbmsData> dbmsDataBlockingQueue = new LinkedBlockingQueue(1000);
    private final ThreadPoolExecutor taskExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(1);
    private final DbmsDataAsyncTask asyncTask;
    private int maxCore = Runtime.getRuntime().availableProcessors();

    public void run() {
        log.info("DbmsDataProcess.run: Start.");
        if (this.maxCore < 8) {
            this.maxCore = 8;
        }
        ThreadPoolInitializer poolInitializer = (ThreadPoolInitializer)AppUtils.getBean(ThreadPoolInitializer.class);
        int executePool = Math.max(this.maxCore, poolInitializer.getWork());
        for (int ii = 0; ii < executePool; ++ii) {
            this.taskExecutor.execute(() -> {
                boolean isRunning = true;
                while (isRunning) {
                    try {
                        DbmsData data = (DbmsData)this.dbmsDataBlockingQueue.take();
                        this.asyncTask.run(this, data);
                    }
                    catch (Exception e) {
                        log.error("DbmsDataProcess.Task: Exception: {}", (Object)e.getMessage(), (Object)e);
                        Thread.currentThread().interrupt();
                        isRunning = false;
                    }
                }
            });
        }
        log.info("DbmsDataProcess.run: ..End.[OK], {} EA.", (Object)executePool);
    }

    public void runJob(DbmsData data) {
        this.process(data);
    }

    public void process(DbmsData data) {
        int cnt = 0;
        try {
            DbmsDataType type = data.getType();
            switch (1.$SwitchMap$com$aip$gateway$api$process$DbmsDataType[type.ordinal()]) {
                case 1: {
                    TbAipCallLog callLog = (TbAipCallLog)data.getData();
                    cnt = this.mapper.insertAipCallLog(callLog);
                    log.info("DBMS_DATA_API_CALL_LOG: {} EA.", (Object)cnt);
                    break;
                }
                case 2: {
                    TbAipFileJobLog fileJobLog = (TbAipFileJobLog)data.getData();
                    cnt = this.mapper.insertAipFileJobLog(fileJobLog);
                    log.info("DBMS_DATA_AIP_FILE_JOB_LOG: {} EA.", (Object)cnt);
                    break;
                }
                default: {
                    log.error("DbmsJobProcess.process: Unknown Request {}.", (Object)type);
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error("DbmsJobProcess.process: Exception: {}", (Object)e.toString());
        }
    }

    public boolean add(DbmsData data) {
        boolean offer = false;
        try {
            offer = this.dbmsDataBlockingQueue.offer(data);
            if (!offer) {
                log.error("DbmsDataProcess.add: Queue Full Error, Size: {} EA", (Object)this.dbmsDataBlockingQueue.size());
            }
        }
        catch (Exception e) {
            log.error("DbmsDataProcess.add: Exception: {}", (Object)e.getMessage(), (Object)e);
        }
        return offer;
    }

    public DbmsDataProcess(BaseDbMapper mapper, DbmsDataAsyncTask asyncTask) {
        this.mapper = mapper;
        this.asyncTask = asyncTask;
    }
}

