/*
 * Decompiled with CFR 0.152.
 */
package com.aip.gateway.api.repository;

import com.aip.gateway.api.aip.manager.AipFileManager;
import com.aip.gateway.api.dao.mapper.BaseDbMapper;
import com.aip.gateway.api.entity.TbAipLabel;
import com.aip.gateway.api.entity.TbAipPolicy;
import com.aip.gateway.api.entity.TbAipTemplate;
import com.aip.gateway.api.model.response.GeneralResponse;
import com.aip.gateway.api.repository.AppRepository;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AipFileRepository {
    private static final Logger log = LoggerFactory.getLogger(AipFileRepository.class);
    private final AppRepository repo;
    private final BaseDbMapper mapper;
    private AipFileManager manager;

    public boolean initialize() {
        log.info("AipFileManager Initialize And Create: Start.");
        this.manager = new AipFileManager(this.repo.getSettings().getConfig());
        if (!this.manager.initialize()) {
            log.error("AipFileManager.initialize Failed, {}, {}", (Object)this.manager.getLastErrNo(), (Object)this.manager.getLastErrMsg());
            return false;
        }
        if (!this.manager.createProfile()) {
            log.error("AipFileManager.createProfile Failed, {}, {}", (Object)this.manager.getLastErrNo(), (Object)this.manager.getLastErrMsg());
            return false;
        }
        if (!this.manager.createEngine()) {
            log.error("AipFileManager.createEngine Failed, {}, {}", (Object)this.manager.getLastErrNo(), (Object)this.manager.getLastErrMsg());
            return false;
        }
        log.info("AipFileManager Initialize And Create: ..End.[OK]");
        this.downloadAipInfo();
        return true;
    }

    private int downloadAipLabel() {
        ArrayList labels = this.manager.getSensitivityLabels();
        if (labels == null) {
            labels = new ArrayList();
        }
        ConcurrentHashMap aipLabelMap = new ConcurrentHashMap();
        ConcurrentHashMap labelMap = new ConcurrentHashMap();
        List aipLabels = this.mapper.selectAipLabels();
        aipLabels.forEach(obj -> aipLabelMap.put(obj.getLabelGuid(), obj));
        labels.forEach(obj -> {
            labelMap.put(obj.getId(), obj);
            TbAipLabel dbObj = (TbAipLabel)aipLabelMap.get(obj.getId());
            if (dbObj == null) {
                try {
                    this.mapper.insertAipLabel(TbAipLabel.builder().labelId(1).labelGuid(obj.getId()).labelName(obj.getName()).labelDesc(obj.getDescription()).useYn(true).build());
                    log.info("downloadAipLabel.AipLabel Insert: {}, {}, {}", new Object[]{obj.getId(), obj.getName(), obj.getDescription()});
                }
                catch (Exception e) {
                    log.error("downloadAipLabel.AipLabel Insert failed: {}", (Object)e.getMessage());
                }
            } else if (dbObj.isChanged(obj)) {
                try {
                    dbObj.setLabelName(obj.getName());
                    dbObj.setLabelDesc(obj.getDescription());
                    this.mapper.updateAipLabel(dbObj);
                    log.info("downloadAipLabel.AipLabel Update: {}, {}, {}", new Object[]{obj.getId(), obj.getName(), obj.getDescription()});
                }
                catch (Exception e) {
                    log.error("downloadAipLabel.AipLabel Update failed: {}", (Object)e.getMessage());
                }
            }
        });
        this.repo.setLabelMap(labelMap);
        return labels.size();
    }

    private int downloadAipPolicy() {
        ArrayList polities = this.getManager().getPolicySensitivityLabels();
        if (polities == null) {
            polities = new ArrayList();
        }
        ConcurrentHashMap aipPolicyMap = new ConcurrentHashMap();
        ConcurrentHashMap policyMap = new ConcurrentHashMap();
        List aipPolicies = this.mapper.selectAipPolicies();
        aipPolicies.forEach(obj -> aipPolicyMap.put(obj.getPolicyGuid(), obj));
        polities.forEach(obj -> {
            policyMap.put(obj.getId(), obj);
            TbAipPolicy dbObj = (TbAipPolicy)aipPolicyMap.get(obj.getId());
            if (dbObj == null) {
                try {
                    this.mapper.insertAipPolicy(TbAipPolicy.builder().policyId(1).policyGuid(obj.getId()).policyName(obj.getName()).policyDesc(obj.getDescription()).useYn(true).build());
                    log.info("downloadAipPolicy.AipPolicy Insert: {}, {}, {}", new Object[]{obj.getId(), obj.getName(), obj.getDescription()});
                }
                catch (Exception e) {
                    log.error("downloadAipPolicy.AipPolicy Insert failed: {}", (Object)e.getMessage());
                }
            } else if (dbObj.isChanged(obj)) {
                try {
                    dbObj.setPolicyName(obj.getName());
                    dbObj.setPolicyDesc(obj.getDescription());
                    this.mapper.updateAipPolicy(dbObj);
                    log.info("downloadAipPolicy.AipPolicy Update: {}, {}, {}", new Object[]{obj.getId(), obj.getName(), obj.getDescription()});
                }
                catch (Exception e) {
                    log.error("downloadAipPolicy.AipPolicy Update failed: {}", (Object)e.getMessage());
                }
            }
        });
        this.repo.setPolicyMap(policyMap);
        return polities.size();
    }

    private int downloadAipTemplate() {
        ArrayList templates = this.getManager().getTemplates();
        if (templates == null) {
            templates = new ArrayList();
        }
        ConcurrentHashMap aipTemplateMap = new ConcurrentHashMap();
        ConcurrentHashMap templateMap = new ConcurrentHashMap();
        List aipTemplates = this.mapper.selectAipTemplates();
        aipTemplates.forEach(obj -> aipTemplateMap.put(obj.getTemplateGuid(), obj));
        templates.forEach(obj -> {
            templateMap.put(obj.getId(), obj);
            TbAipTemplate dbObj = (TbAipTemplate)aipTemplateMap.get(obj.getId());
            if (dbObj == null) {
                try {
                    this.mapper.insertAipTemplate(TbAipTemplate.builder().templateId(1).templateGuid(obj.getId()).templateName(obj.getName()).templateDesc(obj.getDescription()).useYn(true).build());
                    log.info("downloadAipTemplate.AipTemplate Insert: {}, {}, {}", new Object[]{obj.getId(), obj.getName(), obj.getDescription()});
                }
                catch (Exception e) {
                    log.error("downloadAipTemplate.AipTemplate Insert failed: {}", (Object)e.getMessage());
                }
            } else if (dbObj.isChanged(obj)) {
                try {
                    dbObj.setTemplateName(obj.getName());
                    dbObj.setTemplateDesc(obj.getDescription());
                    this.mapper.updateAipTemplate(dbObj);
                    log.info("downloadAipTemplate.AipTemplate Update: {}, {}, {}", new Object[]{obj.getId(), obj.getName(), obj.getDescription()});
                }
                catch (Exception e) {
                    log.error("downloadAipTemplate.AipTemplate Update failed: {}", (Object)e.getMessage());
                }
            }
        });
        this.repo.setTemplateMap(templateMap);
        return templates.size();
    }

    public GeneralResponse downloadAipInfo() {
        int labels = this.downloadAipLabel();
        int policies = this.downloadAipPolicy();
        int templates = this.downloadAipTemplate();
        return GeneralResponse.builder().errorCode(0).effectCount(labels + policies + templates).errorMessage("Success").build();
    }

    public AppRepository getRepo() {
        return this.repo;
    }

    public BaseDbMapper getMapper() {
        return this.mapper;
    }

    public AipFileManager getManager() {
        return this.manager;
    }

    public AipFileRepository(AppRepository repo, BaseDbMapper mapper) {
        this.repo = repo;
        this.mapper = mapper;
    }
}

