/*
 * Decompiled with CFR 0.152.
 */
package com.aip.gateway.api.repository;

import com.aip.gateway.api.aip.model.AipLabel;
import com.aip.gateway.api.aip.model.AipTemplate;
import com.aip.gateway.api.aip.utils.AipFileUtils;
import com.aip.gateway.api.dto.LinkedApiKeyDto;
import com.aip.gateway.api.dto.LinkedDecryptKeyDto;
import com.aip.gateway.api.model.app.AipSettings;
import java.time.LocalDateTime;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AppRepository {
    private static final Logger log = LoggerFactory.getLogger(AppRepository.class);
    private AipSettings settings = new AipSettings();
    private ConcurrentHashMap<String, String> supportedFileExtMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> protectedFileExtMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> supportedDelFileExtMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> protectedDelFileExtMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, LinkedApiKeyDto> apiKeyMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, LinkedDecryptKeyDto> decryptKeyMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, AipLabel> labelMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, AipLabel> policyMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, AipTemplate> templateMap = new ConcurrentHashMap();

    public int checkApiKeyValidation(String apiKey, String ipAddr) {
        LinkedApiKeyDto key = (LinkedApiKeyDto)this.apiKeyMap.get(apiKey);
        if (key == null) {
            return 1;
        }
        LinkedApiKeyDto server = (LinkedApiKeyDto)key.getServerMap().get(ipAddr);
        if (server == null) {
            return 2;
        }
        LocalDateTime curr = LocalDateTime.now();
        if (curr.isAfter(server.getExpiredAt())) {
            return 3;
        }
        return 0;
    }

    public String getSupportedFileType(String fileName) {
        String fileExt = AipFileUtils.getExtension((String)fileName);
        return (String)this.supportedFileExtMap.get(fileExt);
    }

    public AipSettings getSettings() {
        return this.settings;
    }

    public ConcurrentHashMap<String, String> getSupportedFileExtMap() {
        return this.supportedFileExtMap;
    }

    public ConcurrentHashMap<String, String> getProtectedFileExtMap() {
        return this.protectedFileExtMap;
    }

    public ConcurrentHashMap<String, String> getSupportedDelFileExtMap() {
        return this.supportedDelFileExtMap;
    }

    public ConcurrentHashMap<String, String> getProtectedDelFileExtMap() {
        return this.protectedDelFileExtMap;
    }

    public ConcurrentHashMap<String, LinkedApiKeyDto> getApiKeyMap() {
        return this.apiKeyMap;
    }

    public ConcurrentHashMap<String, LinkedDecryptKeyDto> getDecryptKeyMap() {
        return this.decryptKeyMap;
    }

    public ConcurrentHashMap<String, AipLabel> getLabelMap() {
        return this.labelMap;
    }

    public ConcurrentHashMap<String, AipLabel> getPolicyMap() {
        return this.policyMap;
    }

    public ConcurrentHashMap<String, AipTemplate> getTemplateMap() {
        return this.templateMap;
    }

    public void setSettings(AipSettings settings) {
        this.settings = settings;
    }

    public void setSupportedFileExtMap(ConcurrentHashMap<String, String> supportedFileExtMap) {
        this.supportedFileExtMap = supportedFileExtMap;
    }

    public void setProtectedFileExtMap(ConcurrentHashMap<String, String> protectedFileExtMap) {
        this.protectedFileExtMap = protectedFileExtMap;
    }

    public void setSupportedDelFileExtMap(ConcurrentHashMap<String, String> supportedDelFileExtMap) {
        this.supportedDelFileExtMap = supportedDelFileExtMap;
    }

    public void setProtectedDelFileExtMap(ConcurrentHashMap<String, String> protectedDelFileExtMap) {
        this.protectedDelFileExtMap = protectedDelFileExtMap;
    }

    public void setApiKeyMap(ConcurrentHashMap<String, LinkedApiKeyDto> apiKeyMap) {
        this.apiKeyMap = apiKeyMap;
    }

    public void setDecryptKeyMap(ConcurrentHashMap<String, LinkedDecryptKeyDto> decryptKeyMap) {
        this.decryptKeyMap = decryptKeyMap;
    }

    public void setLabelMap(ConcurrentHashMap<String, AipLabel> labelMap) {
        this.labelMap = labelMap;
    }

    public void setPolicyMap(ConcurrentHashMap<String, AipLabel> policyMap) {
        this.policyMap = policyMap;
    }

    public void setTemplateMap(ConcurrentHashMap<String, AipTemplate> templateMap) {
        this.templateMap = templateMap;
    }
}

