/*
 * Decompiled with CFR 0.152.
 */
package com.aip.gateway.api.scheduler;

import com.aip.gateway.api.config.ApplicationConfig;
import com.aip.gateway.api.model.response.GeneralResponse;
import com.aip.gateway.api.repository.AipFileRepository;
import com.aip.gateway.api.utils.Elapsed;
import jakarta.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@EnableScheduling
@Component
public class SchedulerTask {
    private static final Logger log = LoggerFactory.getLogger(SchedulerTask.class);
    private final ApplicationConfig config;
    protected final AipFileRepository aipFileRepository;

    @PreDestroy
    public void onShutDown() {
        log.error("SchedulerTask.onShutDown");
    }

    @Scheduled(cron="10 * * * * *")
    public void scheduleAipDownload() {
        if (!this.config.isStartSchedule()) {
            return;
        }
        Elapsed elapsed = new Elapsed();
        log.info("SchedulerTask.scheduleAipDownload: Start. {}", (Object)Thread.currentThread().getName());
        boolean result = this.runScheduleAipDownload();
        log.info("SchedulerTask.scheduleAipDownload: ..End. {} ms. result: {}, {}", new Object[]{elapsed.milliSeconds(), result, Thread.currentThread().getName()});
    }

    private boolean runScheduleAipDownload() {
        try {
            GeneralResponse result = this.aipFileRepository.downloadAipInfo();
            return result.getErrorCode() == 0;
        }
        catch (Exception e) {
            log.error("SchedulerTask.runScheduleAipDownload: {}", (Object)e.getMessage());
            return false;
        }
    }

    public SchedulerTask(ApplicationConfig config, AipFileRepository aipFileRepository) {
        this.config = config;
        this.aipFileRepository = aipFileRepository;
    }
}

