/*
 * Decompiled with CFR 0.152.
 */
package com.aip.gateway.api.service;

import com.aip.gateway.api.config.FileStorageConfig;
import com.aip.gateway.api.model.file.FileNotFoundException;
import com.aip.gateway.api.model.file.FileStorageException;
import com.aip.gateway.api.service.IApiFileService;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class FileStorageService {
    private static final Logger log = LoggerFactory.getLogger(FileStorageService.class);
    private final IApiFileService service;
    private final FileStorageConfig config;
    private final Path fileStorageLocation;

    public FileStorageService(IApiFileService service, FileStorageConfig config) {
        this.service = service;
        this.config = config;
        this.fileStorageLocation = Paths.get(config.getUploadDir(), new String[0]).toAbsolutePath().normalize();
        try {
            Files.createDirectories(this.fileStorageLocation, new FileAttribute[0]);
        }
        catch (Exception ex) {
            log.error("init: {}", (Object)ex.getMessage());
            throw new FileStorageException("Could not create the directory where the uploaded files will be stored.", (Throwable)ex);
        }
    }

    public String storeFile(MultipartFile file) {
        String fileName = StringUtils.cleanPath((String)Objects.requireNonNull(file.getOriginalFilename()));
        try {
            if (fileName.contains("..")) {
                throw new FileStorageException("Sorry! Filename contains invalid path sequence " + fileName);
            }
            Path targetLocation = this.fileStorageLocation.resolve(fileName);
            Files.copy(file.getInputStream(), targetLocation, StandardCopyOption.REPLACE_EXISTING);
            return fileName;
        }
        catch (IOException ex) {
            throw new FileStorageException("Could not store file " + fileName + ". Please try again!", (Throwable)ex);
        }
    }

    public Resource loadFileAsResource(String fileName) {
        try {
            Path filePath = this.fileStorageLocation.resolve(fileName).normalize();
            UrlResource resource = new UrlResource(filePath.toUri());
            if (resource.exists()) {
                return resource;
            }
            throw new FileNotFoundException("File not found " + fileName);
        }
        catch (MalformedURLException ex) {
            throw new FileNotFoundException("File not found " + fileName, (Throwable)ex);
        }
    }
}

