/*
 * Decompiled with CFR 0.152.
 */
package com.aip.gateway.api.service.impl;

import com.aip.gateway.api.config.ApplicationConfig;
import com.aip.gateway.api.dao.mapper.BaseDbMapper;
import com.aip.gateway.api.dto.LinkedApiKeyDto;
import com.aip.gateway.api.dto.LinkedDecryptKeyDto;
import com.aip.gateway.api.dto.LinkedServerDto;
import com.aip.gateway.api.dto.LinkedSystemDto;
import com.aip.gateway.api.entity.TbAipConfig;
import com.aip.gateway.api.entity.TbLinkedApiKey;
import com.aip.gateway.api.entity.TbLinkedDecryptKey;
import com.aip.gateway.api.model.app.AipSettings;
import com.aip.gateway.api.model.response.GeneralResponse;
import com.aip.gateway.api.repository.AppRepository;
import com.aip.gateway.api.service.IApiDbService;
import com.aip.gateway.api.utils.StringUtils;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ApiDbService
implements IApiDbService {
    private static final Logger log = LoggerFactory.getLogger(ApiDbService.class);
    private final ApplicationConfig config;
    private final AppRepository appRepo;
    private final BaseDbMapper mapper;

    @PostConstruct
    private void init() {
        this.initAipConfig();
        this.initLinkedApiKeys();
        this.initLinkedDecryptKeys();
    }

    private void initAipConfig() {
        AipSettings settings = new AipSettings();
        ConcurrentHashMap supportedFileExtMap = new ConcurrentHashMap();
        ConcurrentHashMap protectedFileExtMap = new ConcurrentHashMap();
        ConcurrentHashMap supportedDelFileExtMap = new ConcurrentHashMap();
        ConcurrentHashMap protectedDelFileExtMap = new ConcurrentHashMap();
        List lists = this.loadAipConfig();
        lists.forEach(obj -> settings.setValue(obj.getConfigKey(), obj.getConfigValue()));
        this.appRepo.setSettings(settings);
        List supportedLists = StringUtils.split((String)settings.getSupportedFileExt().trim(), (String)";");
        supportedLists.forEach(ext -> {
            if (ext.trim().isEmpty()) {
                return;
            }
            supportedFileExtMap.put(ext.trim(), ext.trim());
            protectedFileExtMap.put(ext.trim(), ext.trim());
            supportedDelFileExtMap.put(ext.trim(), ext.trim());
            protectedDelFileExtMap.put(ext.trim(), ext.trim());
        });
        List protectedLists = StringUtils.split((String)settings.getProtectedFileExt().trim(), (String)";");
        protectedLists.forEach(protectedExt -> {
            if (protectedExt.trim().isEmpty()) {
                return;
            }
            List extLists = StringUtils.split((String)protectedExt.trim(), (String)"-");
            if (extLists.size() != 2) {
                return;
            }
            protectedFileExtMap.put((String)extLists.get(0), (String)extLists.get(1));
            protectedDelFileExtMap.remove(extLists.get(0));
            protectedDelFileExtMap.put((String)extLists.get(1), (String)extLists.get(0));
        });
        this.appRepo.setSupportedFileExtMap(supportedFileExtMap);
        this.appRepo.setProtectedFileExtMap(protectedFileExtMap);
        this.appRepo.setSupportedDelFileExtMap(supportedDelFileExtMap);
        this.appRepo.setProtectedDelFileExtMap(protectedDelFileExtMap);
    }

    private void initLinkedApiKeys() {
        ConcurrentHashMap keyMap = new ConcurrentHashMap();
        List lists = this.loadLinkedApiKeys();
        lists.forEach(obj -> {
            LinkedApiKeyDto key = (LinkedApiKeyDto)keyMap.get(obj.getApiKey());
            if (key == null) {
                LinkedApiKeyDto newKey = obj.toDto();
                keyMap.put(obj.getApiKey(), newKey);
                newKey.getServerMap().put(newKey.getServerIpAddr(), newKey);
            } else {
                LinkedApiKeyDto newKey = obj.toDto();
                key.getServerMap().put(newKey.getServerIpAddr(), newKey);
            }
        });
        this.appRepo.setApiKeyMap(keyMap);
    }

    private void initLinkedDecryptKeys() {
        ConcurrentHashMap keyMap = new ConcurrentHashMap();
        List lists = this.loadLinkedDecryptKeys();
        lists.forEach(obj -> {
            LinkedDecryptKeyDto key = (LinkedDecryptKeyDto)keyMap.get(obj.getDecryptKey());
            if (key == null) {
                LinkedDecryptKeyDto newKey = obj.toDto();
                keyMap.put(obj.getDecryptKey(), newKey);
                newKey.getServerMap().put(newKey.getServerIpAddr(), newKey);
            } else {
                LinkedDecryptKeyDto newKey = obj.toDto();
                key.getServerMap().put(newKey.getServerIpAddr(), newKey);
            }
        });
        this.appRepo.setDecryptKeyMap(keyMap);
    }

    public GeneralResponse reloadDatabase() {
        this.initLinkedApiKeys();
        this.initLinkedDecryptKeys();
        return GeneralResponse.builder().errorCode(0).errorMessage("Success").effectCount(this.appRepo.getApiKeyMap().size() + this.appRepo.getDecryptKeyMap().size()).build();
    }

    public List<LinkedSystemDto> getLinkedSystems() {
        ArrayList<LinkedSystemDto> result = new ArrayList<LinkedSystemDto>();
        List lists = this.mapper.selectLinkedSystems();
        lists.forEach(obj -> result.add(obj.toDto()));
        return result;
    }

    public List<LinkedServerDto> getLinkedServers() {
        ArrayList<LinkedServerDto> result = new ArrayList<LinkedServerDto>();
        List lists = this.mapper.selectLinkedServers();
        lists.forEach(obj -> result.add(obj.toDto()));
        return result;
    }

    public List<LinkedApiKeyDto> getLinkedApiKeys() {
        ArrayList<LinkedApiKeyDto> result = new ArrayList<LinkedApiKeyDto>();
        List lists = this.mapper.selectLinkedApiKeys();
        lists.forEach(obj -> result.add(obj.toDto()));
        return result;
    }

    public List<LinkedDecryptKeyDto> getLinkedDecryptKeys() {
        ArrayList<LinkedDecryptKeyDto> result = new ArrayList<LinkedDecryptKeyDto>();
        List lists = this.mapper.selectLinkedDecryptKeys();
        lists.forEach(obj -> result.add(obj.toDto()));
        return result;
    }

    public List<TbAipConfig> loadAipConfig() {
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        param.put("AIP_SERVER_ID", this.config.getAipServerId());
        return this.mapper.selectAipConfig(param);
    }

    public List<TbLinkedApiKey> loadLinkedApiKeys() {
        return this.mapper.selectLinkedApiKeys();
    }

    public List<TbLinkedDecryptKey> loadLinkedDecryptKeys() {
        return this.mapper.selectLinkedDecryptKeys();
    }

    public ApiDbService(ApplicationConfig config, AppRepository appRepo, BaseDbMapper mapper) {
        this.config = config;
        this.appRepo = appRepo;
        this.mapper = mapper;
    }
}

