/*
 * Decompiled with CFR 0.152.
 */
package com.aip.gateway.api;

import com.aip.gateway.api.LicenseManager;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class LicenseManager {
    private static final Logger log = LoggerFactory.getLogger(LicenseManager.class);

    private static String getComputerName() {
        String hostName = System.getenv("COMPUTERNAME");
        if (hostName == null || hostName.isEmpty()) {
            hostName = "localhost";
        }
        return hostName;
    }

    private static NodeList getXmlNodeList(String filePath, String nodeTag) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            File xmlFile = new File(filePath);
            Document document = documentBuilder.parse(xmlFile);
            document.getDocumentElement().normalize();
            return document.getElementsByTagName(nodeTag);
        }
        catch (ParserConfigurationException e) {
            log.error("getXmlNodeList(ParserConfigurationException): {}, {}: {}", new Object[]{filePath, nodeTag, e.toString()});
        }
        catch (SAXException e) {
            log.error("getXmlNodeList(SAXException): {}, {}: {}", new Object[]{filePath, nodeTag, e.toString()});
        }
        catch (IOException e) {
            log.error("getXmlNodeList(IOException): {}, {}: {}", new Object[]{filePath, nodeTag, e.toString()});
        }
        catch (Exception e) {
            log.error("getXmlNodeList(Exception): {}, {}: {}", new Object[]{filePath, nodeTag, e.toString()});
        }
        return null;
    }

    private static String getElementTagValue(Element element, String tagName) {
        NodeList list = element.getElementsByTagName(tagName);
        if (list == null) {
            return null;
        }
        Node node = list.item(0);
        if (node == null) {
            return null;
        }
        return node.getTextContent().trim();
    }

    private static License errorLicenseItem(License license, int errorCode) {
        license.setErrorCode(errorCode);
        if (errorCode > 20) {
            log.error("License item data validation error: {}", (Object)errorCode);
        } else {
            log.error("License item data not found: {}", (Object)errorCode);
        }
        return license;
    }

    private static boolean errorLicenseItemValue(String orgValue, String curValue, int errorCode) {
        log.error("License value error: {}, {}", (Object)curValue, (Object)errorCode);
        return false;
    }

    private static Date getDay(String dayString) {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Date date = dateFormat.parse(dayString);
            return date;
        }
        catch (ParseException e) {
            return null;
        }
    }

    private static boolean isValidIntegerString(String inputString) {
        try {
            Integer.parseInt(inputString);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static License loadLicenseFile() {
        License license = new License();
        String filePath = System.getProperty("user.dir") + File.separator + "license" + File.separator + "license.xml";
        NodeList nodeList = LicenseManager.getXmlNodeList((String)filePath, (String)"license");
        if (nodeList == null) {
            return license;
        }
        for (int ii = 0; ii < nodeList.getLength(); ++ii) {
            String accounts;
            Node node = nodeList.item(ii);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            String product = LicenseManager.getElementTagValue((Element)element, (String)"product");
            if (product == null) {
                return LicenseManager.errorLicenseItem((License)license, (int)1);
            }
            license.setProduct(product);
            String serialId = LicenseManager.getElementTagValue((Element)element, (String)"serialId");
            if (serialId == null) {
                return LicenseManager.errorLicenseItem((License)license, (int)2);
            }
            license.setSerialId(serialId);
            String issueDay = LicenseManager.getElementTagValue((Element)element, (String)"issueDay");
            if (issueDay == null) {
                return LicenseManager.errorLicenseItem((License)license, (int)3);
            }
            Date day = LicenseManager.getDay((String)issueDay);
            if (day == null) {
                return LicenseManager.errorLicenseItem((License)license, (int)33);
            }
            license.setIssueDay(issueDay);
            license.setStartDate(day);
            String edition = LicenseManager.getElementTagValue((Element)element, (String)"edition");
            if (edition == null) {
                return LicenseManager.errorLicenseItem((License)license, (int)4);
            }
            if (!"standard".equalsIgnoreCase(edition) && !"enterprise".equalsIgnoreCase(edition)) {
                return LicenseManager.errorLicenseItem((License)license, (int)34);
            }
            license.setEdition(edition);
            String type = LicenseManager.getElementTagValue((Element)element, (String)"type");
            if (type == null) {
                return LicenseManager.errorLicenseItem((License)license, (int)5);
            }
            if (!"demo".equalsIgnoreCase(type) && !"product".equalsIgnoreCase(type)) {
                return LicenseManager.errorLicenseItem((License)license, (int)35);
            }
            license.setType(type);
            if ("demo".equalsIgnoreCase(type)) {
                license.setDemo(true);
            }
            if ((accounts = LicenseManager.getElementTagValue((Element)element, (String)"accounts")) == null) {
                return LicenseManager.errorLicenseItem((License)license, (int)6);
            }
            if (!LicenseManager.isValidIntegerString((String)accounts)) {
                return LicenseManager.errorLicenseItem((License)license, (int)36);
            }
            license.setAccounts(Integer.parseInt(accounts));
            String identifiedHost = LicenseManager.getElementTagValue((Element)element, (String)"identifiedHost");
            if (identifiedHost == null) {
                return LicenseManager.errorLicenseItem((License)license, (int)7);
            }
            license.setIdentifiedHost(identifiedHost);
            String signature = LicenseManager.getElementTagValue((Element)element, (String)"signature");
            if (signature == null) {
                return LicenseManager.errorLicenseItem((License)license, (int)8);
            }
            license.setSignature(signature);
            if (!license.isDemo()) continue;
            String demoDuration = LicenseManager.getElementTagValue((Element)element, (String)"demoDuration");
            if (demoDuration == null) {
                return LicenseManager.errorLicenseItem((License)license, (int)9);
            }
            if (!LicenseManager.isValidIntegerString((String)demoDuration)) {
                return LicenseManager.errorLicenseItem((License)license, (int)39);
            }
            license.setDemoDuration(Integer.parseInt(demoDuration));
        }
        license.setValid(true);
        return license;
    }

    public static String getSha256Encrypt(String str) {
        String SHA = "";
        try {
            MessageDigest msgDigest = MessageDigest.getInstance("SHA-256");
            msgDigest.update(str.getBytes(StandardCharsets.UTF_8));
            byte[] byteData = msgDigest.digest();
            StringBuffer builder = new StringBuffer();
            for (byte b : byteData) {
                builder.append(String.format("%02x", b));
            }
            SHA = builder.toString();
        }
        catch (NoSuchAlgorithmException e) {
            SHA = "";
        }
        return SHA;
    }

    public static boolean validateLicense() {
        String identifiedHost;
        log.info("Application License validateLicense: Start.");
        License license = LicenseManager.loadLicenseFile();
        if (!license.isValid()) {
            return false;
        }
        if (license.isDemo()) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(license.getStartDate());
            calendar.add(5, license.getDemoDuration());
            Date resultDate = calendar.getTime();
            Date currentDate = new Date();
            if (!currentDate.before(resultDate)) {
                log.error("License Issue Day expired.");
                return false;
            }
        }
        if (!(identifiedHost = LicenseManager.getComputerName()).equalsIgnoreCase(license.getIdentifiedHost())) {
            return LicenseManager.errorLicenseItemValue((String)identifiedHost, (String)license.getIdentifiedHost(), (int)1);
        }
        String encKey = license.getProduct().toUpperCase() + "hanteinfo12#$!" + license.getSerialId().toLowerCase() + license.getIssueDay() + license.getEdition().toUpperCase() + license.getType().toLowerCase() + String.valueOf(license.getAccounts() + 10000) + license.getIdentifiedHost().toLowerCase();
        String signature = LicenseManager.getSha256Encrypt((String)encKey);
        if (!signature.equalsIgnoreCase(license.getSignature())) {
            return LicenseManager.errorLicenseItemValue((String)signature, (String)license.getSignature(), (int)2);
        }
        System.setProperty("AIP_GATEWAY_ACCOUNT", String.valueOf(license.getAccounts()));
        log.info("Application License validateLicense: ..End.[OK]");
        return true;
    }
}

