/*
 * Decompiled with CFR 0.152.
 */
package com.aip.gateway.api.aip;

import com.aip.gateway.api.aip.AuthDelegateImpl;
import com.aip.gateway.api.aip.ConsentDelegateImpl;
import com.aip.gateway.api.aip.FileOptions;
import com.aip.gateway.api.aip.model.AipConfig;
import com.microsoft.informationprotection.CacheStorageType;
import com.microsoft.informationprotection.ContentLabel;
import com.microsoft.informationprotection.IAuthDelegate;
import com.microsoft.informationprotection.IConsentDelegate;
import com.microsoft.informationprotection.Identity;
import com.microsoft.informationprotection.Label;
import com.microsoft.informationprotection.MIP;
import com.microsoft.informationprotection.MipComponent;
import com.microsoft.informationprotection.MipContext;
import com.microsoft.informationprotection.ProtectionDescriptor;
import com.microsoft.informationprotection.file.FileEngineSettings;
import com.microsoft.informationprotection.file.FileProfileSettings;
import com.microsoft.informationprotection.file.IFileEngine;
import com.microsoft.informationprotection.file.IFileHandler;
import com.microsoft.informationprotection.file.IFileProfile;
import com.microsoft.informationprotection.file.LabelingOptions;
import com.microsoft.informationprotection.file.ProtectionSettings;
import com.microsoft.informationprotection.internal.callback.FileHandlerObserver;
import com.microsoft.informationprotection.internal.gen.FileHandler;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Action {
    private static final Logger log = LoggerFactory.getLogger(Action.class);
    private AuthDelegateImpl authDelegate;
    private IFileProfile fileProfile;
    private IFileEngine fileEngine;
    private MipContext mipContext;
    private String userName;

    public Action(AipConfig aipConfig) throws InterruptedException, ExecutionException {
        try {
            this.authDelegate = new AuthDelegateImpl(aipConfig);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        MIP.initialize((MipComponent)MipComponent.FILE, (String)"C:\\DEV\\SOLUTION\\IIS\\AipGateway.API\\bin\\amd64");
        this.fileProfile = this.CreateFileProfile();
        this.fileEngine = this.CreateFileEngine(this.fileProfile);
    }

    private IFileProfile CreateFileProfile() throws InterruptedException, ExecutionException {
        ConsentDelegateImpl consentDelegate = new ConsentDelegateImpl();
        FileProfileSettings fileProfileSettings = new FileProfileSettings(this.mipContext, CacheStorageType.ON_DISK, (IConsentDelegate)consentDelegate);
        CompletableFuture fileProfileFuture = MIP.loadFileProfileAsync((FileProfileSettings)fileProfileSettings);
        IFileProfile fileProfile = (IFileProfile)fileProfileFuture.get();
        return fileProfile;
    }

    private IFileEngine CreateFileEngine(IFileProfile profile) throws InterruptedException, ExecutionException {
        FileEngineSettings engineSettings = new FileEngineSettings(this.userName, (IAuthDelegate)this.authDelegate, "", "en-US");
        engineSettings.setIdentity(new Identity(this.userName));
        CompletableFuture fileEngineFuture = this.fileProfile.addEngineAsync(engineSettings);
        IFileEngine fileEngine = (IFileEngine)fileEngineFuture.get();
        return fileEngine;
    }

    private IFileHandler CreateFileHandler(FileOptions options, IFileEngine engine) throws InterruptedException, ExecutionException {
        FileHandlerObserver observer = new FileHandlerObserver();
        CompletableFuture handlerFuture = engine.createFileHandlerAsync(options.InputFilePath, options.InputFilePath, options.GenerateChangeAuditEvent, (FileHandler.Observer)observer, null);
        return (IFileHandler)handlerFuture.get();
    }

    public void ListLabels() {
        Collection labels = this.fileEngine.getSensitivityLabels();
        labels.forEach(label -> {
            System.out.println(label.getName() + " : " + label.getId());
            if (label.getChildren().size() > 0) {
                label.getChildren().forEach(child -> System.out.println("\t" + child.getName() + " : " + child.getId()));
            }
        });
    }

    public boolean SetLabel(FileOptions options) throws InterruptedException, ExecutionException {
        IFileHandler fileHandler = this.CreateFileHandler(options, this.fileEngine);
        LabelingOptions labelingOptions = new LabelingOptions();
        labelingOptions.setAssignmentMethod(options.AssignmentMethod);
        Label label = this.fileEngine.getLabelById(options.LabelId);
        fileHandler.setLabel(label, labelingOptions, new ProtectionSettings());
        boolean result = false;
        if (fileHandler.isModified()) {
            result = (Boolean)fileHandler.commitAsync(options.OutputFilePath).get();
        }
        return result;
    }

    public ContentLabel GetLabel(FileOptions options) throws InterruptedException, ExecutionException {
        IFileHandler fileHandler = this.CreateFileHandler(options, this.fileEngine);
        return fileHandler.getLabel();
    }

    public ProtectionDescriptor GetProtection(FileOptions options) throws InterruptedException, ExecutionException {
        IFileHandler fileHandler = this.CreateFileHandler(options, this.fileEngine);
        return fileHandler.getProtection().getProtectionDescriptor();
    }
}

