/*
 * Decompiled with CFR 0.152.
 */
package com.aip.gateway.api.aip.manager;

import com.aip.gateway.api.aip.AuthDelegateImpl;
import com.aip.gateway.api.aip.ConsentDelegateImpl;
import com.aip.gateway.api.aip.manager.AbstractManager;
import com.aip.gateway.api.aip.model.AipContentLabel;
import com.aip.gateway.api.aip.model.AipFileInfo;
import com.aip.gateway.api.aip.model.AipLabelInfo;
import com.aip.gateway.api.aip.model.AipProtection;
import com.aip.gateway.api.aip.model.AipProtectionDescriptor;
import com.aip.gateway.api.aip.model.SetFileInfo;
import com.aip.gateway.api.aip.utils.AipFileUtils;
import com.aip.gateway.api.aip.utils.Utilities;
import com.microsoft.informationprotection.AssignmentMethod;
import com.microsoft.informationprotection.CacheStorageType;
import com.microsoft.informationprotection.IAuthDelegate;
import com.microsoft.informationprotection.IConsentDelegate;
import com.microsoft.informationprotection.IStream;
import com.microsoft.informationprotection.Identity;
import com.microsoft.informationprotection.Label;
import com.microsoft.informationprotection.MIP;
import com.microsoft.informationprotection.MipContext;
import com.microsoft.informationprotection.ProtectionDescriptor;
import com.microsoft.informationprotection.file.FileEngineSettings;
import com.microsoft.informationprotection.file.FileProfileSettings;
import com.microsoft.informationprotection.file.IFileEngine;
import com.microsoft.informationprotection.file.IFileHandler;
import com.microsoft.informationprotection.file.IFileProfile;
import com.microsoft.informationprotection.file.LabelingOptions;
import com.microsoft.informationprotection.file.ProtectionSettings;
import com.microsoft.informationprotection.internal.callback.FileHandlerObserver;
import com.microsoft.informationprotection.internal.file.PFileExtensionBehavior;
import com.microsoft.informationprotection.internal.gen.FileHandler;
import com.microsoft.informationprotection.protection.IProtectionHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileManager
extends AbstractManager {
    private static final Logger log = LoggerFactory.getLogger(FileManager.class);
    private IFileProfile _profile = null;
    private IFileEngine _engine = null;

    public void dispose() {
        this.dispose(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose(boolean disposing) {
        FileManager fileManager = this;
        synchronized (fileManager) {
            if (this._profile != null & this._engine != null) {
                // empty if block
            }
            this._engine = null;
            this._profile = null;
        }
    }

    public boolean createProfile(MipContext mipContext) {
        try {
            ConsentDelegateImpl consentDelegate = new ConsentDelegateImpl();
            FileProfileSettings profileSettings = new FileProfileSettings(mipContext, CacheStorageType.ON_DISK_ENCRYPTED, (IConsentDelegate)consentDelegate);
            CompletableFuture profileFuture = MIP.loadFileProfileAsync((FileProfileSettings)profileSettings);
            this._profile = (IFileProfile)profileFuture.get();
        }
        catch (InterruptedException ie) {
            this.setError(1, "FileManager::createProfile InterruptedException Exception.", ie.getMessage());
            Thread.currentThread().interrupt();
            return false;
        }
        catch (ExecutionException eex) {
            this.setError(2, "FileManager::createProfile ExecutionException Exception.", eex.getMessage());
            return false;
        }
        catch (Exception e) {
            this.setError(3, "FileManager::createProfile Exception.", e.getMessage());
            return false;
        }
        return this._profile != null;
    }

    public boolean createEngine(Identity identity, AuthDelegateImpl authDelegate) {
        try {
            authDelegate.resetError();
            FileEngineSettings engineSettings = new FileEngineSettings(identity.getEmail(), (IAuthDelegate)authDelegate, "", "en-US");
            engineSettings.setIdentity(identity);
            CompletableFuture fileEngineFuture = this._profile.addEngineAsync(engineSettings);
            this._engine = (IFileEngine)fileEngineFuture.get();
        }
        catch (InterruptedException ie) {
            this.setError(1, "FileManager::createEngine InterruptedException Exception.", ie.getMessage());
            Thread.currentThread().interrupt();
            return false;
        }
        catch (ExecutionException eex) {
            this.setError(2, "FileManager::createEngine ExecutionException Exception.", eex.getMessage());
            return false;
        }
        catch (Exception e) {
            this.setError(3, "FileManager::createEngine Exception.", e.getMessage());
            return false;
        }
        return this._engine != null;
    }

    public List<Label> getSensitivityLabels() {
        Collection labels = this._engine.getSensitivityLabels();
        return new ArrayList<Label>(labels);
    }

    public long getFileSize(String fileName) {
        try {
            File file = new File(fileName);
            return file.length();
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    public AipFileInfo getFileInfo(IStream fileStream, String outputFileName) {
        IFileHandler handler = this.createFileHandler(fileStream, outputFileName);
        if (handler == null) {
            log.error("getFileInfo.createFileHandler failed: {}", (Object)this.lastErrMsg);
            return null;
        }
        AipFileInfo result = this.getFileInfo(handler);
        try {
            result.setFileSize(fileStream.size());
        }
        catch (Exception ex) {
            result.setFileSize(0L);
            this.lastErrMsg = ex.getMessage();
        }
        return result;
    }

    public AipFileInfo getFileInfo(String fileName) {
        return this.getFileInfo(fileName, fileName);
    }

    public AipFileInfo getFileInfo(String fileName, String actualFileName) {
        IFileHandler handler = this.createFileHandler(fileName, actualFileName);
        if (handler == null) {
            return null;
        }
        AipFileInfo result = this.getFileInfo(handler);
        if (result != null) {
            result.setFileSize(this.getFileSize(fileName));
        }
        return result;
    }

    private AipFileInfo getFileInfo(IFileHandler handler) {
        if (handler == null) {
            log.error("FileManager.getFileInfo: FileHandler is null");
            return null;
        }
        AipFileInfo fileInfo = new AipFileInfo(0, "");
        fileInfo.setOutputFileName(handler.getOutputFileName());
        if (handler.getLabel() != null) {
            AipContentLabel content = AipContentLabel.builder().creationTime(handler.getLabel().creationTime).assignmentMethod(handler.getLabel().assignmentMethod.ordinal()).isProtectionAppliedFromLabel(handler.getLabel().isProtectionAppliedFromLabel).build();
            fileInfo.setContent(content);
            fileInfo.setLabel(Utilities.labelToAip((Label)handler.getLabel().label));
        }
        if (handler.getProtection() != null) {
            IProtectionHandler protection = handler.getProtection();
            AipProtection aipProtection = AipProtection.builder().owner(protection.getOwner()).issuedTo(protection.getIssuedTo()).isIssuedToOwner(protection.getIsIssuedToOwner()).contentId(protection.getContentId()).auditedExtractAllowed(protection.getAuditedExtractAllowed()).blockSize(protection.getBlockSize()).protectionDescriptor(null).useDeprecatedAlgorithms(protection.getUseDeprecatedAlgorithms()).build();
            fileInfo.setProtection(aipProtection);
            if (handler.getProtection().getProtectionDescriptor() != null) {
                ProtectionDescriptor data = handler.getProtection().getProtectionDescriptor();
                AipProtectionDescriptor descriptor = AipProtectionDescriptor.builder().protectionType(data.getProtectionType().ordinal()).templateId(data.getTemplateId()).labelInformation(new AipLabelInfo("x", "x")).labelId(data.getLabelId()).owner(data.getOwner()).contentId(data.getContentId()).name(data.getName()).description(data.getDescription()).allowOfflineAccess(data.isAllowOfflineAccess()).referrer(data.getReferrer()).contentValidUntil(data.getContentValidUntil()).doubleKeyUrl(data.getDoubleKeyUrl()).build();
                if (data.getLabelInfo() != null) {
                    descriptor.getLabelInformation().setLabelId(data.getLabelInfo().getLabelId());
                    descriptor.getLabelInformation().setTenantId(data.getLabelInfo().getTenantId());
                }
                fileInfo.getProtection().setProtectionDescriptor(descriptor);
            }
        }
        return fileInfo;
    }

    public Label getLabelById(String labelId) {
        Label label;
        try {
            label = this._engine.getLabelById(labelId);
        }
        catch (Exception ex) {
            this.setError(99, "FileManager::GetLabel Failed. Request Label Id: " + labelId, ex.getMessage());
            return null;
        }
        return label;
    }

    private IFileHandler createFileHandler(String inputFile, String outputFile) {
        try {
            if (!AipFileUtils.isExists((String)inputFile)) {
                this.setError(91, "FileManager::createFileHandler Failed.", "\uc694\uccad\ud55c \ud30c\uc77c\uc774 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. " + inputFile);
                return null;
            }
            FileHandlerObserver observer = new FileHandlerObserver();
            CompletableFuture handlerFuture = this._engine.createFileHandlerAsync(inputFile, outputFile, true, (FileHandler.Observer)observer, null);
            return (IFileHandler)handlerFuture.get();
        }
        catch (InterruptedException e) {
            this.setError(93, "FileManager::CreateFileHandler InterruptedException Exception.", e.getMessage());
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            this.setError(94, "FileManager::CreateFileHandler ExecutionException Exception.", e.getMessage());
        }
        return null;
    }

    private IFileHandler createFileHandler(IStream inputStream, String outputFile) {
        if (inputStream == null) {
            this.setError(91, "FileManager::CreateFileHandler Failed.", "\uc694\uccad\ud55c \uc2a4\ud2b8\ub9bc\uc758 \uc815\ubcf4\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
            return null;
        }
        if (outputFile == null || outputFile.isEmpty()) {
            this.setError(92, "FileManager::CreateFileHandler Failed.", "\uc694\uccad\ud55c \ucd9c\ub825 \ud30c\uc77c \uc774\ub985\uc774 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
            return null;
        }
        try {
            FileHandlerObserver observer = new FileHandlerObserver();
            CompletableFuture handlerFuture = this._engine.createFileHandlerAsync(inputStream, outputFile, true, (FileHandler.Observer)observer, null);
            return (IFileHandler)handlerFuture.get();
        }
        catch (InterruptedException e) {
            this.setError(93, "FileManager::CreateFileHandler InterruptedException Exception.", e.getMessage());
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            this.setError(94, "FileManager::CreateFileHandler ExecutionException Exception.", e.getMessage());
        }
        return null;
    }

    public SetFileInfo setLabel(String fileName, String actualFileName, String email, String labelId, String templateId, String comments) {
        IFileHandler handler = this.createFileHandler(fileName, actualFileName);
        return this.setLabel(handler, actualFileName, email, labelId, templateId, comments, this.getFileSize(fileName));
    }

    public SetFileInfo setLabel(IStream fileStream, String actualFileName, String email, String labelId, String templateId, String comments) {
        IFileHandler handler = this.createFileHandler(fileStream, actualFileName);
        return this.setLabel(handler, actualFileName, email, labelId, templateId, comments, fileStream.size());
    }

    private SetFileInfo setLabel(IFileHandler handler, String actualFileName, String email, String labelId, String templateId, String comments, long fileSize) {
        SetFileInfo result = new SetFileInfo();
        if (handler == null) {
            result.errorNo = 201;
            result.errorMsg = this.getLastErrMsg();
            return result;
        }
        result.fileSize = fileSize;
        Label label = this.getLabelById(labelId);
        if (label == null) {
            result.errorNo = 202;
            result.errorMsg = this.getLastErrMsg();
            return result;
        }
        LabelingOptions labelingOptions = this.getLabelingOptions(AssignmentMethod.AUTO, comments, true);
        String ownerEmail = this.getOrgFileInfo(handler, email, result);
        ProtectionSettings protectionSettings = new ProtectionSettings();
        protectionSettings.setPFileExtensionBehavior(PFileExtensionBehavior.Default);
        if (!Objects.equals(ownerEmail, "")) {
            protectionSettings.setDelegatedUserEmail(ownerEmail);
        }
        try {
            handler.setLabel(label, labelingOptions, protectionSettings);
            if (templateId != "") {
                ProtectionDescriptor protectionDescriptor = new ProtectionDescriptor(templateId);
                handler.setProtection(protectionDescriptor, protectionSettings);
            }
        }
        catch (Exception ex) {
            result.errorNo = 203;
            result.errorMsg = ex.getMessage();
            this.setError(53, "FileManager::SetLabel Failed.", ex.getMessage());
            return result;
        }
        boolean isCommitted = this.commitAsync(handler, actualFileName, result);
        if (isCommitted) {
            result.newFileSize = this.getFileSize(actualFileName);
            result.newFileLabelGuid = labelId;
            result.newFileName = actualFileName;
            result.newFileOwner = ownerEmail;
            result.newFileTemplateGuid = labelId;
        } else {
            result.errorNo = 204;
            result.errorMsg = "AIP File CommitAsync Failed.";
            this.setError(53, "FileManager::SetLabel Failed.", "Label Id: " + labelId + ", SetLabel Failed.");
        }
        this.getActionFileInfo(actualFileName, result);
        return result;
    }

    public SetFileInfo deleteLabel(String fileName, String actualFileName, String email, String comments, boolean isDelProtection) {
        String outFileName = actualFileName.isEmpty() ? fileName : actualFileName;
        IFileHandler handler = this.createFileHandler(fileName, outFileName);
        return this.deleteLabel(handler, actualFileName, email, comments, isDelProtection, this.getFileSize(fileName));
    }

    public SetFileInfo deleteLabel(IStream fileStream, String actualFileName, String email, String comments, boolean isDelProtection) {
        IFileHandler handler = this.createFileHandler(fileStream, actualFileName);
        return this.deleteLabel(handler, actualFileName, email, comments, isDelProtection, fileStream.size());
    }

    public SetFileInfo deleteLabel(IFileHandler handler, String actualFileName, String email, String comments, boolean isDelProtection, long fileSize) {
        SetFileInfo result = new SetFileInfo();
        if (handler == null) {
            result.errorNo = 201;
            result.errorMsg = this.getLastErrMsg();
            return result;
        }
        result.fileSize = fileSize;
        LabelingOptions invokeLabelingOptions = this.getLabelingOptions(AssignmentMethod.PRIVILEGED, comments, true);
        String ownerEmail = this.getOrgFileInfo(handler, email, result);
        ProtectionSettings protectionSettings = new ProtectionSettings();
        protectionSettings.setPFileExtensionBehavior(PFileExtensionBehavior.Default);
        if (!Objects.equals(ownerEmail, "")) {
            protectionSettings.setDelegatedUserEmail(ownerEmail);
        }
        try {
            if (isDelProtection && handler.getProtection() != null && (handler.getProtection().getAccessCheck("EXTRACT") || handler.getProtection().getAccessCheck("OWNER"))) {
                handler.removeProtection();
            }
            handler.deleteLabel(invokeLabelingOptions);
        }
        catch (Exception ex) {
            result.errorNo = 203;
            result.errorMsg = ex.getMessage();
            this.setError(53, "FileManager::DeleteLabel Failed.", ex.getMessage());
            return result;
        }
        boolean isCommited = this.commitAsync(handler, actualFileName, result);
        if (isCommited) {
            result.newFileSize = this.getFileSize(actualFileName);
            result.newFileLabelGuid = "";
            result.newFileName = actualFileName;
            result.newFileOwner = ownerEmail;
            result.newFileTemplateGuid = "";
        } else {
            result.errorNo = 204;
            result.errorMsg = "AIP File CommitAsync Failed.";
            this.setError(54, "FileManager::DeleteLabel Failed.", "DeleteLabel Failed by " + ownerEmail);
        }
        this.getActionFileInfo(actualFileName, result);
        return result;
    }

    public SetFileInfo setProtection(String fileName, String actualFileName, String email, String templateId, String comments) {
        IFileHandler handler = this.createFileHandler(fileName, actualFileName);
        return this.setProtection(handler, actualFileName, email, templateId, comments, this.getFileSize(fileName));
    }

    public SetFileInfo setProtection(IStream fileStream, String actualFileName, String email, String templateId, String comments) {
        IFileHandler handler = this.createFileHandler(fileStream, actualFileName);
        return this.setProtection(handler, actualFileName, email, templateId, comments, fileStream.size());
    }

    public SetFileInfo setProtection(IFileHandler handler, String actualFileName, String email, String templateId, String comments, long fileSize) {
        SetFileInfo result = new SetFileInfo();
        if (handler == null) {
            result.errorNo = 201;
            result.errorMsg = this.getLastErrMsg();
            return result;
        }
        result.fileSize = fileSize;
        String ownerEmail = this.getOrgFileInfo(handler, email, result);
        try {
            ProtectionDescriptor protectionDescriptor = new ProtectionDescriptor(templateId);
            ProtectionSettings protectionSettings = new ProtectionSettings();
            protectionSettings.setPFileExtensionBehavior(PFileExtensionBehavior.Default);
            if (!Objects.equals(ownerEmail, "")) {
                protectionSettings.setDelegatedUserEmail(ownerEmail);
            }
            handler.setProtection(protectionDescriptor, protectionSettings);
        }
        catch (Exception ex) {
            result.errorNo = 204;
            result.errorMsg = ex.getMessage();
            this.setError(54, "FileManager::SetProtect Failed.", ex.getMessage());
            return result;
        }
        boolean isCommited = this.commitAsync(handler, actualFileName, result);
        if (isCommited) {
            result.newFileSize = this.getFileSize(actualFileName);
            result.newFileName = actualFileName;
            result.newFileOwner = ownerEmail;
            result.newFileTemplateGuid = "";
        } else {
            result.errorNo = 206;
            result.errorMsg = "AIP File CommitAsync Failed.";
            this.setError(56, "FileManager::SetProtect Failed.", "Template Id: " + templateId + ", SetProtect Failed.");
        }
        this.getActionFileInfo(actualFileName, result);
        return result;
    }

    public SetFileInfo removeProtection(String fileName, String actualFileName, String email, String comments) {
        IFileHandler handler = this.createFileHandler(fileName, actualFileName);
        return this.removeProtection(handler, actualFileName, email, comments, this.getFileSize(fileName));
    }

    public SetFileInfo removeProtection(IStream fileStream, String actualFileName, String email, String comments) {
        IFileHandler handler = this.createFileHandler(fileStream, actualFileName);
        return this.removeProtection(handler, actualFileName, email, comments, fileStream.size());
    }

    public SetFileInfo removeProtection(IFileHandler handler, String actualFileName, String email, String comments, long fileSize) {
        String ownerEmail;
        SetFileInfo result;
        block8: {
            result = new SetFileInfo();
            if (handler == null) {
                result.errorNo = 201;
                result.errorMsg = this.getLastErrMsg();
                return result;
            }
            result.fileSize = fileSize;
            ownerEmail = this.getOrgFileInfo(handler, email, result);
            ProtectionSettings protectionSettings = new ProtectionSettings();
            protectionSettings.setPFileExtensionBehavior(PFileExtensionBehavior.Default);
            if (!Objects.equals(ownerEmail, "")) {
                protectionSettings.setDelegatedUserEmail(ownerEmail);
            }
            try {
                if (handler.getProtection() != null) {
                    if (handler.getProtection().getAccessCheck("EXTRACT") || handler.getProtection().getAccessCheck("OWNER")) {
                        handler.removeProtection();
                    }
                    break block8;
                }
                result.errorNo = 209;
                result.errorMsg = "\ud30c\uc77c\uc5d0 \uc554\ud638\ud654 \uc815\ubcf4\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.";
                return result;
            }
            catch (Exception ex) {
                result.errorNo = 208;
                result.errorMsg = "FileManager::RemoveProtection Failed." + ex.getMessage();
                this.setError(59, "FileManager::RemoveProtection Failed.", ex.getMessage());
                return result;
            }
        }
        boolean isCommited = this.commitAsync(handler, actualFileName, result);
        if (isCommited) {
            result.newFileSize = this.getFileSize(actualFileName);
            result.newFileLabelGuid = "";
            result.newFileName = actualFileName;
            result.newFileOwner = ownerEmail;
            result.newFileTemplateGuid = "";
        } else {
            result.errorNo = 204;
            result.errorMsg = "AIP File CommitAsync Failed.";
            this.setError(53, "FileManager::RemoveProtection Failed.", "RemoveProtection Failed by " + ownerEmail);
        }
        this.getActionFileInfo(actualFileName, result);
        return result;
    }

    private LabelingOptions getLabelingOptions(AssignmentMethod assignmentMethod, String justificationMessage, boolean isDowngradeJustified) {
        LabelingOptions labelingOptions = new LabelingOptions();
        labelingOptions.setAssignmentMethod(assignmentMethod);
        labelingOptions.setJustificationMessage(justificationMessage);
        labelingOptions.setDowngradeJustified(isDowngradeJustified);
        return labelingOptions;
    }

    private String getOrgFileInfo(IFileHandler handler, String email, SetFileInfo result) {
        String ownerEmail = email;
        if (handler.getLabel() != null && handler.getLabel().label != null) {
            result.labelGuid = handler.getLabel().label.getId();
        }
        if (handler.getProtection() != null) {
            ownerEmail = handler.getProtection().getOwner();
            result.fileOwner = handler.getProtection().getOwner();
            if (handler.getProtection().getProtectionDescriptor() != null) {
                result.templateGuid = handler.getProtection().getProtectionDescriptor().getTemplateId();
            }
        }
        return ownerEmail;
    }

    private void getActionFileInfo(String actualFileName, SetFileInfo result) {
        AipFileInfo info = this.getFileInfo(actualFileName);
        if (info != null) {
            if (info.getLabel() != null) {
                result.newFileLabelGuid = info.getLabel().getId();
            }
            if (info.getProtection() != null) {
                result.newFileOwner = info.getProtection().getOwner();
                if (info.getProtection().getProtectionDescriptor() != null) {
                    result.newFileTemplateGuid = info.getProtection().getProtectionDescriptor().getTemplateId();
                }
            }
        }
    }

    private boolean commitAsync(IFileHandler handler, String actualFileName, SetFileInfo result) {
        boolean isCommitted = false;
        if (handler.isModified()) {
            CompletableFuture future = handler.commitAsync(actualFileName);
            try {
                isCommitted = (Boolean)future.get();
            }
            catch (InterruptedException e) {
                result.errorNo = 301;
                result.errorMsg = "AIP File CommitAsync InterruptedException Exception.";
                this.setError(61, "FileManager::commitAsync Failed.", e.getMessage());
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                result.errorNo = 302;
                result.errorMsg = "AIP File CommitAsync ExecutionException Exception.";
                this.setError(62, "FileManager::commitAsync Failed.", e.getMessage());
            }
        }
        return isCommitted;
    }

    public byte[] protect(IProtectionHandler handler, byte[] data) {
        long bufferSize = handler.getProtectedContentLength((long)data.length, true);
        byte[] outputBuffer = new byte[(int)bufferSize];
        handler.encryptBuffer(0L, data, outputBuffer, true);
        return outputBuffer;
    }

    public byte[] unProtect(IProtectionHandler handler, byte[] data) {
        long buffersize = data.length;
        byte[] clearBuffer = new byte[(int)buffersize];
        long bytesDecrypted = handler.decryptBuffer(0L, data, clearBuffer, true);
        byte[] outputBuffer = new byte[(int)bytesDecrypted];
        System.arraycopy(clearBuffer, 0, outputBuffer, 0, (int)bytesDecrypted);
        return outputBuffer;
    }
}

