/*
 * Decompiled with CFR 0.152.
 */
package com.aip.gateway.api.aip.utils;

import com.aip.gateway.api.aip.utils.MsalAbstractTokenCacheProvider;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.CompletableFuture;

public class MemoryTokenCacheWithEviction
extends MsalAbstractTokenCacheProvider {
    private static Cache<String, String> cache = null;
    private long maxSize = 0L;

    public MemoryTokenCacheWithEviction(String cacheKey) {
        this(cacheKey, 100000L);
    }

    public MemoryTokenCacheWithEviction(String cacheKey, long maxSize) {
        super(cacheKey);
        if (cache == null) {
            this.maxSize = maxSize;
            cache = CacheBuilder.newBuilder().maximumSize(maxSize).build();
        }
    }

    protected CompletableFuture<Void> WriteToCache(String cacheKey, String payload) {
        cache.put((Object)cacheKey, (Object)payload);
        return CompletableFuture.completedFuture(null);
    }

    protected CompletableFuture<String> ReadFromCache(String cacheKey) {
        String result = (String)cache.getIfPresent((Object)cacheKey);
        return CompletableFuture.completedFuture(result);
    }
}

