/*
 * Decompiled with CFR 0.152.
 */
package com.aip.gateway.api.controller;

import com.aip.gateway.api.controller.BaseController;
import com.aip.gateway.api.model.request.RequestBase;
import com.aip.gateway.api.model.request.RequestStream;
import com.aip.gateway.api.model.request.RequestStreamAllSet;
import com.aip.gateway.api.model.request.RequestStreamDel;
import com.aip.gateway.api.model.request.RequestStreamSet;
import com.aip.gateway.api.model.response.ApiResponseModel;
import com.aip.gateway.api.repository.AppRepository;
import com.aip.gateway.api.repository.GlobalConstants;
import com.aip.gateway.api.service.IApiStreamService;
import io.swagger.annotations.ApiOperation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Tag(name="ApiStream", description="STREAM AIP API")
@RestController
@CrossOrigin
@Validated
@RequestMapping(value={"/v1/aip-api/stream"})
public class ApiStreamController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(ApiStreamController.class);
    private final AppRepository appRepo;
    private final IApiStreamService service;

    @Operation(summary="Stream Info", description="AIP Stream Information Query.")
    @ApiResponse(responseCode="200", description="AIP Stream Information query Success.")
    @ApiOperation(value="Stream Info", response=ApiResponseModel.class)
    @PostMapping(value={"info"}, produces={"application/json; charset=utf8"})
    public ResponseEntity<ApiResponseModel> getInfo(@Parameter(name="req", description="Stream \uc815\ubcf4 \uc694\uccad \ub370\uc774\ud130", required=true) @RequestBody @Valid RequestStream req, HttpServletRequest request) {
        try {
            GlobalConstants.setAuthorization((HttpServletRequest)request, (int)31, (String)req.getApiKey(), (RequestBase)req);
            int authError = this.appRepo.checkApiKeyValidation(req.getApiKey(), this.getRemoteIP(request));
            if (authError != 0) {
                return this.responseApiKeyValidationError(request, authError);
            }
            return this.responseSuccess(request, this.service.getInfo(req));
        }
        catch (Exception e) {
            log.error("exception: /v1/aip-api/stream/info, {}", (Object)e.getMessage());
            return this.responseException(request, e);
        }
    }

    @Operation(summary="Stream AIP Label \uc124\uc815", description="Stream AIP Label Set.")
    @ApiResponse(responseCode="200", description="Stream AIP Label set success.")
    @ApiOperation(value="Stream AIP Label \uc124\uc815", response=ApiResponseModel.class, responseContainer="ArrayList")
    @PostMapping(value={"set-label"}, produces={"application/json; charset=utf8"})
    public ResponseEntity<ApiResponseModel> setLabel(@Parameter(name="req", description="Stream AIP Label \uc124\uc815 \uc694\uccad \ub370\uc774\ud130", required=true) @RequestBody @Valid RequestStreamSet req, HttpServletRequest request) {
        try {
            GlobalConstants.setAuthorization((HttpServletRequest)request, (int)32, (String)req.getApiKey(), (RequestBase)req);
            int authError = this.appRepo.checkApiKeyValidation(req.getApiKey(), this.getRemoteIP(request));
            if (authError != 0) {
                return this.responseApiKeyValidationError(request, authError);
            }
            return this.responseSuccess(request, this.service.setLabel(req));
        }
        catch (Exception e) {
            log.error("exception: /v1/aip-api/stream/set-label, {}", (Object)e.getMessage());
            return this.responseException(request, e);
        }
    }

    @Operation(summary="Stream AIP Label Delete", description="Stream AIP Label Delete.")
    @ApiResponse(responseCode="200", description="Stream AIP Label delete success.")
    @ApiOperation(value="Stream AIP Label \ud574\uc81c", response=ApiResponseModel.class, responseContainer="ArrayList")
    @PostMapping(value={"delete-label"}, produces={"application/json; charset=utf8"})
    public ResponseEntity<ApiResponseModel> delLabel(@Parameter(name="req", description="Stream AIP Label \ud574\uc81c \uc694\uccad \ub370\uc774\ud130", required=true) @RequestBody @Valid RequestStreamDel req, HttpServletRequest request) {
        try {
            GlobalConstants.setAuthorization((HttpServletRequest)request, (int)33, (String)req.getApiKey(), (RequestBase)req);
            int authError = this.appRepo.checkApiKeyValidation(req.getApiKey(), this.getRemoteIP(request));
            if (authError != 0) {
                return this.responseApiKeyValidationError(request, authError);
            }
            return this.responseSuccess(request, this.service.delLabel(req));
        }
        catch (Exception e) {
            log.error("exception: /v1/aip-api/stream/delete-label, {}", (Object)e.getMessage());
            return this.responseException(request, e);
        }
    }

    @Operation(summary="Stream AIP Protection \uc124\uc815", description="Stream AIP Protection AIP.")
    @ApiResponse(responseCode="200", description="Stream AIP Protection set success.")
    @ApiOperation(value="Stream AIP Protection \uc124\uc815", response=ApiResponseModel.class, responseContainer="ArrayList")
    @PostMapping(value={"set-protection"}, produces={"application/json; charset=utf8"})
    public ResponseEntity<ApiResponseModel> setProtection(@Parameter(name="req", description="Stream AIP Protection \uc124\uc815 \uc694\uccad \ub370\uc774\ud130", required=true) @RequestBody @Valid RequestStreamSet req, HttpServletRequest request) {
        try {
            GlobalConstants.setAuthorization((HttpServletRequest)request, (int)34, (String)req.getApiKey(), (RequestBase)req);
            int authError = this.appRepo.checkApiKeyValidation(req.getApiKey(), this.getRemoteIP(request));
            if (authError != 0) {
                return this.responseApiKeyValidationError(request, authError);
            }
            return this.responseSuccess(request, this.service.setProtection(req));
        }
        catch (Exception e) {
            log.error("exception: /v1/aip-api/stream/set-protection, {}", (Object)e.getMessage());
            return this.responseException(request, e);
        }
    }

    @Operation(summary="Stream AIP Protection Delete", description="Stream AIP Protection Delete.")
    @ApiResponse(responseCode="200", description="Stream AIP Protection delete success.")
    @ApiOperation(value="Stream AIP Protection \ud574\uc81c", response=ApiResponseModel.class, responseContainer="ArrayList")
    @PostMapping(value={"delete-protection"}, produces={"application/json; charset=utf8"})
    public ResponseEntity<ApiResponseModel> delProtection(@Parameter(name="req", description="Stream AIP Protection \ud574\uc81c \uc694\uccad \ub370\uc774\ud130", required=true) @RequestBody @Valid RequestStreamDel req, HttpServletRequest request) {
        try {
            GlobalConstants.setAuthorization((HttpServletRequest)request, (int)35, (String)req.getApiKey(), (RequestBase)req);
            int authError = this.appRepo.checkApiKeyValidation(req.getApiKey(), this.getRemoteIP(request));
            if (authError != 0) {
                return this.responseApiKeyValidationError(request, authError);
            }
            return this.responseSuccess(request, this.service.delProtection(req));
        }
        catch (Exception e) {
            log.error("exception: /v1/aip-api/stream/delete-protection, {}", (Object)e.getMessage());
            return this.responseException(request, e);
        }
    }

    @Operation(summary="Stream AIP Label Or Protection \uc124\uc815", description="Stream AIP Label Or Protection AIP.")
    @ApiResponse(responseCode="200", description="Stream AIP Label Or Protection set success.")
    @ApiOperation(value="Stream AIP Label Or Protection \uc124\uc815", response=ApiResponseModel.class, responseContainer="ArrayList")
    @PostMapping(value={"set-label-protection"}, produces={"application/json; charset=utf8"})
    public ResponseEntity<ApiResponseModel> setLabelProtection(@Parameter(name="req", description="Stream AIP Label Or Protection \uc124\uc815 \uc694\uccad \ub370\uc774\ud130", required=true) @RequestBody @Valid RequestStreamAllSet req, HttpServletRequest request) {
        try {
            GlobalConstants.setAuthorization((HttpServletRequest)request, (int)36, (String)req.getApiKey(), (RequestBase)req);
            int authError = this.appRepo.checkApiKeyValidation(req.getApiKey(), this.getRemoteIP(request));
            if (authError != 0) {
                return this.responseApiKeyValidationError(request, authError);
            }
            return this.responseSuccess(request, this.service.setLabelProtection(req));
        }
        catch (Exception e) {
            log.error("exception: /v1/aip-api/stream/set-label-protection, {}", (Object)e.getMessage());
            return this.responseException(request, e);
        }
    }

    @Operation(summary="Stream AIP Label Or Protection Delete", description="Stream AIP Label Or Protection Delete.")
    @ApiResponse(responseCode="200", description="Stream AIP Label Or Protection delete success.")
    @ApiOperation(value="Stream AIP Label Or Protection \ud574\uc81c", response=ApiResponseModel.class, responseContainer="ArrayList")
    @PostMapping(value={"delete-label-protection"}, produces={"application/json; charset=utf8"})
    public ResponseEntity<ApiResponseModel> delLabelProtection(@Parameter(name="req", description="Stream AIP Label Or Protection \ud574\uc81c \uc694\uccad \ub370\uc774\ud130", required=true) @RequestBody @Valid RequestStreamDel req, HttpServletRequest request) {
        try {
            GlobalConstants.setAuthorization((HttpServletRequest)request, (int)37, (String)req.getApiKey(), (RequestBase)req);
            int authError = this.appRepo.checkApiKeyValidation(req.getApiKey(), this.getRemoteIP(request));
            if (authError != 0) {
                return this.responseApiKeyValidationError(request, authError);
            }
            return this.responseSuccess(request, this.service.delLabelProtection(req));
        }
        catch (Exception e) {
            log.error("exception: /v1/aip-api/stream/delete-label-protection, {}", (Object)e.getMessage());
            return this.responseException(request, e);
        }
    }

    @Operation(summary="Encrypt Stream", description="Encrypt Stream.")
    @ApiResponse(responseCode="200", description="Encrypt Stream set success.")
    @ApiOperation(value="Encrypt Stream", response=ApiResponseModel.class, responseContainer="ArrayList")
    @PostMapping(value={"encrypt"}, consumes={"multipart/form-data"}, produces={"application/json"})
    public ResponseEntity<ApiResponseModel> encryptFile(@Parameter(description="multipart/form-data \ud615\uc2dd\uc758 \ud30c\uc77c\uc744 input \uc73c\ub85c \ubc1b\uc2b5\ub2c8\ub2e4. \uc774\ub54c key \uac12\uc740 multipartFile \uc785\ub2c8\ub2e4.") @RequestParam(value="file") MultipartFile file, @RequestParam(value="apiKey") String apiKey, @RequestParam(value="email") String email, HttpServletRequest request) {
        try {
            RequestBase baseReq = RequestBase.builder().apiKey(apiKey).decryptKey("").email(email).apiGuid("").build();
            GlobalConstants.setAuthorization((HttpServletRequest)request, (int)28, (String)apiKey, (RequestBase)baseReq);
            int authError = this.appRepo.checkApiKeyValidation(apiKey, this.getRemoteIP(request));
            if (authError != 0) {
                return this.responseApiKeyValidationError(request, authError);
            }
            return this.responseSuccess(request, this.service.encryptFile(file, baseReq));
        }
        catch (Exception e) {
            log.error("exception: /v1/aip-api/stream/encrypt, {}", (Object)e.getMessage());
            return this.responseException(request, e);
        }
    }

    @Operation(summary="Decrypt Stream", description="Decrypt Stream.")
    @ApiResponse(responseCode="200", description="Decrypt Stream set success.")
    @ApiOperation(value="Decrypt Stream", response=ApiResponseModel.class, responseContainer="ArrayList")
    @PostMapping(value={"decrypt"}, consumes={"multipart/form-data"}, produces={"application/json"})
    public ResponseEntity<ApiResponseModel> decryptFile(@Parameter(description="multipart/form-data \ud615\uc2dd\uc758 \ud30c\uc77c\uc744 input \uc73c\ub85c \ubc1b\uc2b5\ub2c8\ub2e4. \uc774\ub54c key \uac12\uc740 multipartFile \uc785\ub2c8\ub2e4.") @RequestParam(value="file") MultipartFile file, @RequestParam(value="apiKey") String apiKey, @RequestParam(value="email") String email, HttpServletRequest request) {
        try {
            RequestBase baseReq = RequestBase.builder().apiKey(apiKey).decryptKey("").email(email).apiGuid("").build();
            GlobalConstants.setAuthorization((HttpServletRequest)request, (int)29, (String)apiKey, (RequestBase)baseReq);
            int authError = this.appRepo.checkApiKeyValidation(apiKey, this.getRemoteIP(request));
            if (authError != 0) {
                return this.responseApiKeyValidationError(request, authError);
            }
            return this.responseSuccess(request, this.service.decryptFile(file, baseReq));
        }
        catch (Exception e) {
            log.error("exception: /v1/aip-api/stream/decrypt, {}", (Object)e.getMessage());
            return this.responseException(request, e);
        }
    }

    public ApiStreamController(AppRepository appRepo, IApiStreamService service) {
        this.appRepo = appRepo;
        this.service = service;
    }
}

