/*
 * Decompiled with CFR 0.152.
 */
package com.aip.gateway.api.interceptor;

import com.aip.gateway.api.entity.TbAipCallLog;
import com.aip.gateway.api.entity.TbAipFileJobLog;
import com.aip.gateway.api.model.response.ResponseBase;
import com.aip.gateway.api.process.DbmsData;
import com.aip.gateway.api.process.DbmsDataProcess;
import com.aip.gateway.api.process.DbmsDataType;
import com.aip.gateway.api.repository.GlobalConstants;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;
import java.time.LocalDateTime;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.ContentCachingResponseWrapper;

public class AipApiControllerInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AipApiControllerInterceptor.class);
    private final DbmsDataProcess dbmsDataProcess;
    private final ObjectMapper objectMapper;

    public AipApiControllerInterceptor(DbmsDataProcess dbmsDataProcess) {
        this.dbmsDataProcess = dbmsDataProcess;
        this.objectMapper = new ObjectMapper();
    }

    private String getResponseBody(HttpServletResponse response) {
        ContentCachingResponseWrapper responseWrapper = (ContentCachingResponseWrapper)response;
        byte[] contentAsByteArray = responseWrapper.getContentAsByteArray();
        try {
            return new String(contentAsByteArray, response.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException e) {
            log.error("getResponseBody UnsupportedEncodingException: {}", (Object)e.getMessage());
            return "";
        }
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String apiGuid = UUID.randomUUID().toString();
        request.setAttribute("api-guid", (Object)apiGuid);
        request.setAttribute("api-start-tm", (Object)LocalDateTime.now());
        request.setAttribute("api-start-milliseconds", (Object)System.currentTimeMillis());
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        ResponseBase res;
        int apiId;
        long endTime = System.currentTimeMillis();
        long startTime = GlobalConstants.getAttributeLong((HttpServletRequest)request, (String)"api-start-milliseconds");
        int errorCode = 0;
        String errorMessage = "";
        int responseStatusCode = response.getStatus();
        if (responseStatusCode != HttpStatus.OK.value()) {
            errorCode = GlobalConstants.getAttributeInt((HttpServletRequest)request, (String)"api-result-code");
            errorMessage = GlobalConstants.getAttributeStr((HttpServletRequest)request, (String)"api-result-message");
        }
        String apiGuid = GlobalConstants.getApiGuid((HttpServletRequest)request);
        String apiKey = GlobalConstants.getApiKey((HttpServletRequest)request);
        TbAipCallLog callLog = TbAipCallLog.builder().apiEndPoint(request.getRequestURI()).apiGuid(apiGuid).ipAddress(GlobalConstants.getAttributeStr((HttpServletRequest)request, (String)"api-ip-address")).requestAt((LocalDateTime)request.getAttribute("api-start-tm")).responseAt(LocalDateTime.now()).responseStatusCode(responseStatusCode).errorCode(errorCode).errorMessage(errorMessage).responseTime((int)(endTime - startTime)).build();
        this.dbmsDataProcess.add(new DbmsData(DbmsDataType.DBMS_DATA_API_CALL_LOG, false, (Object)callLog));
        if (responseStatusCode == HttpStatus.OK.value() && ((apiId = GlobalConstants.getApiId((HttpServletRequest)request)) >= 21 && apiId <= 29 || apiId >= 31 || apiId <= 37) && (res = (ResponseBase)request.getAttribute("api-result")) != null) {
            TbAipFileJobLog fileJobLog = new TbAipFileJobLog(apiId, apiGuid, apiGuid, callLog.getIpAddress(), apiKey);
            fileJobLog.setDecryptKey(GlobalConstants.getAttributeStr((HttpServletRequest)request, (String)"api-decrypt-key"));
            fileJobLog.setJobOwner(GlobalConstants.getAttributeStr((HttpServletRequest)request, (String)"api-job-owner"));
            fileJobLog.setJobResult(res.getErrorCode());
            fileJobLog.setJobMessage(res.getErrorMessage());
            fileJobLog.setFileName(res.getDispFileName());
            fileJobLog.setFileOwner(res.getFileOwner());
            fileJobLog.setFileExt(res.getFileExt());
            fileJobLog.setFileSize(res.getFileSize());
            fileJobLog.setFileLabelGuid(res.getFileLabelGuid());
            fileJobLog.setFileProtectionGuid(res.getFileProtectionGuid());
            fileJobLog.setNewFileName(res.getNewFileName());
            fileJobLog.setNewFileOwner(res.getNewFileOwner());
            fileJobLog.setNewFileExt(res.getNewFileExt());
            fileJobLog.setNewFileSize(res.getNewFileSize());
            fileJobLog.setNewFileLabelGuid(res.getNewFileLabelGuid());
            fileJobLog.setNewFileProtectionGuid(res.getNewFileProtectionGuid());
            log.error("{}", (Object)fileJobLog);
            this.dbmsDataProcess.add(new DbmsData(DbmsDataType.DBMS_DATA_AIP_FILE_JOB_LOG, false, (Object)fileJobLog));
        }
    }
}

