/*
 * Decompiled with CFR 0.152.
 */
package com.aip.gateway.api.service.impl;

import com.aip.gateway.api.aip.model.AipFileInfo;
import com.aip.gateway.api.aip.model.SetFileInfo;
import com.aip.gateway.api.aip.utils.AipFileUtils;
import com.aip.gateway.api.model.app.CheckAip;
import com.aip.gateway.api.model.app.CheckMultipartFile;
import com.aip.gateway.api.model.response.ResponseBase;
import com.aip.gateway.api.model.response.ResponseFile;
import com.aip.gateway.api.model.response.ResponseInfo;
import com.aip.gateway.api.model.response.ResponseStream;
import com.aip.gateway.api.repository.AipFileRepository;
import com.aip.gateway.api.repository.AppRepository;
import com.aip.gateway.api.utils.TimeUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

abstract class AbstractAipService {
    private static final Logger log = LoggerFactory.getLogger(AbstractAipService.class);
    protected final AppRepository repo;
    protected final AipFileRepository aipFile;

    protected String getRequestFileName(String realFileName) {
        return this.repo.getSettings().getSourceFileDir() + realFileName;
    }

    protected String getActualFileName(String fileName) {
        return this.repo.getSettings().getTargetFileDir() + fileName;
    }

    protected String getSupportedFileType(String reqFileName) {
        return this.repo.getSupportedFileType(reqFileName);
    }

    protected CheckAip checkAipRequest(String apiGuid, String dispFileName, String realFileName, boolean isStream) {
        String reqFileName = "";
        if (isStream) {
            reqFileName = this.getRequestFileName(apiGuid + AipFileUtils.getExtension((String)dispFileName));
        } else {
            reqFileName = this.getRequestFileName(realFileName);
            if (!AipFileUtils.isExists((String)reqFileName)) {
                return new CheckAip(101, "\ud30c\uc77c\uc774 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.", dispFileName);
            }
        }
        String newFileExt = this.getSupportedFileType(reqFileName);
        if (newFileExt == null) {
            return new CheckAip(102, "\uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 \ud30c\uc77c\ud615\uc2dd \uc785\ub2c8\ub2e4.", dispFileName);
        }
        CheckAip result = new CheckAip(0, "Success", dispFileName);
        result.setReqFileName(reqFileName);
        result.setNewFileExt(newFileExt);
        if (isStream) {
            result.setDispFileName(AipFileUtils.getFileNameWithoutExtension((String)dispFileName) + newFileExt);
        } else {
            result.setDispFileName(AipFileUtils.getFileNameWithoutExtension((String)realFileName) + newFileExt);
        }
        result.setActualFileName(this.getActualFileName(apiGuid + newFileExt));
        return result;
    }

    protected ResponseFile responseFileException(Exception exception, String displayFileName) {
        log.error("responseFileException: {}", (Object)exception.getMessage());
        return new ResponseFile(109, "\uc791\uc5c5 \uc911\uc5d0 \uc2dc\uc2a4\ud15c \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.", displayFileName);
    }

    protected ResponseStream responseStreamException(Exception exception, String displayFileName) {
        log.error("responseFileException: {}", (Object)exception.getMessage());
        return new ResponseStream(109, "\uc791\uc5c5 \uc911\uc5d0 \uc2dc\uc2a4\ud15c \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.", displayFileName);
    }

    private ResponseBase responseBase(SetFileInfo fileInfo, String displayFileName, String actualFileName) {
        ResponseBase result = new ResponseBase(fileInfo.errorNo, fileInfo.errorMsg, displayFileName);
        result.setFileExt(AipFileUtils.getExtension((String)displayFileName));
        result.setFileOwner(fileInfo.fileOwner);
        result.setFileSize(fileInfo.fileSize);
        result.setFileLabelGuid(fileInfo.labelGuid);
        result.setFileProtectionGuid(fileInfo.templateGuid);
        result.setNewFileName(displayFileName);
        result.setNewFileOwner(fileInfo.newFileOwner);
        result.setNewFileExt(AipFileUtils.getExtension((String)actualFileName));
        result.setNewFileSize(fileInfo.newFileSize);
        result.setNewFileLabelGuid(fileInfo.newFileLabelGuid);
        result.setNewFileProtectionGuid(fileInfo.newFileTemplateGuid);
        return result;
    }

    protected ResponseFile responseSetFile(SetFileInfo fileInfo, String displayFileName, String actualFileName) {
        ResponseBase baseResponse = this.responseBase(fileInfo, displayFileName, actualFileName);
        ResponseFile result = new ResponseFile(baseResponse);
        result.setOutputFileName(AipFileUtils.getFileName((String)actualFileName));
        return result;
    }

    protected ResponseStream responseSetStream(SetFileInfo fileInfo, String displayFileName, String actualFileName) {
        ResponseBase baseResponse = this.responseBase(fileInfo, displayFileName, actualFileName);
        ResponseStream result = new ResponseStream(baseResponse);
        result.setOutputFileName(AipFileUtils.getFileName((String)actualFileName));
        result.setFileData(AipFileUtils.getFileDataString((String)actualFileName));
        return result;
    }

    protected ResponseStream responseStreamFail(String displayFileName) {
        log.error("responseStreamFail: {}", (Object)displayFileName);
        return new ResponseStream(110, "\uc791\uc5c5 \uc911\uc5d0 \ud30c\uc77c \uc2dc\uc2a4\ud15c \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.", displayFileName);
    }

    protected ResponseInfo responseInfoException(Exception exception) {
        log.error("responseInfoException: {}", (Object)exception.getMessage());
        return new ResponseInfo(109, "\uc791\uc5c5 \uc911\uc5d0 \uc2dc\uc2a4\ud15c \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
    }

    protected ResponseInfo responseGetFileInfo(AipFileInfo fileInfo, String displayFileName) {
        log.error("{}", (Object)fileInfo);
        boolean isLabled = false;
        boolean isProtected = false;
        Date creationTime = TimeUtils.getCurrentDate();
        String contentId = "";
        String owner = "";
        String labelId = "";
        String labelName = "";
        String templateId = "";
        String templateName = "";
        long fileSize = 0L;
        if (fileInfo != null) {
            fileSize = fileInfo.getFileSize();
            if (fileInfo.getContent() != null) {
                creationTime = fileInfo.getContent().getCreationTime();
            }
            if (fileInfo.getLabel() != null) {
                isLabled = true;
                labelId = fileInfo.getLabel().getId();
                labelName = fileInfo.getLabel().getName();
            }
            if (fileInfo.getProtection() != null) {
                owner = fileInfo.getProtection().getOwner();
                contentId = fileInfo.getProtection().getContentId();
                if (fileInfo.getProtection().getProtectionDescriptor() != null) {
                    isProtected = true;
                    templateId = fileInfo.getProtection().getProtectionDescriptor().getTemplateId();
                    templateName = fileInfo.getProtection().getProtectionDescriptor().getName();
                }
            }
        }
        ResponseInfo result = new ResponseInfo(0, "Success");
        result.setLabeled(isLabled);
        result.setProtected(isProtected);
        result.setCreationTime(creationTime);
        result.setContentId(contentId);
        result.setOwner(owner);
        result.setLabelId(labelId);
        result.setLabelName(labelName);
        result.setTemplateId(templateId);
        result.setTemplateName(templateName);
        result.setDispFileName(displayFileName);
        result.setFileLabelGuid(labelId);
        result.setFileProtectionGuid(templateId);
        result.setFileOwner(owner);
        result.setFileExt(AipFileUtils.getExtension((String)displayFileName));
        result.setFileSize(fileSize);
        return result;
    }

    protected CheckMultipartFile checkMultipartFile(MultipartFile file) {
        CheckMultipartFile result = new CheckMultipartFile(0);
        String dispFileName = file.getOriginalFilename();
        if (dispFileName == null) {
            result.setErrorCode(81);
            result.setErrorMessage("\uc791\uc5c5 \ud560 \ud30c\uc77c \uc774\ub984\uc744 \uc54c \uc218\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
            result.setDispFileName("UnknownFileName");
            return result;
        }
        result.setSaveFileName(dispFileName);
        String saveFileName = AipFileUtils.getFileNameWithoutExtension((String)dispFileName) + AipFileUtils.getExtension((String)dispFileName);
        Path fileStorageLocation = Paths.get(this.repo.getSettings().getSourceFileDir(), new String[0]).toAbsolutePath().normalize();
        if (dispFileName.contains("..")) {
            result.setErrorCode(82);
            result.setErrorMessage("\ud30c\uc77c \uc774\ub984\uc5d0 \uc720\ud6a8 \ud558\uc9c0 \uc54a\uc740 \uacbd\ub85c\uac00 \ud3ec\ud568 \ub418\uc5b4 \uc788\uc2b5\ub2c8\ub2e4.");
            return result;
        }
        result.setSaveFileName(saveFileName);
        Path targetLocation = fileStorageLocation.resolve(saveFileName);
        try {
            Files.copy(file.getInputStream(), targetLocation, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            result.setErrorCode(83);
            result.setErrorMessage("\ud30c\uc77c \uc800\uc7a5 \uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
            return result;
        }
        return result;
    }

    public AbstractAipService(AppRepository repo, AipFileRepository aipFile) {
        this.repo = repo;
        this.aipFile = aipFile;
    }
}

