/*
 * Decompiled with CFR 0.152.
 */
package com.aip.gateway.api.service.impl;

import com.aip.gateway.api.aip.model.SetFileInfo;
import com.aip.gateway.api.aip.utils.AipFileUtils;
import com.aip.gateway.api.model.app.CheckAip;
import com.aip.gateway.api.model.app.CheckMultipartFile;
import com.aip.gateway.api.model.request.RequestBase;
import com.aip.gateway.api.model.request.RequestFile;
import com.aip.gateway.api.model.request.RequestFileAllSet;
import com.aip.gateway.api.model.request.RequestFileDel;
import com.aip.gateway.api.model.request.RequestFileSet;
import com.aip.gateway.api.model.response.ResponseFile;
import com.aip.gateway.api.model.response.ResponseInfo;
import com.aip.gateway.api.repository.AipFileRepository;
import com.aip.gateway.api.repository.AppRepository;
import com.aip.gateway.api.service.IApiFileService;
import com.aip.gateway.api.service.impl.AbstractAipService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ApiFileService
extends AbstractAipService
implements IApiFileService {
    private static final Logger log = LoggerFactory.getLogger(ApiFileService.class);

    public ApiFileService(AppRepository repo, AipFileRepository aipFile) {
        super(repo, aipFile);
    }

    public ResponseInfo getInfo(RequestFile req) {
        try {
            String reqFileName = this.getRequestFileName(req.getRealFileName());
            if (!AipFileUtils.isExists((String)reqFileName)) {
                return new ResponseInfo(101, "\ud30c\uc77c\uc774 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
            }
            String newFileExt = this.getSupportedFileType(reqFileName);
            if (newFileExt == null) {
                return new ResponseInfo(102, "\uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 \ud30c\uc77c\ud615\uc2dd \uc785\ub2c8\ub2e4.");
            }
            return this.responseGetFileInfo(this.aipFile.getManager().getFileInfo(reqFileName), req.getDispFileName());
        }
        catch (Exception e) {
            return this.responseInfoException(e);
        }
    }

    public ResponseFile setLabel(RequestFileSet req) {
        try {
            CheckAip check = this.checkAipRequest(req.getApiGuid(), req.getDispFileName(), req.getRealFileName(), false);
            if (check.getErrorCode() != 0) {
                return new ResponseFile(check.getErrorCode(), check.getErrorMessage(), check.getDispFileName());
            }
            SetFileInfo result = this.aipFile.getManager().setLabel(check.getReqFileName(), check.getActualFileName(), req.getEmail(), req.getAipGuid(), "", req.getComment());
            return this.responseSetFile(result, req.getDispFileName(), check.getActualFileName());
        }
        catch (Exception e) {
            return this.responseFileException(e, req.getDispFileName());
        }
    }

    public ResponseFile delLabel(RequestFileDel req) {
        try {
            CheckAip check = this.checkAipRequest(req.getApiGuid(), req.getDispFileName(), req.getRealFileName(), false);
            if (check.getErrorCode() != 0) {
                return new ResponseFile(check.getErrorCode(), check.getErrorMessage(), check.getDispFileName());
            }
            SetFileInfo result = this.aipFile.getManager().deleteLabel(check.getReqFileName(), check.getActualFileName(), req.getEmail(), req.getComment(), false);
            return this.responseSetFile(result, req.getDispFileName(), check.getActualFileName());
        }
        catch (Exception e) {
            return this.responseFileException(e, req.getDispFileName());
        }
    }

    public ResponseFile setProtection(RequestFileSet req) {
        try {
            CheckAip check = this.checkAipRequest(req.getApiGuid(), req.getDispFileName(), req.getRealFileName(), false);
            if (check.getErrorCode() != 0) {
                return new ResponseFile(check.getErrorCode(), check.getErrorMessage(), check.getDispFileName());
            }
            SetFileInfo result = this.aipFile.getManager().setProtection(check.getReqFileName(), check.getActualFileName(), req.getEmail(), req.getAipGuid(), req.getComment());
            return this.responseSetFile(result, req.getDispFileName(), check.getActualFileName());
        }
        catch (Exception e) {
            return this.responseFileException(e, req.getDispFileName());
        }
    }

    public ResponseFile delProtection(RequestFileDel req) {
        try {
            CheckAip check = this.checkAipRequest(req.getApiGuid(), req.getDispFileName(), req.getRealFileName(), false);
            if (check.getErrorCode() != 0) {
                return new ResponseFile(check.getErrorCode(), check.getErrorMessage(), check.getDispFileName());
            }
            SetFileInfo result = this.aipFile.getManager().deleteProtection(check.getReqFileName(), check.getActualFileName(), req.getEmail(), req.getComment());
            return this.responseSetFile(result, req.getDispFileName(), check.getActualFileName());
        }
        catch (Exception e) {
            return this.responseFileException(e, req.getDispFileName());
        }
    }

    public ResponseFile setLabelProtection(RequestFileAllSet req) {
        try {
            CheckAip check = this.checkAipRequest(req.getApiGuid(), req.getDispFileName(), req.getRealFileName(), false);
            if (check.getErrorCode() != 0) {
                return new ResponseFile(check.getErrorCode(), check.getErrorMessage(), check.getDispFileName());
            }
            SetFileInfo result = this.aipFile.getManager().setLabel(check.getReqFileName(), check.getActualFileName(), req.getEmail(), req.getLabelGuid(), req.getTemplateGuid(), req.getComment());
            return this.responseSetFile(result, req.getDispFileName(), check.getActualFileName());
        }
        catch (Exception e) {
            return this.responseFileException(e, req.getDispFileName());
        }
    }

    public ResponseFile delLabelProtection(RequestFileDel req) {
        try {
            CheckAip check = this.checkAipRequest(req.getApiGuid(), req.getDispFileName(), req.getRealFileName(), false);
            if (check.getErrorCode() != 0) {
                return new ResponseFile(check.getErrorCode(), check.getErrorMessage(), check.getDispFileName());
            }
            SetFileInfo result = this.aipFile.getManager().deleteLabel(check.getReqFileName(), check.getActualFileName(), req.getEmail(), req.getComment(), true);
            return this.responseSetFile(result, req.getDispFileName(), check.getActualFileName());
        }
        catch (Exception e) {
            return this.responseFileException(e, req.getDispFileName());
        }
    }

    public ResponseFile encryptFile(MultipartFile file, RequestBase baseReq) {
        CheckMultipartFile result = this.checkMultipartFile(file);
        if (result.getErrorCode() != 0) {
            return new ResponseFile(result.getErrorCode(), result.getErrorMessage(), result.getDispFileName());
        }
        RequestFileSet req = new RequestFileSet(baseReq.getApiKey(), baseReq.getEmail(), baseReq.getApiGuid(), "", result.getDispFileName(), result.getSaveFileName(), this.repo.getSettings().getSetLabelId(), "SetEncryptFile");
        return this.setLabel(req);
    }

    public ResponseFile decryptFile(MultipartFile file, RequestBase baseReq) {
        CheckMultipartFile result = this.checkMultipartFile(file);
        if (result.getErrorCode() != 0) {
            return new ResponseFile(result.getErrorCode(), result.getErrorMessage(), result.getDispFileName());
        }
        RequestFileDel req = new RequestFileDel(baseReq.getApiKey(), baseReq.getEmail(), baseReq.getApiGuid(), "", result.getDispFileName(), result.getSaveFileName());
        req.setComment("DelDecryptFile");
        return this.delLabel(req);
    }
}

