/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.ext;

import com.tmax.tibero.jdbc.TbBlob;
import com.tmax.tibero.jdbc.TbClob;
import com.tmax.tibero.jdbc.TbConnection;
import com.tmax.tibero.jdbc.TbNClob;
import com.tmax.tibero.jdbc.TbSQLInfo;
import com.tmax.tibero.jdbc.TbSQLInfo2;
import com.tmax.tibero.jdbc.data.ServerInfo;
import com.tmax.tibero.jdbc.dpl.TbDirPathMetaData;
import com.tmax.tibero.jdbc.dpl.TbDirPathStream;
import com.tmax.tibero.jdbc.driver.TbCallableStatement;
import com.tmax.tibero.jdbc.driver.TbPreparedStatement;
import com.tmax.tibero.jdbc.driver.TbResultSet;
import com.tmax.tibero.jdbc.err.TbError;
import com.tmax.tibero.jdbc.ext.TbConnectionEventHandler;
import com.tmax.tibero.jdbc.ext.TbXAException;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class TbLogicalConnection
extends TbConnection {
    private TbConnectionEventHandler eventHandler = null;
    private com.tmax.tibero.jdbc.driver.TbConnection physicalConn = null;
    private boolean closed = true;
    private boolean useXA = false;
    private boolean reseted = true;

    public TbLogicalConnection(TbConnectionEventHandler tbConnectionEventHandler, com.tmax.tibero.jdbc.driver.TbConnection tbConnection, boolean bl) throws SQLException {
        this.eventHandler = tbConnectionEventHandler;
        this.physicalConn = tbConnection;
        this.useXA = bl;
        if (tbConnection.isClosed()) {
            this.closed = true;
            throw TbError.newSQLException(-90643);
        }
        this.closed = false;
        if (!this.physicalConn.isSessionClosed()) {
            this.physicalConn.resetSession();
            this.physicalConn.reuse();
            this.eventHandler.notifyClosedEvent();
        }
    }

    public void clearWarnings() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            this.physicalConn.clearWarnings();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.closed = true;
        this.physicalConn.resetSession();
        this.physicalConn.reuse();
        this.eventHandler.notifyClosedEvent();
    }

    public void commit() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        if (this.isUseXA() && this.getTxnMode() == 2) {
            throw TbError.newSQLException(-90602);
        }
        try {
            this.physicalConn.commit();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        try {
            if (!this.isPhysConnClosed() && this.isUseXA() && this.physicalConn instanceof XAResource) {
                ((XAResource)((Object)this.physicalConn)).commit(xid, bl);
            }
        }
        catch (SQLException sQLException) {
            throw new TbXAException(sQLException.getMessage());
        }
    }

    public Statement createStatement() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.createStatement();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.createStatement(n, n2);
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public void end(Xid xid, int n) throws XAException {
        try {
            if (!this.isPhysConnClosed() && this.isUseXA() && this.physicalConn instanceof XAResource) {
                ((XAResource)((Object)this.physicalConn)).end(xid, n);
            }
        }
        catch (SQLException sQLException) {
            throw new TbXAException(sQLException.getMessage());
        }
    }

    public void forget(Xid xid) throws TbXAException {
    }

    public boolean getAutoCommit() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.getAutoCommit();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public String getCatalog() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.getCatalog();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public int getHoldability() throws SQLException {
        return 1;
    }

    public TbSQLInfo getLastExecutedSqlinfo() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.getLastExecutedSqlinfo();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public TbSQLInfo2 getLastExecutedSqlinfo2() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.getLastExecutedSqlinfo2();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.getMetaData();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    com.tmax.tibero.jdbc.driver.TbConnection getPhysicalConnection() {
        return this.physicalConn;
    }

    public int getTransactionIsolation() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.getTransactionIsolation();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public int getTxnMode() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        return this.physicalConn.getTxnMode();
    }

    public Map getTypeMap() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.getTypeMap();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.getWarnings();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isPhysConnClosed() throws SQLException {
        return this.physicalConn.isClosed();
    }

    public boolean isReadOnly() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.isReadOnly();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public boolean isUseXA() {
        return this.useXA;
    }

    public String nativeSQL(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            return this.physicalConn.nativeSQL(string);
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public int prepare(Xid xid) throws XAException {
        try {
            if (!this.isPhysConnClosed() && this.isUseXA() && this.physicalConn instanceof XAResource) {
                return ((XAResource)((Object)this.physicalConn)).prepare(xid);
            }
        }
        catch (SQLException sQLException) {
            throw new TbXAException("prepare failed " + sQLException.getMessage());
        }
        throw new TbXAException("prepare failed");
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            TbCallableStatement tbCallableStatement;
            TbCallableStatement tbCallableStatement2 = null;
            tbCallableStatement2 = tbCallableStatement = (TbCallableStatement)this.physicalConn.prepareCall(string);
            return tbCallableStatement2;
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            TbCallableStatement tbCallableStatement;
            TbCallableStatement tbCallableStatement2 = null;
            tbCallableStatement2 = tbCallableStatement = (TbCallableStatement)this.physicalConn.prepareCall(string, n, n2);
            return tbCallableStatement2;
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            TbPreparedStatement tbPreparedStatement;
            TbPreparedStatement tbPreparedStatement2 = null;
            tbPreparedStatement2 = tbPreparedStatement = (TbPreparedStatement)this.physicalConn.prepareStatement(string);
            return tbPreparedStatement2;
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public PreparedStatement prepareStatement(String string, boolean bl) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            TbPreparedStatement tbPreparedStatement;
            TbPreparedStatement tbPreparedStatement2 = null;
            tbPreparedStatement2 = tbPreparedStatement = (TbPreparedStatement)this.physicalConn.prepareStatement(string, bl);
            return tbPreparedStatement2;
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            TbPreparedStatement tbPreparedStatement;
            TbPreparedStatement tbPreparedStatement2 = null;
            tbPreparedStatement2 = tbPreparedStatement = (TbPreparedStatement)this.physicalConn.prepareStatement(string, n);
            return tbPreparedStatement2;
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            TbPreparedStatement tbPreparedStatement;
            TbPreparedStatement tbPreparedStatement2 = null;
            tbPreparedStatement2 = tbPreparedStatement = (TbPreparedStatement)this.physicalConn.prepareStatement(string, n, n2);
            return tbPreparedStatement2;
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            TbPreparedStatement tbPreparedStatement;
            TbPreparedStatement tbPreparedStatement2 = null;
            tbPreparedStatement2 = tbPreparedStatement = (TbPreparedStatement)this.physicalConn.prepareStatement(string, nArray);
            return tbPreparedStatement2;
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            TbPreparedStatement tbPreparedStatement;
            TbPreparedStatement tbPreparedStatement2 = null;
            tbPreparedStatement2 = tbPreparedStatement = (TbPreparedStatement)this.physicalConn.prepareStatement(string, stringArray);
            return tbPreparedStatement2;
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public Xid[] recover(int n) throws XAException {
        try {
            if (!this.isPhysConnClosed() && this.isUseXA() && this.physicalConn instanceof XAResource) {
                return ((XAResource)((Object)this.physicalConn)).recover(n);
            }
        }
        catch (SQLException sQLException) {
            throw new TbXAException("recover failed " + sQLException.getMessage());
        }
        throw new TbXAException("recover failed");
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public void reset() {
        this.eventHandler = null;
        this.physicalConn = null;
    }

    public void rollback() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        if (this.isUseXA() && this.getTxnMode() == 2) {
            throw TbError.newSQLException(-90602);
        }
        try {
            this.physicalConn.rollback();
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        if (this.isUseXA() && this.getTxnMode() == 2) {
            throw TbError.newSQLException(-90602);
        }
        try {
            this.physicalConn.rollback(savepoint);
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public void rollback(Xid xid) throws XAException {
        try {
            if (!this.isPhysConnClosed() && this.isUseXA() && this.physicalConn instanceof XAResource) {
                ((XAResource)((Object)this.physicalConn)).rollback(xid);
            }
        }
        catch (SQLException sQLException) {
            throw new TbXAException(sQLException.getMessage());
        }
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        if (this.isUseXA() && this.getTxnMode() == 2) {
            if (bl) {
                throw TbError.newSQLException(-90602);
            }
        } else {
            try {
                this.physicalConn.setAutoCommit(bl);
            }
            catch (SQLException sQLException) {
                this.eventHandler.notifyExceptionEvent(sQLException);
                throw sQLException;
            }
        }
    }

    public void setCatalog(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            this.physicalConn.setCatalog(string);
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public void setHoldability(int n) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public void setReadOnly(boolean bl) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            this.physicalConn.setReadOnly(bl);
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        if (this.isUseXA() && this.getTxnMode() == 2) {
            throw TbError.newSQLException(-90602);
        }
        return this.physicalConn.setSavepoint();
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        if (this.isUseXA() && this.getTxnMode() == 2) {
            throw TbError.newSQLException(-90602);
        }
        return this.physicalConn.setSavepoint(string);
    }

    public void setTransactionIsolation(int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            this.physicalConn.setTransactionIsolation(n);
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public void setTxnMode(int n) {
        this.physicalConn.setTxnMode(n);
    }

    public void setTypeMap(Map map) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        try {
            this.physicalConn.setTypeMap(map);
        }
        catch (SQLException sQLException) {
            this.eventHandler.notifyExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public void start(Xid xid, int n) throws XAException {
        try {
            if (!this.isPhysConnClosed() && this.isUseXA() && this.physicalConn instanceof XAResource) {
                ((XAResource)((Object)this.physicalConn)).start(xid, n);
            }
        }
        catch (SQLException sQLException) {
            throw new TbXAException(sQLException.getMessage());
        }
    }

    public void addWarning(SQLWarning sQLWarning) {
        this.physicalConn.addWarning(sQLWarning);
    }

    public void closeCursor(TbResultSet tbResultSet, int n) throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        this.physicalConn.closeCursor(tbResultSet, n);
    }

    public TbBlob createTbBlob() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        return this.physicalConn.createTbBlob();
    }

    public TbClob createTbClob() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        return this.physicalConn.createTbClob();
    }

    public TbDirPathStream createDirPathStream(TbDirPathMetaData tbDirPathMetaData) throws SQLException {
        throw TbError.newSQLException(-90201);
    }

    public TbNClob createTbNClob() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        return this.physicalConn.createTbNClob();
    }

    public String getNlsDate() {
        return this.physicalConn.getNlsDate();
    }

    public String getNlsTimestamp() {
        return this.physicalConn.getNlsTimestamp();
    }

    public int getSerialNo() {
        return this.physicalConn.getSerialNo();
    }

    public int getServerCharSet() {
        return this.physicalConn.getServerCharSet();
    }

    public ServerInfo getServerInfo() {
        return this.physicalConn.getServerInfo();
    }

    public int getServerNCharSet() {
        return this.physicalConn.getServerNCharSet();
    }

    public int getSessionId() {
        return this.physicalConn.getSessionId();
    }

    public boolean isPooledConnection() {
        return false;
    }

    public boolean isSessionClosed() {
        return this.physicalConn.isSessionClosed();
    }

    public void resetSession() throws SQLException {
        if (this.isClosed()) {
            throw TbError.newSQLException(-90603);
        }
        this.physicalConn.resetSession();
    }
}

