/*
 * Decompiled with CFR 0.152.
 */
package com.its.app.config;

import com.its.utils.SysUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public abstract class AbstractServerConfig {
    private static final Logger log = LoggerFactory.getLogger(AbstractServerConfig.class);
    private String bootingDateTime;
    private boolean startSchedule;
    @Value(value="${process.id:ITS01}")
    private String processId;
    @Value(value="${process.name:ITS Traffic Common Server}")
    private String processName;
    @Value(value="${server.user.id:admin}")
    private String userId;
    @Value(value="${server.user.pswd:1234}")
    private String userPswd;
    @Value(value="${server.db.threads:#{20}}")
    private int serverDbThreads;
    @Value(value="${server.data.threads:#{20}}")
    private int serverDataThreads;
    @Value(value="${server.center.bind.addr:0.0.0.0}")
    private String centerBindAddr;
    @Value(value="${server.center.bind.port:#{6010}}")
    private int centerBindPort;
    @Value(value="${server.center.dump:false}")
    private String centerDump;
    @Value(value="${server.tcp.bind.addr:0.0.0.0}")
    private String tcpBindAddress;
    @Value(value="${server.tcp.bind.port:#{30100}}")
    private int tcpBindPort;
    @Value(value="${server.tcp.recv.dump:false}")
    private String tcpRecvDump;
    @Value(value="${server.tcp.send.dump:false}")
    private String tcpSendDump;
    @Value(value="${server.tcp.backlog:#{128}}")
    private int tcpBacklog;
    @Value(value="${server.tcp.threads.accept:#{1}}")
    private int tcpThreadsAccept;
    @Value(value="${server.tcp.threads.worker:#{8}}")
    private int tcpThreadsWorker;
    @Value(value="${server.tcp.rcvBuf:#{32768}}")
    private int tcpRcvBuf;
    @Value(value="${server.tcp.SndBuf:#{32768}}")
    private int tcpSndBuf;
    @Value(value="${server.tcp.readerIdleTime:#{0}}")
    private int readerIdleTime;
    @Value(value="${server.tcp.writerIdleTime:#{0}}")
    private int writerIdleTime;
    @Value(value="${server.tcp.allIdleTime:#{0}}")
    private int allIdleTime;
    @Value(value="${server.tcp.connectTimeoutSec:#{0}}")
    private int connectTimeoutSec;
    @Value(value="${server.task.statistics:true}")
    private String taskStatistics;

    protected void postConstruct() {
        this.startSchedule = false;
        if (this.tcpBacklog < 64) {
            this.tcpBacklog = 64;
        }
        if (this.tcpBacklog == 0) {
            this.tcpBacklog = 64;
        }
        if (this.centerBindAddr.equals("")) {
            this.centerBindAddr = "0.0.0.0";
        }
        if (this.tcpBindAddress.equals("")) {
            this.tcpBindAddress = "0.0.0.0";
        }
        this.bootingDateTime = SysUtils.getSysTimeStr();
    }

    public String getBootingDateTime() {
        return this.bootingDateTime;
    }

    public boolean isStartSchedule() {
        return this.startSchedule;
    }

    public String getProcessId() {
        return this.processId;
    }

    public String getProcessName() {
        return this.processName;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getUserPswd() {
        return this.userPswd;
    }

    public int getServerDbThreads() {
        return this.serverDbThreads;
    }

    public int getServerDataThreads() {
        return this.serverDataThreads;
    }

    public String getCenterBindAddr() {
        return this.centerBindAddr;
    }

    public int getCenterBindPort() {
        return this.centerBindPort;
    }

    public String getCenterDump() {
        return this.centerDump;
    }

    public String getTcpBindAddress() {
        return this.tcpBindAddress;
    }

    public int getTcpBindPort() {
        return this.tcpBindPort;
    }

    public String getTcpRecvDump() {
        return this.tcpRecvDump;
    }

    public String getTcpSendDump() {
        return this.tcpSendDump;
    }

    public int getTcpBacklog() {
        return this.tcpBacklog;
    }

    public int getTcpThreadsAccept() {
        return this.tcpThreadsAccept;
    }

    public int getTcpThreadsWorker() {
        return this.tcpThreadsWorker;
    }

    public int getTcpRcvBuf() {
        return this.tcpRcvBuf;
    }

    public int getTcpSndBuf() {
        return this.tcpSndBuf;
    }

    public int getReaderIdleTime() {
        return this.readerIdleTime;
    }

    public int getWriterIdleTime() {
        return this.writerIdleTime;
    }

    public int getAllIdleTime() {
        return this.allIdleTime;
    }

    public int getConnectTimeoutSec() {
        return this.connectTimeoutSec;
    }

    public String getTaskStatistics() {
        return this.taskStatistics;
    }

    public void setBootingDateTime(String bootingDateTime) {
        this.bootingDateTime = bootingDateTime;
    }

    public void setStartSchedule(boolean startSchedule) {
        this.startSchedule = startSchedule;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setUserPswd(String userPswd) {
        this.userPswd = userPswd;
    }

    public void setServerDbThreads(int serverDbThreads) {
        this.serverDbThreads = serverDbThreads;
    }

    public void setServerDataThreads(int serverDataThreads) {
        this.serverDataThreads = serverDataThreads;
    }

    public void setCenterBindAddr(String centerBindAddr) {
        this.centerBindAddr = centerBindAddr;
    }

    public void setCenterBindPort(int centerBindPort) {
        this.centerBindPort = centerBindPort;
    }

    public void setCenterDump(String centerDump) {
        this.centerDump = centerDump;
    }

    public void setTcpBindAddress(String tcpBindAddress) {
        this.tcpBindAddress = tcpBindAddress;
    }

    public void setTcpBindPort(int tcpBindPort) {
        this.tcpBindPort = tcpBindPort;
    }

    public void setTcpRecvDump(String tcpRecvDump) {
        this.tcpRecvDump = tcpRecvDump;
    }

    public void setTcpSendDump(String tcpSendDump) {
        this.tcpSendDump = tcpSendDump;
    }

    public void setTcpBacklog(int tcpBacklog) {
        this.tcpBacklog = tcpBacklog;
    }

    public void setTcpThreadsAccept(int tcpThreadsAccept) {
        this.tcpThreadsAccept = tcpThreadsAccept;
    }

    public void setTcpThreadsWorker(int tcpThreadsWorker) {
        this.tcpThreadsWorker = tcpThreadsWorker;
    }

    public void setTcpRcvBuf(int tcpRcvBuf) {
        this.tcpRcvBuf = tcpRcvBuf;
    }

    public void setTcpSndBuf(int tcpSndBuf) {
        this.tcpSndBuf = tcpSndBuf;
    }

    public void setReaderIdleTime(int readerIdleTime) {
        this.readerIdleTime = readerIdleTime;
    }

    public void setWriterIdleTime(int writerIdleTime) {
        this.writerIdleTime = writerIdleTime;
    }

    public void setAllIdleTime(int allIdleTime) {
        this.allIdleTime = allIdleTime;
    }

    public void setConnectTimeoutSec(int connectTimeoutSec) {
        this.connectTimeoutSec = connectTimeoutSec;
    }

    public void setTaskStatistics(String taskStatistics) {
        this.taskStatistics = taskStatistics;
    }

    public String toString() {
        return "AbstractServerConfig(bootingDateTime=" + this.getBootingDateTime() + ", startSchedule=" + this.isStartSchedule() + ", processId=" + this.getProcessId() + ", processName=" + this.getProcessName() + ", userId=" + this.getUserId() + ", userPswd=" + this.getUserPswd() + ", serverDbThreads=" + this.getServerDbThreads() + ", serverDataThreads=" + this.getServerDataThreads() + ", centerBindAddr=" + this.getCenterBindAddr() + ", centerBindPort=" + this.getCenterBindPort() + ", centerDump=" + this.getCenterDump() + ", tcpBindAddress=" + this.getTcpBindAddress() + ", tcpBindPort=" + this.getTcpBindPort() + ", tcpRecvDump=" + this.getTcpRecvDump() + ", tcpSendDump=" + this.getTcpSendDump() + ", tcpBacklog=" + this.getTcpBacklog() + ", tcpThreadsAccept=" + this.getTcpThreadsAccept() + ", tcpThreadsWorker=" + this.getTcpThreadsWorker() + ", tcpRcvBuf=" + this.getTcpRcvBuf() + ", tcpSndBuf=" + this.getTcpSndBuf() + ", readerIdleTime=" + this.getReaderIdleTime() + ", writerIdleTime=" + this.getWriterIdleTime() + ", allIdleTime=" + this.getAllIdleTime() + ", connectTimeoutSec=" + this.getConnectTimeoutSec() + ", taskStatistics=" + this.getTaskStatistics() + ")";
    }
}

