/*
 * Decompiled with CFR 0.152.
 */
package com.its.app.thread;

import java.util.concurrent.Executor;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.AsyncConfigurerSupport;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@EnableAsync
@Configuration
public class ItsThreadPoolInitializer
extends AsyncConfigurerSupport {
    @Value(value="${server.threads.stat:#{0}}")
    private int threadPoolStat;
    @Value(value="${server.threads.work:#{0}}")
    private int threadPoolWork;
    @Value(value="${server.threads.dbms:#{0}}")
    private int threadPoolDbms;
    private int MAX_CORE = Runtime.getRuntime().availableProcessors();

    @PostConstruct
    private void init() {
        if (this.MAX_CORE < 8) {
            this.MAX_CORE = 16;
        }
        if (this.threadPoolStat <= 0) {
            this.threadPoolStat = this.MAX_CORE;
        }
        if (this.threadPoolWork <= 0) {
            this.threadPoolWork = this.MAX_CORE;
        }
        if (this.threadPoolDbms <= 0) {
            this.threadPoolDbms = this.MAX_CORE;
        }
    }

    public ThreadPoolTaskExecutor getDefaultExecutor(int poolSize) {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
        threadPoolTaskExecutor.setCorePoolSize(poolSize);
        threadPoolTaskExecutor.setMaxPoolSize(poolSize * 2);
        threadPoolTaskExecutor.setQueueCapacity(1000);
        return threadPoolTaskExecutor;
    }

    @Bean(name={"centerCommExecutor"})
    public Executor getCenterCommExecutor() {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = this.getDefaultExecutor(this.threadPoolWork);
        threadPoolTaskExecutor.setThreadNamePrefix("comm-pool-");
        threadPoolTaskExecutor.initialize();
        return threadPoolTaskExecutor;
    }

    @Bean(name={"dbmsJobExecutor"})
    public Executor getDbmsJobExecutor() {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = this.getDefaultExecutor(this.threadPoolDbms);
        threadPoolTaskExecutor.setThreadNamePrefix("dbms-pool-");
        threadPoolTaskExecutor.initialize();
        return threadPoolTaskExecutor;
    }

    @Bean(name={"appJobExecutor"})
    public Executor getAppJobExecutor() {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = this.getDefaultExecutor(this.threadPoolWork);
        threadPoolTaskExecutor.setThreadNamePrefix("work-pool-");
        threadPoolTaskExecutor.initialize();
        return threadPoolTaskExecutor;
    }

    @Bean(name={"statisticsExecutor"})
    public Executor getStatisticsExecutor() {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = this.getDefaultExecutor(this.threadPoolStat);
        threadPoolTaskExecutor.setThreadNamePrefix("stat-pool-");
        threadPoolTaskExecutor.initialize();
        return threadPoolTaskExecutor;
    }

    @Bean(name={"icmpPingExecutor"})
    public Executor getIcmpPingExecutor() {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = this.getDefaultExecutor(this.threadPoolWork);
        threadPoolTaskExecutor.setThreadNamePrefix("icmp-pool-");
        threadPoolTaskExecutor.initialize();
        return threadPoolTaskExecutor;
    }

    public int getThreadPoolStat() {
        return this.threadPoolStat;
    }

    public int getThreadPoolWork() {
        return this.threadPoolWork;
    }

    public int getThreadPoolDbms() {
        return this.threadPoolDbms;
    }

    public int getMAX_CORE() {
        return this.MAX_CORE;
    }
}

