/*
 * Decompiled with CFR 0.152.
 */
package com.its.app.xnetudp.codec;

import com.its.app.config.AbstractServerConfig;
import com.its.app.config.AppUtils;
import com.its.app.service.UnitSystService;
import com.its.app.vo.voUnitSyst;
import com.its.utils.SysUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CenterCommClientEncoder
extends MessageToMessageEncoder<Object> {
    private static final Logger log = LoggerFactory.getLogger(CenterCommClientEncoder.class);
    private String remoteIpAddr;
    private int remotePort;

    public CenterCommClientEncoder(String hostIp, int hostPort) {
        this.remoteIpAddr = hostIp;
        this.remotePort = hostPort;
    }

    protected void encode(ChannelHandlerContext ctx, Object msg, List<Object> out) throws Exception {
        AbstractServerConfig serverConfig = (AbstractServerConfig)AppUtils.getBean(AbstractServerConfig.class);
        Channel channel = ctx.channel();
        if (!channel.isOpen()) {
            log.error("SEND: Channel Closed.");
        }
        if (!channel.isActive()) {
            log.error("SEND: Channel InActive.");
            channel.flush();
            return;
        }
        if (!(msg instanceof ByteBuffer)) {
            log.error("SEND: Encoding Data source Unknown Type.");
            return;
        }
        int sendBytes = ((ByteBuffer)msg).array().length;
        if (this.remoteIpAddr == null) {
            log.info("SEND: [ALL], {} Bytes.", (Object)sendBytes);
        } else {
            log.info("SEND: [{}:{}], {} Bytes.", new Object[]{this.remoteIpAddr, this.remotePort, sendBytes});
        }
        if (serverConfig.getCenterDump().equals("true")) {
            log.info("SEND DUMP: {}", (Object)SysUtils.byteArrayToHex(((ByteBuffer)msg).array()));
        }
        UnitSystService unitSystService = (UnitSystService)AppUtils.getBean(UnitSystService.class);
        ConcurrentHashMap<String, voUnitSyst> untiSystMap = unitSystService.getUntiSystMap();
        for (Map.Entry<String, voUnitSyst> e : untiSystMap.entrySet()) {
            if (this.remoteIpAddr != null && !this.remoteIpAddr.equals(e.getValue().getSYST_IP_1())) continue;
            try {
                ByteBuf byteBuf = Unpooled.buffer((int)sendBytes);
                byteBuf.writeBytes(((ByteBuffer)msg).array());
                InetSocketAddress addr = new InetSocketAddress(e.getValue().getSYST_IP_1(), e.getValue().getPRGM_PORT());
                DatagramPacket packet = new DatagramPacket(byteBuf, addr);
                out.add(packet);
                if (this.remoteIpAddr == null) {
                    log.debug("SEND: [{}] [{}:{}], {} Bytes. OK....", new Object[]{e.getValue().getSYST_ID(), e.getValue().getSYST_IP_1(), e.getValue().getPRGM_PORT(), sendBytes});
                    continue;
                }
                log.info("SEND: [{}] [{}:{}], {} Bytes. OK....", new Object[]{e.getValue().getSYST_ID(), e.getValue().getSYST_IP_1(), e.getValue().getPRGM_PORT(), sendBytes});
            }
            catch (Exception e2) {
                log.error("SEND: [{}] [{}:{}], {} Bytes. Failed. Exception: {}", new Object[]{e.getValue().getSYST_ID(), e.getValue().getSYST_IP_1(), e.getValue().getPRGM_PORT(), sendBytes, e2.toString()});
            }
        }
    }
}

