/*
 * Decompiled with CFR 0.152.
 */
package com.its.app.xnetudp.handler;

import com.its.app.config.AppUtils;
import com.its.app.xnetudp.protocol.CENTER_COMM_MESSAGE;
import com.its.app.xnetudp.thread.AbstractCenterCommServerReceiver;
import com.its.utils.NettyUtils;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CenterCommServerPacketHandler
extends SimpleChannelInboundHandler<Object> {
    private static final Logger log = LoggerFactory.getLogger(CenterCommServerPacketHandler.class);

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!(msg instanceof CENTER_COMM_MESSAGE)) {
            log.error("CenterCommServerPacketHandler: Received Data Unknown Type: {}", (Object)NettyUtils.getTcpAddress(ctx.channel()));
            return;
        }
        AbstractCenterCommServerReceiver handler = (AbstractCenterCommServerReceiver)AppUtils.getBean("centerCommServerReceiver");
        if (handler != null) {
            handler.run((CENTER_COMM_MESSAGE)msg);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.channel().flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        InetSocketAddress remoteAddress = (InetSocketAddress)ctx.channel().remoteAddress();
        String ip = remoteAddress.getAddress().getHostAddress();
        log.error("CenterCommServerPacketHandler::exceptionCaught: {}, {}", (Object)ip, (Object)cause.getMessage());
        cause.printStackTrace();
        super.exceptionCaught(ctx, cause);
    }
}

