/*
 * Decompiled with CFR 0.152.
 */
package com.its.app.xnetudp.protocol;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class CENTER_COMM_MESSAGE {
    public static int CENTER_HEADER_SIZE = 8;
    private InetSocketAddress sender;
    private byte sendId;
    private byte recvId;
    private byte totalFrame;
    private byte currentFrame;
    private byte msgSeq;
    private byte opCode;
    private int length;
    private byte[] body;

    public CENTER_COMM_MESSAGE() {
    }

    public CENTER_COMM_MESSAGE(int senderId, int opCode, int length, byte msgSeq) {
        this.sendId = (byte)senderId;
        this.recvId = (byte)33;
        this.totalFrame = 1;
        this.currentFrame = 1;
        this.msgSeq = msgSeq;
        this.opCode = (byte)opCode;
        this.length = length;
    }

    public CENTER_COMM_MESSAGE(byte[] buffer, InetSocketAddress inetSocketAddress) {
        this.sender = inetSocketAddress;
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.sendId = byteBuffer.get();
        this.recvId = byteBuffer.get();
        this.totalFrame = byteBuffer.get();
        this.currentFrame = byteBuffer.get();
        this.msgSeq = byteBuffer.get();
        this.opCode = byteBuffer.get();
        this.length = byteBuffer.getShort();
        if (this.length > 0) {
            this.body = new byte[this.length];
            byteBuffer.get(this.body);
        }
    }

    public String getSenderIp() {
        return this.sender.getAddress().getHostAddress();
    }

    public int getSenderPort() {
        return this.sender.getPort();
    }

    public byte getOpCode() {
        return this.opCode;
    }

    public void setOpCode(byte opCode) {
        this.opCode = opCode;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public InetSocketAddress getSender() {
        return this.sender;
    }

    public void setSender(InetSocketAddress sender) {
        this.sender = sender;
    }

    public byte getSendId() {
        return this.sendId;
    }

    public void setSendId(byte sendId) {
        this.sendId = sendId;
    }

    public byte getRecvId() {
        return this.recvId;
    }

    public void setRecvId(byte recvId) {
        this.recvId = recvId;
    }

    public byte getTotalFrame() {
        return this.totalFrame;
    }

    public void setTotalFrame(byte totalFrame) {
        this.totalFrame = totalFrame;
    }

    public byte getCurrentFrame() {
        return this.currentFrame;
    }

    public void setCurrentFrame(byte currentFrame) {
        this.currentFrame = currentFrame;
    }

    public byte getMsgSeq() {
        return this.msgSeq;
    }

    public void setMsgSeq(byte msgSeq) {
        this.msgSeq = msgSeq;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public byte[] getMessage() {
        return null;
    }

    public ByteBuffer getBuffer() {
        return null;
    }
}

