/*
 * Decompiled with CFR 0.152.
 */
package com.its.app.xnetudp.thread;

import com.its.app.xnetudp.codec.CenterCommClientEncoder;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class CenterCommClientSender {
    private static final Logger log = LoggerFactory.getLogger(CenterCommClientSender.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Async(value="centerCommExecutor")
    public void run(final String ip, final int port, ByteBuffer sendBuffer) {
        NioEventLoopGroup nioEventLoopGroup;
        block5: {
            if (sendBuffer == null) {
                log.error("CenterCommClientSender.run: Notify Data NULL");
                return;
            }
            nioEventLoopGroup = new NioEventLoopGroup();
            try {
                Bootstrap bootstrap = new Bootstrap();
                bootstrap.channel(NioDatagramChannel.class);
                bootstrap.group((EventLoopGroup)nioEventLoopGroup);
                bootstrap.option(ChannelOption.SO_BROADCAST, (Object)false);
                bootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(){

                    protected void initChannel(Channel channel) throws Exception {
                        channel.pipeline().addLast(new ChannelHandler[]{new CenterCommClientEncoder(ip, port)});
                    }
                });
                Channel channel = bootstrap.bind(0).sync().channel();
                ChannelFuture f = channel.writeAndFlush((Object)sendBuffer).sync();
                if (f.isDone() && f.isSuccess()) break block5;
                log.error("CenterCommClientSender.run: Send Failed. isDone: {}, isSuccess: {}", (Object)f.isDone(), (Object)f.isSuccess());
            }
            catch (Exception e) {
                try {
                    log.error("CenterCommClientSender.run: Exception: {}", (Object)e.toString());
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    nioEventLoopGroup.shutdownGracefully();
                    log.info("CenterCommClientSender.run: {} Bytes, ip: {}, port: {}", new Object[]{sendBuffer.array().length, ip, port});
                    throw throwable;
                }
                nioEventLoopGroup.shutdownGracefully();
                log.info("CenterCommClientSender.run: {} Bytes, ip: {}, port: {}", new Object[]{sendBuffer.array().length, ip, port});
            }
        }
        nioEventLoopGroup.shutdownGracefully();
        log.info("CenterCommClientSender.run: {} Bytes, ip: {}, port: {}", new Object[]{sendBuffer.array().length, ip, port});
    }
}

