/*
 * Decompiled with CFR 0.152.
 */
package com.its.utils;

import com.its.utils.TimeUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class StatisticsTime {
    private final int processingTime_BEFORE = 0;
    private String prcsDayWeek;
    private String prcsDayQuater;
    private String prcsCurrTime;
    private String prcsCurrFiveMin;
    private String prcsCurrFiveMinTo;
    private String prcsPrevFiveMin;
    private String stat15MinTime;
    private String stat15MinFrom;
    private String stat15MinTo;
    private String statHourTime;
    private String statHourFrom;
    private String statHourTo;
    private String statDayFrom;
    private String statDayTo;
    private String statMonFrom;
    private String statMonTo;
    private String statYearFrom;
    private String statYearTo;
    private boolean isStat15Min = false;
    private boolean isStatHour = false;
    private boolean isStatDay = false;
    private boolean isStatMon = false;
    private boolean isStatYear = false;
    private boolean isPatternUpdate = false;
    private int analysisTime = 0;
    private int month;
    private int hour;
    private int min;
    private boolean isProcessing = false;
    private Date startDate = new Date();
    private Date endDate = new Date();

    public void setProcessing(boolean isProcessing) {
        this.isProcessing = isProcessing;
        if (this.isProcessing) {
            this.startDate = new Date();
        } else {
            this.endDate = new Date();
        }
    }

    public boolean IsProcessing() {
        return this.isProcessing;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public int getAnalysisTime() {
        return this.analysisTime;
    }

    public void setAnalysisTime(int analysisTime) {
        this.analysisTime = analysisTime;
    }

    public boolean isStat15Min() {
        return this.isStat15Min;
    }

    public boolean isStatHour() {
        return this.isStatHour;
    }

    public boolean isStatDay() {
        return this.isStatDay;
    }

    public boolean isStatMon() {
        return this.isStatMon;
    }

    public boolean isStatYear() {
        return this.isStatYear;
    }

    public boolean isPatternUpdate() {
        return this.isPatternUpdate;
    }

    public String getStat15MinTime() {
        if (this.analysisTime == 0) {
            return this.stat15MinFrom;
        }
        return this.stat15MinTime;
    }

    public String getStat15MinFrom() {
        return this.stat15MinFrom;
    }

    public String getStat15MinTo() {
        return this.stat15MinTo;
    }

    public String getStatHourTime() {
        if (this.analysisTime == 0) {
            return this.statHourFrom;
        }
        return this.statHourTime;
    }

    public String getStatHourFrom() {
        return this.statHourFrom;
    }

    public String getStatHourTo() {
        return this.statHourTo;
    }

    public String getStatDayFrom() {
        return this.statDayFrom;
    }

    public String getStatDayTo() {
        return this.statDayTo;
    }

    public String getStatMonFrom() {
        return this.statMonFrom;
    }

    public String getStatMonTo() {
        return this.statMonTo;
    }

    public String getStatYearFrom() {
        return this.statYearFrom;
    }

    public String getStatYearTo() {
        return this.statYearTo;
    }

    public String getPrcsDayWeek() {
        return this.prcsDayWeek;
    }

    public String getPrcsDayQuater() {
        return this.prcsDayQuater;
    }

    public String getCurrTime() {
        return this.prcsCurrTime;
    }

    public String getPrcsFiveMin() {
        if (this.analysisTime == 0) {
            return this.prcsPrevFiveMin;
        }
        return this.prcsCurrFiveMin;
    }

    public String getCurrFiveMin() {
        return this.prcsCurrFiveMin;
    }

    public String getPrcsFiveMinFrom() {
        return this.prcsPrevFiveMin;
    }

    public String getPrcsFiveMinTo() {
        return this.prcsCurrFiveMinTo;
    }

    public String calDate(String paramTm, int addSec) {
        String result = paramTm;
        SimpleDateFormat transFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        try {
            Date to = new Date();
            to.setTime(transFormat.parse(paramTm).getTime() + (long)(addSec *= 1000));
            result = TimeUtils.dateToString(to, "yyyyMMddHHmmss");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return result;
    }

    public String calDateFormat(String paramFmt, String paramTm, int addSec) {
        String result = paramTm;
        SimpleDateFormat transFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        try {
            Date to = new Date();
            to.setTime(transFormat.parse(paramTm).getTime() + (long)(addSec *= 1000));
            result = TimeUtils.dateToString(to, paramFmt);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return result;
    }

    public String calLastDayFormat(String paramFmt, String paramTm) {
        String result = paramTm;
        SimpleDateFormat transFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        try {
            Date to = new Date();
            to.setTime(transFormat.parse(paramTm).getTime());
            Calendar cal = Calendar.getInstance();
            cal.setTime(to);
            int day = cal.getActualMaximum(5);
            cal.set(5, day);
            return new SimpleDateFormat(paramFmt).format(cal.getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
            return result;
        }
    }

    public void setPrcsTimeInfo() {
        Calendar cal = Calendar.getInstance();
        try {
            cal.setTime(TimeUtils.stringToDate(this.prcsCurrTime));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.month = cal.get(2) + 1;
        this.hour = cal.get(11);
        this.min = cal.get(12);
        try {
            cal.setTime(TimeUtils.stringToDate(this.getPrcsFiveMin()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.prcsDayWeek = String.valueOf(cal.get(7));
        this.prcsDayQuater = String.valueOf(this.month / 3 + 1);
    }

    public void initValue() {
        this.prcsDayWeek = "";
        this.prcsDayQuater = "";
        this.prcsCurrTime = "";
        this.prcsCurrFiveMin = "";
        this.prcsCurrFiveMinTo = "";
        this.prcsPrevFiveMin = "";
        this.stat15MinTime = "";
        this.stat15MinFrom = "";
        this.stat15MinTo = "";
        this.statHourTime = "";
        this.statHourFrom = "";
        this.statHourTo = "";
        this.statDayFrom = "";
        this.statDayTo = "";
        this.statMonFrom = "";
        this.statMonTo = "";
        this.isStat15Min = false;
        this.isStatHour = false;
        this.isStatDay = false;
        this.isStatMon = false;
        this.isStatYear = false;
        this.isPatternUpdate = false;
    }

    public void init() {
        this.initValue();
        this.prcsCurrTime = TimeUtils.getCurrentTimeString();
        Date dt = null;
        try {
            dt = TimeUtils.stringToDate(this.prcsCurrTime);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.prcsCurrFiveMin = TimeUtils.getFiveMinString(dt);
        this.prcsCurrFiveMinTo = this.calDate(this.prcsCurrFiveMin, -1);
        this.prcsPrevFiveMin = this.calDate(this.prcsCurrFiveMin, -300);
        this.setPrcsTimeInfo();
        if (this.min % 15 == 0) {
            this.isStat15Min = true;
        }
        this.stat15MinFrom = this.calDate(this.prcsCurrFiveMin, -900);
        this.stat15MinTo = this.calDate(this.stat15MinFrom, 899);
        this.stat15MinTime = this.calDate(this.stat15MinFrom, 900);
        if (this.min == 5) {
            this.isStatHour = true;
        }
        String statHour = this.calDateFormat("yyyyMMddHH", this.prcsCurrFiveMin, -3600);
        this.statHourFrom = statHour + "0000";
        this.statHourTo = statHour + "5959";
        this.statHourTime = this.calDateFormat("yyyyMMddHH", this.prcsCurrFiveMin, 0) + "0000";
        if (this.hour == 0 && this.min == 10) {
            this.isStatDay = true;
        }
        String statDay = this.calDateFormat("yyyyMMdd", this.prcsCurrFiveMin, -86400);
        this.statDayFrom = statDay + "000000";
        this.statDayTo = statDay + "235959";
        if (this.hour == 2 && this.min == 10) {
            this.isStatMon = true;
        }
        this.statMonFrom = this.calDateFormat("yyyyMM", this.prcsCurrFiveMin, -86400) + "01000000";
        this.statMonTo = this.calLastDayFormat("yyyyMMdd", this.statMonFrom) + "235959";
        if (this.hour == 2 && this.min == 35) {
            this.isStatYear = true;
        }
        this.statYearFrom = this.calDateFormat("yyyy", this.prcsCurrFiveMin, -86400) + "0101000000";
        this.statYearTo = this.calLastDayFormat("yyyy", this.statMonFrom) + "1231235959";
        if (this.hour == 3 && this.min == 20) {
            this.isPatternUpdate = true;
        }
    }
}

