/*
 * Decompiled with CFR 0.152.
 */
package com.its.app.config;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class SystemInfo {
    private static final Logger log = LoggerFactory.getLogger(SystemInfo.class);
    private final Environment env;
    private String activeProfiles;
    private String osName;
    private int cpuCores;
    private String hostName;
    private String ipAddress;

    public SystemInfo(Environment env) {
        this.env = env;
    }

    @PostConstruct
    private void init() {
        this.setActiveProfiles(Arrays.toString(this.env.getActiveProfiles()));
        this.setOsName(System.getProperty("os.name"));
        this.setCpuCores(Runtime.getRuntime().availableProcessors());
        this.setHostName(this.getLocalHostName());
        this.setIpAddress(this.getLocalIpAddress());
    }

    private String getLocalHostName() {
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            System.out.println(e.getMessage() + ", " + e.getStackTrace());
        }
        return hostName;
    }

    private String getLocalIpAddress() {
        ArrayList<String> ipAddresses = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                for (InterfaceAddress ifAddr : e.nextElement().getInterfaceAddresses()) {
                    if (ifAddr.getAddress() instanceof Inet6Address) continue;
                    ipAddresses.add(ifAddr.getAddress().getHostAddress());
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage() + ", " + e.getStackTrace());
        }
        return ((Object)ipAddresses).toString();
    }

    public List<String> getIpAddressesList() {
        ArrayList<String> ipAddresses = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                for (InterfaceAddress ifAddr : e.nextElement().getInterfaceAddresses()) {
                    if (ifAddr.getAddress() instanceof Inet6Address) continue;
                    ipAddresses.add(ifAddr.getAddress().getHostAddress());
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage() + ", " + e.getStackTrace());
        }
        return ipAddresses;
    }

    public Environment getEnv() {
        return this.env;
    }

    public String getActiveProfiles() {
        return this.activeProfiles;
    }

    public String getOsName() {
        return this.osName;
    }

    public int getCpuCores() {
        return this.cpuCores;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setActiveProfiles(String activeProfiles) {
        this.activeProfiles = activeProfiles;
    }

    public void setOsName(String osName) {
        this.osName = osName;
    }

    public void setCpuCores(int cpuCores) {
        this.cpuCores = cpuCores;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String toString() {
        return "SystemInfo(env=" + this.getEnv() + ", activeProfiles=" + this.getActiveProfiles() + ", osName=" + this.getOsName() + ", cpuCores=" + this.getCpuCores() + ", hostName=" + this.getHostName() + ", ipAddress=" + this.getIpAddress() + ")";
    }
}

