/*
 * Decompiled with CFR 0.152.
 */
package com.its.app.webapp.service;

import com.its.app.webapp.vo.voFileInfo;
import com.its.utils.OS;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

@Service
public class FileService {
    private static final Logger log = LoggerFactory.getLogger(FileService.class);
    private final String logDir = "/logs/";
    private final String sysDir = System.getProperty("user.dir");
    private final String[] exceptDir = new String[]{"backup"};
    private int id = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getView(HttpServletRequest request, String fileName, String filePath) {
        long preEndPoint = request.getParameter("preEndPoint") == null ? 0L : Long.parseLong(request.getParameter("preEndPoint") + "");
        StringBuilder sb = new StringBuilder();
        RandomAccessFile file = null;
        String errMsg = "";
        try {
            String str;
            file = new RandomAccessFile(System.getProperty("user.dir") + filePath + fileName, "r");
            long endPoint = file.length();
            long startPoint = preEndPoint > 0L ? preEndPoint : (endPoint < 2000L ? 0L : endPoint - 2000L);
            file.seek(startPoint);
            while ((str = file.readLine()) != null) {
                byte[] b = str.getBytes("iso-8859-1");
                str = new String(b, "UTF-8");
                sb.append(str);
                sb.append("<br>");
                endPoint = file.getFilePointer();
                file.seek(endPoint);
            }
            JSONObject json = new JSONObject();
            json.put((Object)"endPoint", (Object)endPoint);
            json.put((Object)"log", (Object)sb.toString());
            String string = json.toString();
            return string;
        }
        catch (FileNotFoundException fnf) {
            log.error("FileService.getView: Exception: {}", (Object)fnf.toString());
            errMsg = errMsg + fnf.toString();
        }
        catch (IOException e) {
            log.error(e.getMessage());
            errMsg = errMsg + e.toString();
        }
        finally {
            try {
                if (file != null) {
                    file.close();
                }
            }
            catch (Exception e) {
                log.error("FileService.getView: Exception: {}", (Object)e.toString());
                errMsg = errMsg + e.toString();
            }
        }
        if (!errMsg.equals("")) {
            sb.append(errMsg);
            sb.append("<br>");
            JSONObject json = new JSONObject();
            json.put((Object)"endPoint", (Object)0);
            json.put((Object)"log", (Object)sb.toString());
            return json.toString();
        }
        return null;
    }

    public ResponseEntity<Resource> fileDownload(String fileName, String filePath) {
        try {
            Path path = Paths.get(System.getProperty("user.dir") + filePath + fileName, new String[0]);
            String contentType = "application/download";
            HttpHeaders headers = new HttpHeaders();
            headers.add("Content-Type", contentType);
            headers.setContentDisposition(ContentDisposition.parse((String)("attachment; filename=\"" + fileName + "\";")));
            InputStreamResource resource = new InputStreamResource(Files.newInputStream(path, new OpenOption[0]));
            return new ResponseEntity((Object)resource, (MultiValueMap)headers, HttpStatus.OK);
        }
        catch (IOException e) {
            log.error("FileService.fileDownload: Exception: {}", (Object)e.toString());
            return null;
        }
    }

    public void fileDelete(String fileName, String filePath) {
        File file = new File(this.sysDir + filePath + fileName);
        if (file.exists()) {
            if (file.delete()) {
                log.info("FileService.fileDelete: Delete Success: {}", (Object)(filePath + fileName));
            } else {
                log.error("FileService.fileDelete: Delete Fail: {}", (Object)(filePath + fileName));
            }
        } else {
            log.warn("FileService.fileDelete: Not exists: {}", (Object)(filePath + fileName));
        }
    }

    public List<voFileInfo> getLogFiles() {
        this.id = 1;
        voFileInfo rootFile = new voFileInfo();
        rootFile.setId(this.id);
        rootFile.setType("dir");
        ++this.id;
        rootFile.setFileName("logs");
        rootFile.setFileInfos(this.getFiles(this.sysDir, this.logDir));
        ArrayList<voFileInfo> fileInfos = new ArrayList<voFileInfo>();
        fileInfos.add(rootFile);
        return fileInfos;
    }

    private List<voFileInfo> getFiles(String sysDir, String logDir) {
        voFileInfo info;
        File[] fileList;
        int rootId = this.id - 1;
        ArrayList<voFileInfo> subArr = new ArrayList<voFileInfo>();
        File dirFile = new File(sysDir, logDir);
        for (File file : fileList = dirFile.listFiles()) {
            info = new voFileInfo();
            if (!file.isDirectory()) continue;
            for (String dir : this.exceptDir) {
                if (dir.equals(file.getName())) break;
                String subDir = file.getPath().substring(file.getPath().indexOf(logDir.replaceAll("/", "")), file.getPath().length());
                info.setId(this.id);
                ++this.id;
                String sFileSeparator = "/";
                info.setFilePath(sFileSeparator + subDir);
                info.setFileName(file.getName());
                info.setFileSize(file.length());
                info.setType("dir");
                info.setFileInfos(this.getFiles(sysDir, subDir));
                info.setParentId(rootId);
                subArr.add(info);
            }
        }
        for (File file : fileList) {
            info = new voFileInfo();
            if (!file.isFile() || !file.getName().contains(".log")) continue;
            info.setId(this.id);
            ++this.id;
            info.setFileName(file.getName());
            info.setFileSize(file.length());
            String subDir = OS.isWindows() ? file.getPath().substring(file.getPath().indexOf(logDir.replaceAll("/", "")), file.getPath().length() - file.getName().length()).replaceAll("\\\\", "/") : file.getPath().substring(file.getPath().indexOf(logDir), file.getPath().length() - file.getName().length()).replaceAll("\\\\", "/");
            String sFileSeparator = "/";
            info.setFilePath(sFileSeparator + subDir);
            info.setType("log");
            info.setParentId(rootId);
            subArr.add(info);
        }
        return subArr;
    }
}

