/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.driver.InsensitiveScrollableResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;

class SensitiveScrollableResultSet
extends InsensitiveScrollableResultSet {
    protected int beginLastFetchedIndex;
    protected int endLastFetchedIndex;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    SensitiveScrollableResultSet(PhysicalConnection physicalConnection, OracleStatement oracleStatement) throws SQLException {
        super(physicalConnection, oracleStatement);
        if (this.fetchedRowCount > 0) {
            this.beginLastFetchedIndex = 0;
            this.endLastFetchedIndex = this.fetchedRowCount - 1;
        } else {
            this.beginLastFetchedIndex = -1;
            this.endLastFetchedIndex = -1;
        }
    }

    @Override
    public int getType() {
        return 1005;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (super.next()) {
                this.handleRefetch();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean first() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (super.first()) {
                this.handleRefetch();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean last() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (super.last()) {
                this.handleRefetch();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean absolute(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (super.absolute(n2)) {
                this.handleRefetch();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean relative(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (super.relative(n2)) {
                this.handleRefetch();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean previous() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (super.previous()) {
                this.handleRefetch();
                return true;
            }
            return false;
        }
    }

    @Override
    int refreshRows(int n2, int n3) throws SQLException {
        int n4 = super.refreshRows(n2, n3);
        if (n4 != 0) {
            this.beginLastFetchedIndex = n2;
            this.endLastFetchedIndex = n2 + n4 - 1;
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void removeCurrentRowFromCache() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2 = this.currentRow;
            super.removeCurrentRowFromCache();
            if (!this.isEmptyResultSet()) {
                if (n2 < this.beginLastFetchedIndex) {
                    --this.beginLastFetchedIndex;
                }
                if (n2 <= this.endLastFetchedIndex) {
                    --this.endLastFetchedIndex;
                }
                if (!this.isAfterLast()) {
                    this.handleRefetch();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleRefetch() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            if (this.beginLastFetchedIndex <= this.currentRow && this.currentRow <= this.endLastFetchedIndex) {
                return false;
            }
            this.refreshRow();
            return true;
        }
    }
}

