/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import javax.xml.namespace.QName;
import org.springframework.util.StringUtils;
import org.springframework.ws.transport.AbstractSenderConnection;
import org.springframework.ws.transport.FaultAwareWebServiceConnection;

public abstract class AbstractHttpSenderConnection
extends AbstractSenderConnection
implements FaultAwareWebServiceConnection {
    private Boolean hasResponse;
    private PushbackInputStream rawResponseInputStream;

    @Override
    public final boolean hasError() throws IOException {
        return this.getResponseCode() / 100 != 2;
    }

    @Override
    public final String getErrorMessage() throws IOException {
        StringBuilder builder = new StringBuilder();
        String responseMessage = this.getResponseMessage();
        if (StringUtils.hasLength((String)responseMessage)) {
            builder.append(responseMessage);
        }
        builder.append(" [");
        builder.append(this.getResponseCode());
        builder.append(']');
        return builder.toString();
    }

    @Override
    protected final boolean hasResponse() throws IOException {
        int responseCode = this.getResponseCode();
        if (202 == responseCode || 204 == responseCode) {
            return false;
        }
        if (this.hasResponse != null) {
            return this.hasResponse;
        }
        long contentLength = this.getResponseContentLength();
        if (contentLength < 0L) {
            this.rawResponseInputStream = new PushbackInputStream(this.getRawResponseInputStream());
            int b = this.rawResponseInputStream.read();
            if (b == -1) {
                this.hasResponse = Boolean.FALSE;
            } else {
                this.hasResponse = Boolean.TRUE;
                this.rawResponseInputStream.unread(b);
            }
        } else {
            this.hasResponse = contentLength > 0L;
        }
        return this.hasResponse;
    }

    @Override
    protected final InputStream getResponseInputStream() throws IOException {
        InputStream inputStream = this.rawResponseInputStream;
        if (inputStream == null) {
            inputStream = this.getRawResponseInputStream();
        }
        return this.isGzipResponse() ? new GZIPInputStream(inputStream) : inputStream;
    }

    private boolean isGzipResponse() throws IOException {
        Iterator<String> iterator = this.getResponseHeaders("Content-Encoding");
        if (iterator.hasNext()) {
            String encodingHeader = iterator.next();
            return encodingHeader.toLowerCase().contains("gzip");
        }
        return false;
    }

    protected abstract int getResponseCode() throws IOException;

    protected abstract String getResponseMessage() throws IOException;

    protected abstract long getResponseContentLength() throws IOException;

    protected abstract InputStream getRawResponseInputStream() throws IOException;

    @Override
    public final boolean hasFault() throws IOException {
        switch (this.getResponseCode()) {
            case 500: {
                return this.isSoap11Response() || this.isSoap12Response();
            }
            case 400: {
                return this.isSoap12Response();
            }
        }
        return false;
    }

    private boolean isSoap11Response() throws IOException {
        Iterator<String> iterator = this.getResponseHeaders("Content-Type");
        if (iterator.hasNext()) {
            String contentType = iterator.next().toLowerCase();
            return contentType.contains("text/xml");
        }
        return false;
    }

    private boolean isSoap12Response() throws IOException {
        Iterator<String> iterator = this.getResponseHeaders("Content-Type");
        if (iterator.hasNext()) {
            String contentType = iterator.next().toLowerCase();
            return contentType.contains("application/soap+xml");
        }
        return false;
    }

    @Override
    @Deprecated
    public final void setFault(boolean fault) {
    }

    @Override
    public final void setFaultCode(QName faultCode) throws IOException {
    }
}

