/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.wsdl.wsdl11;

import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.ws.wsdl.WsdlDefinitionException;
import org.springframework.ws.wsdl.wsdl11.Wsdl11Definition;
import org.w3c.dom.Document;

public class Wsdl4jDefinition
implements Wsdl11Definition {
    private Definition definition;
    private final Object monitor = new Object();

    public Wsdl4jDefinition() {
    }

    public Wsdl4jDefinition(Definition definition) {
        this.setDefinition(definition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Definition getDefinition() {
        Object object = this.monitor;
        synchronized (object) {
            return this.definition;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefinition(Definition definition) {
        Object object = this.monitor;
        synchronized (object) {
            this.definition = definition;
        }
    }

    @Override
    public Source getSource() {
        Object object = this.monitor;
        synchronized (object) {
            Assert.notNull((Object)this.definition, (String)"definition must not be null");
            try {
                WSDLFactory wsdlFactory = WSDLFactory.newInstance();
                WSDLWriter wsdlWriter = wsdlFactory.newWSDLWriter();
                Document document = wsdlWriter.getDocument(this.definition);
                return new DOMSource(document);
            }
            catch (WSDLException ex) {
                throw new WsdlDefinitionException(ex.getMessage(), ex);
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Wsdl4jDefinition");
        if (this.definition != null && StringUtils.hasLength((String)this.definition.getTargetNamespace())) {
            builder.append('{');
            builder.append(this.definition.getTargetNamespace());
            builder.append('}');
        }
        return builder.toString();
    }
}

