/*
 * Decompiled with CFR 0.152.
 */
package com.its.app.webapp.controller;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.its.app.config.AbstractServerConfig;
import com.its.app.webapp.service.FileService;
import com.its.app.webapp.vo.voFileInfo;
import com.its.utils.Ping;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class WebAppCommonController {
    private static final Logger log = LoggerFactory.getLogger(WebAppCommonController.class);
    private final ResourceLoader resourceLoader;
    private final AbstractServerConfig serverConfig;
    private final FileService fileService;

    public WebAppCommonController(ResourceLoader resourceLoader, AbstractServerConfig serverConfig, FileService fileService) {
        this.resourceLoader = resourceLoader;
        this.serverConfig = serverConfig;
        this.fileService = fileService;
    }

    @RequestMapping(value={"/", "/index"})
    public String index(Model model, HttpServletRequest request) {
        String result = "system";
        model.addAttribute("ServerConfig", (Object)this.serverConfig);
        model.addAttribute("ServerTime", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        return result;
    }

    @RequestMapping(value={"/log"})
    public String logFiles(Model model, HttpServletRequest request) {
        String result = "log";
        List<voFileInfo> info = this.fileService.getLogFiles();
        ObjectMapper mapper = new ObjectMapper();
        String jsonList = "";
        try {
            jsonList = mapper.writeValueAsString(info);
        }
        catch (IOException e) {
            log.error("WebAppController.logFiles: Exception: {}", (Object)e.toString());
        }
        model.addAttribute("ServerConfig", (Object)this.serverConfig);
        model.addAttribute("fileList", (Object)jsonList);
        model.addAttribute("ServerTime", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        return result;
    }

    @RequestMapping(value={"/login"})
    public String login(Model model) {
        String result = "login";
        model.addAttribute("ServerConfig", (Object)this.serverConfig);
        model.addAttribute("ServerTime", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        return result;
    }

    @GetMapping(value={"/logout"})
    public void logout() {
    }

    @RequestMapping(value={"/getServerDate"})
    @ResponseBody
    public Map<String, Object> getServerDate() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("serverDate", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        return map;
    }

    @RequestMapping(value={"/getFileView"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public String getFileView(@RequestParam(value="fileName") String fileName, @RequestParam(value="filePath") String filePath, HttpServletRequest request) {
        return this.fileService.getView(request, fileName, filePath);
    }

    @RequestMapping(value={"/getFileDownload"})
    public ResponseEntity<Resource> getFileDownload(@RequestParam(value="fileName") String fileName, @RequestParam(value="filePath") String filePath, HttpSession session, HttpServletRequest req, HttpServletResponse res, ModelAndView mav) throws UnsupportedEncodingException {
        return this.fileService.fileDownload(fileName, filePath);
    }

    @RequestMapping(value={"/getFileDelete"})
    @ResponseBody
    public List<voFileInfo> getFileDelete(@RequestParam(value="fileName") String fileName, @RequestParam(value="filePath") String filePath) {
        this.fileService.fileDelete(fileName, filePath);
        List<voFileInfo> fileArr = this.fileService.getLogFiles();
        return fileArr;
    }

    @RequestMapping(value={"/getPing"})
    @ResponseBody
    public String getPing(@RequestParam(value="ipAddr") String ipAddr) {
        String result = this.ping(ipAddr);
        return result;
    }

    public String ping(String ipAddr) {
        String result = "";
        long startTm = System.nanoTime();
        long endTm = System.nanoTime();
        try {
            boolean isReachable = Ping.isReachable(ipAddr, 5);
            endTm = System.nanoTime();
            result = isReachable ? ipAddr + " is alive. " + Long.toString((endTm - startTm) / 1000000L) + " ms." : ipAddr + " is not alive. time out: " + Long.toString((endTm - startTm) / 1000000L) + " ms.";
        }
        catch (Exception e) {
            result = ipAddr + " error. " + Long.toString((endTm - startTm) / 1000000L) + " ms. Exception: " + e.toString();
        }
        return result;
    }
}

