/*
 * Decompiled with CFR 0.152.
 */
package com.its.app.xnetudp.codec;

import com.its.app.config.AbstractServerConfig;
import com.its.app.config.AppUtils;
import com.its.app.xnetudp.protocol.CENTER_COMM_MESSAGE;
import com.its.utils.SysUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.net.InetSocketAddress;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CenterCommServerDecoder
extends MessageToMessageDecoder<DatagramPacket> {
    private static final Logger log = LoggerFactory.getLogger(CenterCommServerDecoder.class);
    private AbstractServerConfig serverConfig = (AbstractServerConfig)AppUtils.getBean(AbstractServerConfig.class);

    protected void decode(ChannelHandlerContext ctx, DatagramPacket packet, List<Object> out) throws Exception {
        ByteBuf buf = (ByteBuf)packet.content();
        int recvBytes = buf.readableBytes();
        log.info("RECV: [{}], {} Bytes.", (Object)packet.sender(), (Object)recvBytes);
        if (buf.readableBytes() < CENTER_COMM_MESSAGE.CENTER_HEADER_SIZE) {
            log.error("RECV: UDP Message header length error: {}/{} Bytes.", (Object)recvBytes, (Object)CENTER_COMM_MESSAGE.CENTER_HEADER_SIZE);
            return;
        }
        byte[] buffer = new byte[recvBytes];
        buf.getBytes(buf.readerIndex(), buffer);
        if (this.serverConfig.getCenterDump().equals("true")) {
            log.info("RECV DUMP: {}", (Object)SysUtils.byteArrayToHex(buffer));
        }
        CENTER_COMM_MESSAGE msg = new CENTER_COMM_MESSAGE(buffer, (InetSocketAddress)packet.sender());
        out.add(msg);
    }
}

