/*
 * Decompiled with CFR 0.152.
 */
package com.its.utils;

public class ByteUtils {
    private static final int[] BYTE_MASKED_ARRAY = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
    static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    public static final int BIT_1 = 1;
    public static final int BIT_2 = 3;
    public static final int BIT_3 = 7;
    public static final int BIT_4 = 15;
    public static final int BIT_5 = 31;
    public static final int BIT_6 = 63;
    public static final int BIT_7 = 127;
    public static final int BIT_8 = 255;
    public static final int BIT_9 = 511;
    public static final int BIT_10 = 1023;
    public static final int BIT_11 = 2047;
    public static final int BIT_12 = 4095;
    public static final int BIT_13 = 8191;
    public static final int BIT_14 = 16383;
    public static final int BIT_15 = Short.MAX_VALUE;
    public static final int BIT_16 = 65535;

    public static int byteToInt(byte srcValue) {
        return srcValue & 0xFF;
    }

    public static int shortToInt(short srcValue) {
        return srcValue & 0xFFFF;
    }

    public static long intToLong(int srcValue) {
        return srcValue & 0xFFFFFFFF;
    }

    public static int longToInt(long srcValue) {
        return (int)(srcValue & 0xFFFFFFFFFFFFFFFFL);
    }

    public static String byteToBitString(byte srcValue) {
        return String.format("%8s", Long.toBinaryString(srcValue & 0xFF)).replace(' ', '0');
    }

    public static String shortToBitString(short srcValue) {
        return String.format("%16s", Long.toBinaryString(srcValue & 0xFF)).replace(' ', '0');
    }

    public static String intToBitString(int srcValue) {
        return String.format("%32s", Integer.toBinaryString(srcValue & 0xFF)).replace(' ', '0');
    }

    public static String longToBitString(long srcValue) {
        return String.format("%64s", Long.toBinaryString(srcValue & 0xFFL)).replace(' ', '0');
    }

    public static int extractBits(byte srcValue, int beginBitDigit, int endBitDigit) {
        int maskedValue = 0;
        for (int idx = beginBitDigit; idx <= endBitDigit; ++idx) {
            maskedValue += BYTE_MASKED_ARRAY[idx];
        }
        return (srcValue & maskedValue) >> beginBitDigit;
    }

    public static int extractBit(byte srcValue, int bitDigit) {
        return (srcValue & BYTE_MASKED_ARRAY[bitDigit]) == BYTE_MASKED_ARRAY[bitDigit] ? 1 : 0;
    }

    public static int compareMaskedValue(byte srcValue, int maskValue, int compareValue) {
        int resultValue = ByteUtils.byteToInt(srcValue) & maskValue;
        return resultValue == compareValue ? 0 : (resultValue > compareValue ? 1 : -1);
    }

    public static String convertCustomDateTime(String strDate) {
        String convertDate = strDate;
        if (convertDate.lastIndexOf(".") != -1) {
            convertDate = convertDate.substring(0, convertDate.lastIndexOf("."));
        }
        return convertDate.replaceAll("-", "").replaceAll(":", "").replaceAll(" ", "");
    }

    public static byte[] hexToByteArray(String hex) {
        if (hex == null || hex.length() == 0) {
            return null;
        }
        byte[] ba = new byte[hex.length() / 2];
        for (int i = 0; i < ba.length; ++i) {
            ba[i] = (byte)Integer.parseInt(hex.substring(2 * i, 2 * i + 2), 16);
        }
        return ba;
    }

    public static String byteArrayToHex(byte[] ba) {
        return ByteUtils.byteArrayToHex(ba, null);
    }

    public static byte[] intToShortBytes(int length) {
        byte[] b3 = new byte[2];
        if (length > 255) {
            b3[0] = (byte)(length / 256);
            b3[1] = (byte)(length % 256);
        } else {
            b3[0] = 0;
            b3[1] = (byte)length;
        }
        return b3;
    }

    public static int getIntOnBit(int n, int offset, int length) {
        return n >> 32 - offset - length & ~(-1 << length);
    }

    public static String byteArrayToHex(byte[] ba, String seperator) {
        if (ba == null || ba.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer(ba.length * 2);
        for (int x = 0; x < ba.length; ++x) {
            String hexNumber = "0" + Integer.toHexString(0xFF & ba[x]).toUpperCase();
            sb.append(hexNumber.substring(hexNumber.length() - 2));
            sb.append(seperator);
        }
        return sb.toString();
    }

    public static String bytesToHex(byte[] bytes, int bundleSize, char seperator) {
        char[] hexChars = new char[bytes.length * 2 + bytes.length / bundleSize];
        int j = 0;
        int k = 1;
        while (j < bytes.length) {
            int v = bytes[j] & 0xFF;
            int start = j * 2 + j / bundleSize;
            hexChars[start] = HEX_ARRAY[v >>> 4];
            hexChars[start + 1] = HEX_ARRAY[v & 0xF];
            if (k % bundleSize == 0) {
                hexChars[start + 2] = seperator;
            }
            ++j;
            ++k;
        }
        return new String(hexChars).trim();
    }

    public static String bytesToHex(byte[] bytes, int bundleSize) {
        return ByteUtils.bytesToHex(bytes, bundleSize, ' ');
    }

    public static String byteToHex(byte b) {
        String hexNumber = "0" + Integer.toHexString(0xFF & b).toUpperCase();
        return hexNumber.substring(hexNumber.length() - 2);
    }

    public static int convertNotNullStringToInt(String data) {
        if (data == null || data.trim().length() == 0) {
            return 0;
        }
        return Long.valueOf(data).intValue();
    }

    public static double convertNotNullStringToDouble(String data) {
        if (data == null || data.trim().length() == 0) {
            return 0.0;
        }
        return Double.valueOf(data);
    }

    public static String extractFilePath(String fullPath) {
        String resultPath = fullPath;
        int lastPathIndex = resultPath.lastIndexOf("/") != -1 ? resultPath.lastIndexOf("/") : resultPath.lastIndexOf("\\");
        return lastPathIndex != -1 ? resultPath.substring(0, lastPathIndex + 1) : resultPath;
    }

    public static String extractFileName(String fullPath) {
        String resultPath = fullPath;
        int lastPathIndex = resultPath.lastIndexOf("/") != -1 ? resultPath.lastIndexOf("/") : resultPath.lastIndexOf("\\");
        return lastPathIndex != -1 ? resultPath.substring(lastPathIndex + 1) : resultPath;
    }

    public static String lpad(String str, int len, String pad) {
        String result = str;
        int templen = len - result.length();
        for (int i = 0; i < templen; ++i) {
            result = pad + result;
        }
        return result;
    }

    public static int getBitField(byte b, int field) {
        return (b & 1 << field) > 0 ? 1 : 0;
    }

    public static int getBitField(byte b, int field, int count) {
        if (count == 1) {
            count = 1;
        } else if (count == 2) {
            count = 3;
        } else if (count == 3) {
            count = 7;
        } else if (count == 4) {
            count = 15;
        } else if (count == 5) {
            count = 31;
        } else if (count == 6) {
            count = 63;
        } else if (count == 7) {
            count = 127;
        } else if (count == 8) {
            count = 255;
        } else if (count == 9) {
            count = 511;
        } else if (count == 10) {
            count = 1023;
        } else if (count == 11) {
            count = 2047;
        } else if (count == 12) {
            count = 4095;
        } else if (count == 13) {
            count = 8191;
        } else if (count == 14) {
            count = 16383;
        } else if (count == 15) {
            count = Short.MAX_VALUE;
        } else if (count == 16) {
            count = 65535;
        }
        return b >> field & count;
    }

    public static byte setBitField(byte b, int field, int value) {
        if (value == 0 || value == 1) {
            b = (byte)(b | value << field);
        }
        return b;
    }

    public static byte setBitField(byte b, int field, int count, int value) {
        if (field + count <= 8 && (double)value < Math.pow(2.0, count)) {
            if (count == 1) {
                count = 1;
            } else if (count == 2) {
                count = 3;
            } else if (count == 3) {
                count = 7;
            } else if (count == 4) {
                count = 15;
            } else if (count == 5) {
                count = 31;
            } else if (count == 6) {
                count = 63;
            } else if (count == 7) {
                count = 127;
            } else if (count == 8) {
                count = 255;
            } else if (count == 9) {
                count = 511;
            } else if (count == 10) {
                count = 1023;
            } else if (count == 11) {
                count = 2047;
            } else if (count == 12) {
                count = 4095;
            } else if (count == 13) {
                count = 8191;
            } else if (count == 14) {
                count = 16383;
            } else if (count == 15) {
                count = Short.MAX_VALUE;
            } else if (count == 16) {
                count = 65535;
            }
        }
        b = (byte)(b & ~(count << field));
        b = (byte)(b | (value & count) << field);
        return b;
    }
}

