/*
 * Decompiled with CFR 0.152.
 */
package com.tmax.tibero.jdbc.data.charset;

public class JIS0213ByteToCharConverter {
    private static final char MIN_LOW_SURROGATE = '\udc00';
    private static final char MIN_HIGH_SURROGATE = '\ud800';
    private static final int MIN_SUPPLEMENTARY_CODE_POINT = 65536;
    static final int[][] JISX0213_TO_UCS__COMBINING = new int[][]{{12363, 12442}, {12365, 12442}, {12367, 12442}, {12369, 12442}, {12371, 12442}, {12459, 12442}, {12461, 12442}, {12463, 12442}, {12465, 12442}, {12467, 12442}, {12475, 12442}, {12484, 12442}, {12488, 12442}, {12791, 12442}, {230, 768}, {596, 768}, {596, 769}, {652, 768}, {652, 769}, {601, 768}, {601, 769}, {602, 768}, {602, 769}, {745, 741}, {741, 745}};
    private static final int[] JISX0213_TO_UCS__MAIN;
    private static final int[] JISX0213_TO_UCS__PAGESTART;

    /*
     * Opcode count of 15054 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static final int loadUcsMain1(int n) {
        int[] nArray = new int[]{4096, 4097, 4098, 33548, 33550, 4347, 33562, 33563, 33567, 33537, 4251, 4252, 180, 33600, 168, 33598, 33763, 33599, 4349, 4350, 4253, 4254, 4099, 11997, 4101, 4102, 4103, 4348, 1812, 1808, 33551, 33596, 4124, 1814, 33628, 1830, 1829, 1816, 1817, 1820, 1821, 33544, 33545, 4116, 4117, 33595, 33597, 33627, 33629, 4104, 4105, 4106, 4107, 4108, 4109, 4110, 4111, 4112, 4113, 33547, 2322, 177, 215, 247, 33565, 2400, 33564, 33566, 2406, 2407, 2334, 2356, 3394, 3392, 176, 1842, 1843, 2051, 33765, 33540, 162, 163, 33541, 33539, 33542, 33546, 33568, 167, 3334, 3333, 3275, 3279, 3278, 3271, 3270, 3233, 3232, 3251, 3250, 3261, 3260, 1851, 4114, 2194, 2192, 2193, 2195, 4115, 33543, 33538, 33549, 33630, 4147, 4148, 4149, 4155, 4156, 4351, 4255, 2312, 2315, 2438, 2439, 2434, 2435, 2346, 2345, 2436, 2437, 2442, 2443, 2313, 2309, 2565, 2566, 2343, 2344, 172, 2258, 2260, 2304, 2307, 2453, 2454, 2455, 2341, 2342, 33631, 33632, 4120, 4121, 4118, 4119, 2336, 2469, 2578, 2306, 2311, 2401, 2386, 2410, 2411, 2330, 2365, 2333, 2357, 2347, 2348, 2402, 2371, 2373, 2376, 2422, 2423, 2196, 2091, 1840, 3439, 3437, 3434, 1824, 1825, 182, 3438, 3435, 3436, 3433, 3311, 3255, 3254, 3265, 3264, 2199, 2200, 2198, 2201, 2244, 2280, 2278, 2279, 2281, 3892, 3893, 33552, 33553, 33554, 33555, 33556, 33557, 33558, 33559, 33560, 33561, 4031, 3273, 4157, 33350, 33349, 3302, 1826, 33569, 33570, 33571, 33572, 33573, 33574, 33575, 33576, 33577, 33578, 33579, 33580, 33581, 33582, 33583, 33584, 33585, 33586, 33587, 33588, 33589, 33590, 33591, 33592, 33593, 33594, 2323, 2101, 2063, 5067, 2067, 2087, 33601, 33602, 33603, 33604, 33605, 33606, 33607, 33608, 33609, 33610, 33611, 33612, 33613, 33614, 33615, 33616, 33617, 33618, 33619, 33620, 33621, 33622, 33623, 33624, 33625, 33626, 4256, 1811, 4090, 4091, 4161, 4162, 4163, 4164, 4165, 4166, 4167, 4168, 4169, 4170, 4171, 4172, 4173, 4174, 4175, 4176, 4177, 4178, 4179, 4180, 4181, 4182, 4183, 4184, 4185, 4186, 4187, 4188, 4189, 4190, 4191, 4192, 4193, 4194, 4195, 4196, 4197, 4198, 4199, 4200, 4201, 4202, 4203, 4204, 4205, 4206, 4207, 4208, 4209, 4210, 4211, 4212, 4213, 4214, 4215, 4216, 4217, 4218, 4219, 4220, 4221, 4222, 4223, 4224, 4225, 4226, 4227, 4228, 4229, 4230, 4231, 4232, 4233, 4234, 4235, 4236, 4237, 4238, 4239, 4240, 4241, 4242, 4243, 4244, 4245, 4246, 1, 2, 3, 4, 5, 0, 0, 0, 4257, 4258, 4259, 4260, 4261, 4262, 4263, 4264, 4265, 4266, 4267, 4268, 4269, 4270, 4271, 4272, 4273, 4274, 4275, 4276, 4277, 4278, 4279, 4280, 4281, 4282, 4283, 4284, 4285, 4286, 4287, 4288, 4289, 4290, 4291, 4292, 4293, 4294, 4295, 4296, 4297, 4298, 4299, 4300, 4301, 4302, 4303, 4304, 4305, 4306, 4307, 4308, 4309, 4310, 4311, 4312, 4313, 4314, 4315, 4316, 4317, 4318, 4319, 4320, 4321, 4322, 4323, 4324, 4325, 4326, 4327, 4328, 4329, 4330, 4331, 4332, 4333, 4334, 4335, 4336, 4337, 4338, 4339, 4340, 4341, 4342, 6, 7, 8, 9, 10, 11, 12, 13, 913, 914, 915, 916, 917, 918, 919, 920, 921, 922, 923, 924, 925, 926, 927, 928, 929, 931, 932, 933, 934, 935, 936, 937, 3428, 3424, 3426, 3430, 3425, 3429, 3431, 3427, 945, 946, 947, 948, 949, 950, 951, 952, 953, 954, 955, 956, 957, 958, 959, 960, 961, 963, 964, 965, 966, 967, 968, 969, 962, 3061, 3062, 3063, 3064, 3065, 3066, 3067, 3068, 3069, 3070, 3350, 3351, 4128, 3342, 3328, 3329, 3330, 3331, 3432, 3249, 4592, 4593, 4594, 4595, 4596, 4597, 4598, 4599, 4600, 4601, 14, 4602, 4603, 4604, 4605, 4606, 4607, 1040, 1041, 1042, 1043, 1044, 1045, 1025, 1046, 1047, 1048, 1049, 1050, 1051, 1052, 1053, 1054, 1055, 1056, 1057, 1058, 1059, 1060, 1061, 1062, 1063, 1064, 1065, 1066, 1067, 1068, 1069, 1070, 1071, 2750, 2751, 2752, 2753, 2754, 2755, 2756, 2757, 2758, 2759, 2760, 2761, 2762, 2763, 2764, 1072, 1073, 1074, 1075, 1076, 1077, 1105, 1078, 1079, 1080, 1081, 1082, 1083, 1084, 1085, 1086, 1087, 1088, 1089, 1090, 1091, 1092, 1093, 1094, 1095, 1096, 1097, 1098, 1099, 1100, 1101, 1102, 1103, 4343, 4344, 4345, 4346, 2522, 2523, 2131, 2132, 2133, 3603, 2584, 2851, 2766, 3072, 3074, 3084, 3088, 3096, 3092, 3100, 3116, 3108, 3124, 3132, 3073, 3075, 3087, 3091, 3099, 3095, 3107, 3123, 3115, 3131, 3147, 3104, 3119, 3112, 3127, 3135, 3101, 3120, 3109, 3128, 3138, 4689, 4690, 4691, 4692, 4693, 4694, 4695, 4696, 4697, 4698, 4699, 4700, 4701, 4702, 4703, 4785, 4786, 4787, 4788, 4789, 4790, 4791, 4792, 4793, 4794, 4795, 4796, 4797, 4798, 4799, 0, 0, 0, 0, 0, 0, 0, 0, 3280, 3281, 3282, 3283, 1852, 1863, 1864, 1865, 461, 462, 464, 1342, 1343, 504, 505, 465, 466, 468, 470, 472, 474, 476, 0, 0, 1964, 160, 161, 164, 166, 169, 170, 171, 173, 174, 175, 178, 179, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 248, 249, 250, 251, 252, 253, 254, 255, 256, 298, 362, 274, 332, 257, 299, 363, 275, 333, 260, 728, 321, 317, 346, 352, 350, 356, 377, 381, 379, 261, 731, 322, 318, 347, 711, 353, 351, 357, 378, 733, 382, 380, 340, 258, 313, 262, 268, 280, 282, 270, 323, 327, 336, 344, 366, 368, 354, 341, 259, 314, 263, 269, 281, 283, 271, 273, 324, 328, 337, 345, 367, 369, 355, 729, 264, 284, 292, 308, 348, 364, 265, 285, 293, 309, 349, 365, 625, 651, 638, 643, 658, 620, 622, 633, 648, 598, 627, 637, 642, 656, 635, 621, 607, 626, 669, 654, 609, 331, 624, 641, 295, 661, 660, 614, 664, 450, 595, 599, 644, 608, 403, 339, 338, 616, 649, 600, 629, 601, 604, 606, 592, 623, 650, 612, 652, 596, 593, 594, 653, 613, 674, 673, 597, 657, 634, 615, 602, 15, 509, 1648, 1649, 16, 17, 18, 19, 20, 21, 22, 23, 1650, 1651, 865, 712, 716, 720, 721, 774, 1855, 779, 769, 772, 768, 783, 780, 770, 741, 742, 743, 744, 745, 24, 25, 805, 812, 825, 796, 799, 800, 776, 829, 809, 815, 734, 804, 816, 828, 820, 797, 798, 792, 793, 810, 826, 827, 771, 794, 3702, 3703, 3704, 3705, 3706, 3707, 3708, 3709, 3710, 3711, 3051, 3052, 3053, 3054, 3055, 3056, 3057, 3058, 3059, 3060, 2160, 2161, 2162, 2163, 2164, 2165, 2166, 2167, 2168, 2169, 2170, 2171, 3024, 3025, 3026, 3027, 3028, 3029, 3030, 3031, 3032, 3033, 3034, 3035, 3036, 3037, 3038, 3039, 3040, 3041, 3042, 3043, 3044, 3045, 3046, 3047, 3048, 3049, 4816, 4817, 4818, 4819, 4820, 4821, 4822, 4823, 4824, 4825, 4826, 4827, 4828, 4829, 4830, 4831, 4832, 4833, 4834, 4835, 4858, 4841, 4837, 4845, 4844, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1873, 1858, 2912, 2913, 2914, 2915, 2916, 2917, 2918, 2919, 2920, 2921, 2922, 2923, 2924, 2925, 2926, 2927, 2928, 2929, 2930, 2931, 2144, 2145, 2146, 2147, 2148, 2149, 2150, 2151, 2152, 2153, 2154, 4937, 4884, 4898, 4941, 4888, 4903, 4867, 4918, 4945, 4951, 4877, 4902, 4899, 4907, 4938, 4923, 5020, 5021, 5022, 5006, 5007, 5060, 5025, 2155, 0, 0, 0, 0, 0, 0, 0, 4987, 4125, 4127, 2070, 5069, 2081, 4772, 4773, 4774, 4775, 4776, 4657, 4658, 4665, 4990, 4989, 4988, 0, 0, 0, 2350, 0, 0, 0, 0, 2335, 2495, 0, 0, 0, 3670, 3358, 12273, 33803, 5122, 11816, 11823, 11824, 11917, 12001, 12029, 12031, 12035, 12043, 12128, 12104, 12105, 12118, 12127, 12138, 12140, 12158, 12170, 12180, 12183, 33072, 12233, 12256, 12289, 12290, 12302, 12312, 12327, 12334, 12352, 12347, 12353, 12436, 12492, 12530, 12496, 12518, 33073, 12550, 12547, 12555, 12574, 12597, 12618, 33074, 12629, 12631, 5301, 12701, 12739, 12746, 12766, 12770, 12782, 12801, 5339, 12819, 12821, 12873, 12887, 12897, 12947, 13000, 33075, 13004, 13008, 13014, 13019, 33076, 13040, 13051, 13056, 13063, 13084, 33077, 13153, 13155, 13181, 13203, 13213, 13234, 13330, 13351, 13389, 13468, 13419, 13428, 13439, 13448, 13462, 13473, 13481, 13510, 13567, 13582, 13611, 13621, 13648, 13662, 13697, 13702, 13710, 33078, 13741, 13774, 33079, 13832, 13838, 13883, 13897, 13942, 13926, 33080, 13935, 13937, 13938, 13977, 13982, 13993, 13996, 14003, 14025, 14026, 14090, 37437, 14113, 14127, 14131, 14132, 14192, 14199, 14204, 14236, 33039, 37659, 14264, 14279, 14280, 14287, 14308, 14317, 14325, 14326, 14335, 14345, 33040, 14433, 14436, 33081, 14460, 14473, 14494, 33082, 14505, 37998, 14546, 14542, 14548, 14554, 14560, 14569, 14604, 26177, 14685, 14701, 14731, 14738, 14756, 14787, 14802, 14813, 14867, 14883, 14951, 14957, 14967, 14974, 14980, 15006, 15015, 15044, 39101, 15129, 15141, 12893, 11932, 13590, 14851, 30271, 13504, 16667, 17192, 14838, 28706, 25717, 25372, 23120, 16554, 17377, 20005, 17901, 25702, 25254, 31733, 18579, 14119, 17825, 17009, 15259, 14800, 26235, 30964, 23906, 23998, 31630, 16918, 23711, 26807, 15241, 16053, 17161, 18071, 18504, 30151, 30605, 18255, 12005, 12042, 12109, 12189, 12361, 14066, 14647, 14804, 14849, 15369, 16607, 16655, 16752, 17939, 18693, 20666, 21839, 21872, 23035, 23981, 24047, 24771, 25614, 26723, 27394, 28757, 28794, 13115, 11925, 11941, 14303, 24754, 28865, 22767, 11776, 14577, 20130, 28728, 23090, 25384, 25227, 31791, 12609, 13168, 13501, 13537, 14048, 14843, 16149, 30962, 19947, 24804, 25901, 30306, 30320, 30368, 30715, 13323, 13299, 15239, 20687, 24509, 28610, 30440, 13167, 32092, 23226, 11793, 22675, 25084, 20006, 13848, 13572, 19229, 25882, 31803, 14821, 13225, 19814, 21724, 30095, 13890, 11921, 28747, 30450, 25423, 30988, 13281, 13750, 15152, 16241, 17952, 18163, 18436, 19512, 19699, 19753, 21595, 22216, 23118, 30772, 25329, 26715, 27232, 29421, 19890, 21931, 22218, 31173, 16550, 27393, 28042, 30130, 18830, 13229, 12678, 14098, 14384, 14660, 15284, 16118, 16424, 17321, 17396, 19647, 20244, 20622, 20756, 20825, 20949, 21311, 24065, 25206, 25297, 26007, 28768, 29275, 32027, 14441, 17852, 19546, 21797, 12793, 14638, 14693, 16256, 16348, 17084, 17914, 18986, 19239, 19380, 21387, 24513, 26966, 32044, 32014, 32452, 15521, 19606, 25467, 12548, 15435, 16822, 25030, 18550, 21089, 11865, 12282, 13176, 16489, 20009, 23119, 30707, 11787, 13078, 12014, 12117, 12093, 12193, 12147, 12960, 13295, 13833, 14607, 15041, 15286, 15329, 22993, 18055, 18332, 18358, 19276, 19635, 20587, 21442, 22925, 22974, 23100, 23431, 25265, 25307, 25348, 25463, 25583, 25555, 26470, 27314, 13865, 27816, 28646, 28750, 30494, 26250, 12228, 15592, 16913, 21081, 21819, 25061, 25277, 26366, 27840, 30405, 30995, 31189, 11979, 12058, 27107, 14046, 14410, 14538, 16123, 16363, 16426, 16532, 16482, 16848, 16914, 17104, 17721, 31553, 18022, 18608, 19831, 20592, 21836, 22150, 23925, 25253, 26617, 30091, 30350, 27805, 12785, 12990, 14614, 13491, 15283, 15638, 16744, 18818, 19887, 22669, 25803, 26711, 27250, 29607, 31416, 19820, 31144, 26329, 14243, 18431, 26318, 29198, 12931, 13959, 13316, 16083, 17121, 17593, 18492, 18488, 19387, 21362, 22714, 23147, 27034, 27090, 28011, 28419, 28909, 30115, 30356, 30569, 15206, 15539, 18813, 30797, 30798, 17307, 23328, 18987, 19071, 18614, 31757, 20319, 12914, 13725, 16496, 17132, 19771, 19975, 20177, 25691, 26896, 28484, 11796, 31801, 13302, 18715, 19002, 30596, 18474, 12636, 23235, 25778, 29148, 29580, 13915, 32040, 18466, 25349, 25649, 23717, 12808, 25285, 21734, 11902, 12163, 12704, 15314, 12810, 13016, 13031, 15867, 13722, 14378, 14822, 15244, 15256, 15323, 15986, 15993, 16547, 16671, 16739, 16830, 17371, 17762, 18385, 18515, 18682, 19262, 19283, 19543, 20258, 20375, 20293, 21680, 21784, 22243, 22283, 23295, 23457, 23585, 24041, 24374, 24560, 24733, 25190, 25502, 27059, 27340, 27819, 28804, 29777, 30099, 30097, 30114, 30309, 30675, 31016, 25112, 11832, 13355, 15544, 15820, 21417, 22092, 22332, 15529, 24555, 27915, 30401, 30737, 30804, 30808, 12033, 12046, 13169, 13724, 13928, 14330, 14663, 15113, 15300, 15504, 15884, 15998, 16332, 17390, 18234, 17879, 17890, 18207, 18635, 18628, 19039, 15920, 19397, 19479, 19581, 21887, 22856, 15203, 23040, 23808, 16317, 27023, 27160, 27828, 28023, 28364, 28445, 30946, 31246, 31548, 11904, 12413, 12544, 14739, 15260, 16943, 17024, 17644, 19258, 21152, 21905, 22855, 24489, 26619, 27324, 27504, 17324, 25546, 30624, 13321, 13315, 13739, 18516, 19032, 27248, 22567, 18293, 32461, 13172, 15266, 24858, 26192, 28678, 11800, 11845, 11975, 12049, 13258, 13368, 15278, 16147, 16421, 17745, 18237, 19522, 19570, 19683, 20600, 21507, 23158, 23214, 23304, 23834, 23806, 23910, 17895, 21083, 13243, 15429, 15848, 17106, 17120, 17177, 20000, 26202, 27185, 28125, 29432, 20225, 22950, 31578, 11944, 11947, 11948, 12187, 12192, 12497, 12615, 23286, 12657, 12790, 13140, 13089, 13183, 13291, 13740, 14467, 15585, 16183, 16202, 16431, 16464, 16493, 17183, 17753, 19019, 19649, 21186, 21229, 22511, 24824, 24837, 25096, 25934, 28919, 29665, 30719, 31063, 31322, 12016, 12765, 15405, 18049, 18797, 15424, 18162, 18805, 21385, 18512, 23681, 12485, 13028, 14151, 15870, 29478, 17828, 19235, 19261, 21556, 22913, 22973, 23371, 24010, 25273, 25548, 26751, 26975, 27449, 28625, 29137, 13343, 29312, 11869, 12342, 13285, 13114, 21207, 21398, 22505, 25318, 28335, 31174, 31176, 31186, 12663, 16666, 26206, 13744, 23162, 12406, 15315, 28743, 30341, 11826, 19163, 29159, 15441, 15432, 17304, 23199, 19603, 30580, 28513, 23210, 20874, 30344, 23682, 18455, 24176, 18513, 29548, 13042, 13339, 26027, 27155, 24484, 28365, 28897, 13158, 26760, 22849, 12226, 12478, 12817, 12612, 13651, 14125, 21482, 14219, 14673, 16226, 16260, 16501, 16758, 16743, 16809, 17330, 17466, 17772, 18031, 18498, 19987, 21862, 23101, 23803, 23884, 23961, 24139, 24427, 25358, 25418, 26317, 27144, 27235, 27494, 28413, 30746, 32143, 25272, 28622, 31720, 12935, 16927, 17539, 20416, 30361, 18497, 12433, 19232, 19578, 20308, 23156, 23888, 26688, 27171, 18184, 12022, 12345, 12326, 12389, 12668, 12856, 12899, 13735, 14095, 14341, 15052, 16122, 16818, 16888, 17139, 17266, 18716, 18985, 21117, 21164, 21294, 22548, 22639, 23929, 22284, 24745, 27019, 27417, 27874, 28370, 28771, 29557, 30330, 30805, 31251, 32376, 12611, 13215, 13235, 15995, 16166, 19995, 20112, 21380, 21502, 23875, 25143, 27136, 27386, 30288, 11854, 12299, 13284, 13436, 14074, 14801, 15204, 15857, 16043, 16167, 16952, 17733, 18351, 20054, 21200, 23754, 26804, 24737, 24801, 25584, 26190, 27271, 28136, 29239, 30407, 30823, 32531, 11924, 11922, 12045, 13128, 13385, 13374, 14895, 16268, 16289, 16543, 18599, 19086, 21594, 22657, 27294, 27300, 27511, 29072, 11870, 31689, 11940, 12156, 12207, 12313, 12310, 12617, 12652, 12959, 12985, 13054, 13210, 13283, 13329, 13326, 13705, 14161, 14242, 14717, 15188, 15197, 15247, 15845, 15847, 15863, 15992, 16003, 16026, 16055, 16152, 16466, 16716, 17047, 17112, 17319, 17723, 17922, 17987, 18164, 18285, 18465, 18583, 18891, 19551, 19754, 19817, 20015, 20125, 21810, 22151, 22636, 23103, 23776, 23813, 23832, 23902, 23985, 24597, 24579, 24751, 24753, 24916, 24975, 25130, 25426, 26700, 26721, 27419, 27810, 27900, 28874, 29045, 29297, 22591, 29436, 30116, 30285, 30725, 31129, 31448, 32059, 12891, 12971, 13303, 13320, 14549, 17143, 20448, 27754, 28511, 32441, 12619, 12859, 13386, 14077, 23104, 29047, 32096, 32466, 21316, 20233, 24944, 21777, 16381, 16602, 31400, 21211, 28604, 19300, 30723, 11978, 14064, 14180, 14526, 14938, 16488, 16839, 17935, 17926, 18489, 18609, 19959, 21973, 23866, 25198, 31554, 11931, 12112, 13257, 13574, 15727, 15846, 15854, 18427, 19609, 21619, 22530, 27216, 29590, 26847, 14160, 16039, 17195, 12469, 12460, 12685, 18176, 13513, 14430, 14779, 15280, 16233, 16973, 17313, 18493, 19315, 19976, 20605, 29127, 21120, 22549, 22566, 22893, 17806, 23856, 25564, 26817, 28425, 30363, 12900, 14120, 18256, 24426, 27809, 12724, 14146, 30250, 14394, 18826, 24756, 13490, 15630, 14332, 22677, 32250, 12124, 12874, 13451, 17470, 17960, 18196, 18421, 23172, 23382, 23842, 29487, 18524, 31661, 23353, 13081, 12682, 12855, 15327, 17142, 17582, 17638, 18221, 19386, 26025, 30417, 22160, 31702, 17228, 29446, 31659, 22207, 18002, 11785, 12440, 13250, 15473, 16616, 17554, 17763, 18527, 20966, 21450, 21795, 23447, 24194, 26261, 27523, 27867, 29048, 30992, 17836, 18091, 19339, 11989, 11988, 12090, 12159, 12858, 13304, 13298, 13795, 14043, 14571, 14795, 14793, 14847, 15184, 15437, 15874, 15915, 16343, 16413, 17159, 17711, 15196, 17839, 17853, 17896, 18333, 19298, 19323, 19471, 21317, 22857, 22977, 23800, 23833, 23851, 24738, 24834, 25075, 27030, 27230, 27241, 27238, 27276, 27374, 27847, 27868, 30412, 30972, 19311, 11915, 12092, 12173, 12624, 15191, 15354, 16712, 17153, 17986, 19233, 20171, 19643, 21054, 21693, 21972, 22721, 22842, 24588, 24627, 25066, 25748, 28574, 19536, 32383, 16143, 27480, 32043, 23290, 28408, 15245, 30443, 11779, 13297, 14327, 14641, 15049, 15268, 16521, 20095, 20230, 21950, 27882, 15263, 25856, 23520, 12402, 18420, 25245, 15457, 25930, 24094, 25102, 12697, 15364, 17256, 28006, 17820, 20846, 22846, 23831, 24581, 27421, 28362, 28782, 26311, 28842, 12319, 13050, 15418, 18259, 20604, 21045, 29004, 29128, 29483, 25317, 15298, 16177, 16633, 11835, 13270, 15240, 16971, 18225, 19338, 21225, 21472, 23086, 24939, 28067, 29010, 31126, 12562, 13271, 13418, 15359, 17288, 19001, 23980, 30464, 14042, 13262, 13416, 15255, 15409, 15838, 12270, 16641, 17150, 19762, 22976, 22987, 23874, 24141, 24530, 25069, 25119, 25744, 26694, 26994, 27536, 28276, 28463, 28721, 29003, 29036, 30406, 29084, 11968, 12111, 12613, 13121, 16275, 16910, 18388, 19521, 19979, 21347, 24102, 29133, 29315, 13268, 14617, 15295, 19921, 22877, 24110, 23707, 14462, 20895, 12794, 26707, 28656, 12234, 15611, 17957, 22444, 23267, 25116, 31231, 12742, 16298, 17900, 18799, 19337, 19955, 20118, 20324, 22270, 23828, 15841, 28789, 29063, 30726, 12774, 12829, 16960, 18065, 18137, 19994, 16054, 24018, 24434, 18168, 26031, 26103, 27384, 12969, 13273, 14707, 16015, 16272, 16469, 29412, 30308, 12471, 12575, 13021, 13088, 13127, 13292, 13544, 13638, 13617, 13847, 14696, 14782, 14908, 15285, 15366, 15375, 15377, 15386, 16004, 16010, 16096, 16240, 17023, 17028, 17115, 17292, 17271, 17927, 17932, 17965, 18038, 18302, 18594, 18975, 18997, 19644, 19848, 19977, 20056, 20796, 20774, 20839, 21959, 22273, 22621, 22785, 22885, 23024, 23264, 23313, 23719, 23865, 24726, 25558, 25739, 25929, 26717, 26867, 27167, 27196, 27220, 27251, 27745, 27870, 29092, 29286, 29566, 29720, 30364, 30616, 11786, 11784, 11806, 11863, 12695, 12912, 14286, 14388, 14540, 15138, 15928, 16581, 17662, 18273, 18262, 19780, 21174, 21875, 23139, 25784, 27506, 29112, 29472, 13873, 14324, 30974, 17133, 18701, 19350, 20973, 24148, 24695, 25202, 27110, 30943, 26453, 28593, 15419, 12088, 12257, 12213, 13575, 14880, 15325, 15337, 16323, 16718, 17199, 17840, 17995, 18670, 18843, 19832, 19953, 21811, 21945, 22303, 22878, 23014, 23859, 25059, 25263, 26026, 27050, 27194, 28331, 28571, 28722, 29149, 30471, 11962, 11969, 12803, 14453, 14572, 15371, 21786, 15421, 24910, 27146, 28613, 30307, 30573, 23333, 27343, 30728, 29026, 14067, 13224, 28695, 13369, 14210, 15909, 17320, 19508, 20618, 22369, 23691, 24544, 26736, 28738, 29012, 29456, 29464, 30351, 21598, 31428, 15623, 15721, 17776, 18338, 28072, 30427, 17262, 18249, 18713, 25541, 30743, 30400, 26878, 20356, 17530, 15352, 11798, 20524, 21853, 17967, 12740, 12854, 13026, 14803, 16257, 16423, 16912, 17727, 17780, 17951, 18036, 18674, 18454, 19299, 19973, 21106, 21791, 22235, 23742, 24662, 14576, 26877, 27007, 27296, 27283, 27339, 28701, 29074, 30546, 30553, 17801, 23054, 24838, 30395, 15917, 16604, 16922, 17829, 17940, 18320, 22515, 23117, 23629, 24126, 24842, 27820, 28004, 28129, 28255, 22697, 12807, 17113, 17317, 17474, 17048, 27181, 23171, 23488, 27308, 30442, 23926, 25100, 26441, 11993, 12616, 13123, 13152, 15267, 15362, 15382, 15837, 16934, 16967, 17584, 18451, 18484, 19657, 19781, 19735, 18387, 20316, 20814, 20861, 17867, 23167, 23469, 24026, 24138, 24488, 24954, 25115, 25145, 26022, 27246, 27854, 28149, 28792, 28791, 29357, 29329, 30083, 31662, 12877, 13700, 20280, 20790, 12648, 22917, 24149, 25011, 23758, 13900, 14417, 15528, 17322, 18174, 18173, 18778, 21209, 21903, 21902, 22798, 22870, 23007, 23703, 23840, 23876, 26119, 27188, 30267, 28769, 32544, 12519, 12917, 13260, 13282, 12297, 13738, 14574, 14671, 21053, 15243, 15460, 13085, 16611, 16627, 17244, 17283, 17215, 17339, 17613, 17897, 18169, 15843, 18893, 18941, 20245, 20965, 11913, 21993, 22264, 23187, 23775, 24015, 23964, 24673, 25417, 25432, 25708, 25788, 26107, 26821, 28016, 28673, 28781, 29591, 30492, 31250, 12495, 14487, 16782, 25043, 25909, 27912, 28704, 12227, 12404, 12871, 13171, 16495, 17225, 18271, 20012, 28083, 28703, 12247, 15454, 27850, 17871, 23962, 13138, 26774, 12662, 17347, 15192, 15211, 15370, 17421, 18257, 28764, 11990, 14618, 14634, 19568, 27217, 13630, 14357, 14757, 16624, 16979, 18369, 25141, 18773, 30272, 31172, 31272, 12115, 14342, 15358, 24592, 15537, 15919, 16261, 16416, 16715, 16948, 18175, 19696, 20190, 24782, 24959, 25300, 26763, 27832, 28672, 28718, 30346, 32475, 31707, 12003, 13296, 14631, 23340, 29069, 30796, 32249, 20189, 20519, 13139, 13636, 15237, 16984, 17054, 17107, 19618, 20463, 21538, 27159, 29752, 20417, 27390, 25400, 12775, 26360, 13290, 13289, 12102, 28756, 28592, 14698, 24881, 15869, 23274, 28607, 18650, 27703, 21240, 31816, 19005, 27312, 11833, 13144, 13830, 14182, 17093, 17314, 17894, 19278, 19937, 20059, 20653, 22509, 23279, 23466, 23995, 24637, 24774, 26315, 27285, 29531, 14051, 14535, 16190, 17837, 18070, 19072, 19381, 21815, 27335, 12324, 22501, 14128, 16155, 16485, 18042, 19552, 22004, 23066, 24430, 25076, 26392, 28741, 31155, 23497, 21852, 23289, 23377, 25796, 28688, 23017, 23186, 25398, 15073, 22336, 11821, 12018, 15257, 16352, 17085, 17980, 18417, 19688, 26219, 26743, 27195, 29006, 29427, 31184, 18967, 20518, 21290, 25319, 25687, 27823, 11777, 12614, 12747, 13707, 15349, 15894, 15923, 16001, 16148, 16181, 16235, 16308, 16882, 17169, 18082, 18205, 20334, 21074, 21818, 22330, 24692, 24889, 24952, 26486, 27327, 27356, 28037, 28147, 29338, 30071, 30722, 31973, 12997, 17239, 22260, 18197, 19592, 21453, 27843, 29614, 30323, 19749, 14492, 18702, 18892, 28669, 29594, 21979, 28698, 14426, 18434, 17332, 18939, 12099, 20268, 18392, 28603, 25894, 23988, 29524, 18751, 20336, 14186, 14583, 15148, 23852, 21034, 13322, 29155, 32180, 11949, 12110, 12380, 12405, 12867, 27806, 13384, 14372, 15258, 15901, 16021, 16045, 16119, 16159, 16524, 17077, 17210, 17360, 18607, 19520, 22663, 22926, 23051, 24032, 25159, 27138, 27366, 28228, 28691, 28856, 28973, 29144, 32526, 19685, 17496, 17634, 17781, 20212, 22148, 23323, 28777, 29649, 20154, 13554, 16313, 17572, 28493, 28653, 29252, 12664, 14443, 14633, 15445, 16023, 19963, 24207, 21788, 27836, 28386, 30811, 20665, 12061, 19391, 20401, 21808, 30459, 12622, 13328, 14389, 14423, 14764, 15456, 16274, 17815, 18268, 20001, 22139, 25567, 27885, 28692, 28925, 29517, 22565, 22586, 12970, 16038, 14111, 14708, 16402, 12306, 12634, 12716, 12749, 12800, 13584, 14420, 14424, 14679, 15253, 15606, 15755, 16572, 17045, 17453, 18289, 18499, 18620, 18655, 22231, 19928, 20079, 19867, 20591, 20936, 16211, 21976, 22903, 23369, 23380, 23378, 23766, 23921, 12848, 25699, 25961, 26084, 27150, 27396, 27718, 28175, 28675, 28687, 29721, 30326, 30765, 31280, 30168, 12493, 13013, 13324, 14338, 15374, 16807, 17566, 19742, 22451, 23269, 24820, 25604, 28755, 29317, 15584, 32007, 13119, 16279, 16307, 19868, 21113, 22371, 22975, 23524, 19410, 21228, 27309, 18435, 19041, 12792, 23169, 18740, 15434, 31990, 25323, 15301, 29001, 20510, 13944, 15471, 16583, 17766, 19596, 27738, 28737, 30739, 13393, 18119, 29197, 14664, 28835, 12677, 11853, 12778, 26009, 27406, 20568, 17274, 29515, 18786, 31156, 24068, 21879, 13143, 18784, 28383, 30435, 19549, 11916, 15420, 16144, 28649, 13058, 27857, 24713, 26233, 16127, 17893, 11891, 12645, 14722, 15423, 30702, 12027, 14730, 16333, 27277, 20449, 22960, 22882, 15335, 25713, 21291, 20913, 15988, 16373, 17275, 17562, 20931, 23704, 11843, 16124, 11851, 14300, 13986, 16553, 20419, 23821, 24829, 24883, 25023, 28594, 27031, 26276, 15860, 17034, 17581, 27015, 18295, 19682, 19774, 21558, 22580, 14918, 24437, 25261, 31148, 12275, 16067, 17117, 17298, 17751, 18287, 22211, 21068, 24780, 24762, 28457, 29005, 12301, 14329, 14994, 18565, 18803, 20836, 21245, 27831, 14578, 27872, 30314, 28697, 26495, 23012, 22503, 25641, 12079, 12901, 13146, 17101, 18383, 19658, 22141, 23444, 23701, 25142, 25988, 28651, 18141, 20256, 20998, 24091, 25515, 31169, 32422, 12797, 23473, 22642, 23480, 24711, 23368, 19176, 15969, 24716, 21841, 21856, 12651, 29282, 20108, 22138, 29079, 31466, 12048, 24432, 17052, 23375, 30117, 31977, 13946, 14425, 26340, 30396, 12084, 12836, 13130, 13261, 13275, 15878, 17452, 17809, 18303, 19518, 19534, 21064, 21167, 21485, 21844, 24129, 25132, 26089, 27817, 23492, 29126, 20841, 30738, 30959, 17213, 18025, 21866, 22244, 22736, 25923, 26350, 13098, 13137, 13350, 14723, 16007, 16252, 16562, 16969, 17017, 17067, 17808, 19412, 19660, 21938, 22190, 22673, 23000, 24011, 24439, 24741, 26795, 27321, 27835, 28799, 30558, 30939, 18955, 23608, 12441, 15422, 16302, 18311, 19416, 21557, 22281, 24462};
        System.arraycopy(nArray, 0, JISX0213_TO_UCS__MAIN, n, nArray.length);
        return nArray.length;
    }

    /*
     * Opcode count of 30094 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static final int loadUcsMain2(int n) {
        int[] nArray = new int[]{32571, 18378, 23063, 13113, 21899, 31469, 16230, 24989, 25585, 24728, 16188, 16325, 21858, 23366, 28732, 18535, 14827, 15003, 23824, 22142, 27436, 12277, 16234, 18969, 19511, 20226, 21730, 22888, 26728, 27221, 27769, 16095, 17359, 21957, 22994, 25303, 29480, 29426, 25756, 26349, 31789, 13505, 16236, 17804, 19804, 20501, 27815, 27859, 30779, 17743, 21750, 11789, 11992, 14304, 14635, 14950, 15308, 12712, 15875, 16028, 16406, 17014, 17783, 17831, 18030, 19822, 21046, 23334, 24912, 24986, 25241, 27484, 27808, 27878, 28020, 30236, 30276, 12206, 17579, 19302, 25118, 25697, 25962, 28904, 15361, 18771, 30888, 25722, 25943, 12047, 12911, 16297, 15941, 18189, 22927, 24953, 26887, 27014, 19957, 16151, 16981, 19640, 11983, 21097, 31634, 12806, 13371, 13940, 14515, 16804, 17006, 20762, 14702, 23689, 23774, 23835, 30448, 17799, 24670, 11801, 12149, 12661, 14400, 15971, 15987, 16138, 18372, 11814, 25917, 30089, 30299, 23667, 30721, 12539, 14529, 22102, 22695, 12837, 22437, 25873, 23430, 12367, 14601, 21063, 23495, 24040, 28602, 28628, 28749, 12223, 13001, 14889, 16129, 30637, 12253, 25111, 29418, 14083, 17237, 19305, 21803, 26844, 28436, 23106, 13023, 14483, 16725, 16906, 18094, 19405, 23615, 25577, 12323, 12280, 13061, 13382, 14385, 14665, 15261, 15600, 15599, 15657, 16022, 17073, 17255, 17726, 17849, 18187, 19669, 19681, 20729, 22578, 24107, 24798, 25267, 25612, 25836, 26370, 26898, 27178, 27722, 28838, 29394, 30973, 31987, 32108, 11855, 11937, 12429, 12886, 14154, 14760, 15933, 16344, 16345, 16959, 18100, 18203, 18384, 18642, 12690, 23841, 24746, 25000, 27392, 27788, 27839, 29310, 30258, 13344, 30764, 13079, 12501, 13148, 14504, 17586, 18228, 21095, 22374, 23110, 29158, 12995, 19617, 19334, 14336, 15948, 14676, 18220, 24571, 12769, 22214, 17513, 22760, 31572, 32443, 14283, 14777, 17959, 18330, 19406, 13545, 18905, 15957, 24988, 18325, 31658, 18430, 31826, 18525, 11942, 12259, 13256, 17081, 18219, 19627, 28612, 12205, 24173, 32447, 11783, 16738, 20096, 20267, 25875, 13427, 18218, 31557, 15859, 23445, 15532, 15302, 26396, 20042, 25809, 23060, 24840, 14745, 23693, 19473, 22304, 13017, 14626, 20769, 21087, 22491, 30503, 32097, 18699, 14975, 14872, 12709, 13325, 13437, 17934, 22239, 28663, 29336, 31988, 14826, 21085, 20165, 12621, 18633, 23999, 24044, 30562, 32442, 17528, 18977, 25346, 14724, 15199, 19419, 21275, 22258, 23986, 24599, 25753, 12594, 18216, 32473, 22254, 18274, 13055, 30981, 15396, 16955, 23678, 27824, 13647, 16566, 23819, 30080, 13057, 11871, 12726, 14620, 21050, 24630, 29134, 16165, 22498, 13188, 16249, 23812, 26028, 27187, 28301, 30550, 18419, 26030, 29779, 16649, 16648, 19641, 22098, 27373, 28472, 13615, 12113, 12586, 12999, 13259, 15269, 15997, 16544, 16770, 17366, 18185, 18394, 20071, 19852, 21302, 21303, 21809, 22864, 26837, 27288, 28746, 28817, 28917, 30404, 26509, 14613, 11912, 12121, 11790, 27273, 28479, 30736, 12461, 15996, 14742, 15289, 16056, 17370, 17402, 17601, 18140, 18762, 18904, 19723, 20150, 20884, 21800, 23215, 24458, 24576, 25673, 25801, 27009, 27425, 28170, 28773, 30333, 30986, 16766, 17041, 19250, 19587, 19828, 24524, 24572, 19904, 24453, 26554, 26872, 18277, 25521, 30780, 30455, 19739, 23905, 25661, 29034, 11889, 13173, 15696, 19204, 20459, 26061, 26157, 27047, 12841, 13327, 15461, 18254, 18600, 21510, 21635, 21986, 26831, 26849, 29132, 30434, 30328, 16267, 21383, 23243, 25678, 17312, 21861, 12937, 19777, 20124, 21513, 21849, 22635, 23698, 30342, 23260, 32653, 12214, 16750, 17861, 26204, 11910, 11950, 12506, 11809, 12748, 15342, 17817, 18561, 19900, 21279, 22082, 22445, 23068, 23783, 25199, 27346, 28796, 29135, 30325, 30744, 12955, 24017, 12331, 13208, 18327, 19915, 20944, 21555, 25064, 28458, 30371, 31831, 32415, 21600, 14401, 19865, 23855, 30814, 12004, 12086, 12171, 12727, 12977, 15802, 16412, 21426, 22844, 25299, 29236, 30391, 30454, 30474, 32407, 32610, 18086, 19316, 12823, 12963, 20680, 26818, 16073, 16459, 16784, 20259, 20809, 23614, 24052, 24687, 25838, 28707, 29484, 13378, 31599, 19155, 20617, 27842, 28143, 30514, 12980, 14913, 16074, 16132, 18199, 18812, 18836, 19818, 20239, 21090, 21244, 23533, 24577, 24702, 26443, 28878, 12653, 32403, 22916, 24715, 29490, 27350, 12333, 13452, 27249, 19306, 27844, 24839, 16593, 18336, 32242, 11929, 11928, 31760, 27243, 26049, 25960, 18688, 20094, 22679, 24917, 36511, 15169, 15190, 15229, 15251, 15320, 15340, 15378, 15390, 15395, 15403, 6029, 15458, 33083, 33084, 38580, 15482, 15503, 15519, 15523, 15530, 15546, 15563, 15568, 15570, 15604, 39988, 6114, 15629, 15655, 33041, 15686, 15687, 15699, 15690, 15725, 15745, 15776, 15780, 15783, 15800, 15819, 13342, 16140, 11792, 11797, 11818, 11825, 11830, 11836, 11839, 11842, 11862, 11864, 11906, 11909, 27755, 11914, 25106, 16141, 11918, 11934, 11935, 11936, 11938, 11952, 11955, 11958, 11982, 11981, 11972, 11974, 11970, 11991, 11998, 12013, 11999, 12023, 12041, 12122, 12080, 12123, 12125, 12119, 12103, 12150, 12168, 12175, 12184, 12155, 12137, 12144, 12177, 12143, 12166, 12182, 12568, 12244, 12255, 12238, 12248, 12251, 12241, 12250, 12240, 12260, 12261, 12314, 12328, 12308, 12330, 12325, 12293, 12060, 12278, 12321, 12329, 12332, 12286, 12271, 12305, 12294, 12355, 12359, 18179, 12373, 12368, 12360, 12378, 12374, 12396, 12408, 12416, 12442, 12421, 12468, 12466, 12489, 12490, 12467, 12482, 12502, 12510, 12517, 12525, 12515, 12526, 12537, 12533, 12553, 12545, 12546, 12566, 12565, 12564, 12570, 12577, 12602, 12599, 12604, 12603, 12607, 12608, 12626, 12620, 12628, 12642, 23288, 12649, 12650, 12654, 12672, 12674, 14040, 12684, 12681, 12687, 12689, 12691, 12693, 12694, 12708, 12710, 12706, 12713, 12714, 12715, 12723, 12721, 12722, 12720, 12725, 12733, 12741, 12745, 12763, 12768, 26197, 12777, 12781, 12784, 12789, 12798, 12804, 12811, 12820, 12814, 12839, 12842, 12846, 12851, 12857, 12879, 12868, 12875, 12876, 12894, 12884, 12906, 12916, 12905, 12915, 12927, 12925, 12941, 12948, 12946, 12913, 12936, 12945, 28584, 28583, 12972, 12973, 12988, 12981, 12993, 13005, 13015, 13022, 13027, 13030, 30957, 13024, 13043, 13045, 13048, 13049, 13062, 13064, 21816, 13069, 13072, 13071, 13077, 13082, 13091, 13103, 13105, 13107, 13112, 13120, 13126, 13125, 11799, 13129, 13133, 12758, 13150, 13161, 13166, 14616, 13179, 13175, 13186, 13206, 13216, 13222, 13221, 13230, 13232, 13238, 13251, 23570, 30425, 13279, 18172, 20974, 13294, 13288, 13293, 13306, 13313, 13373, 13376, 13356, 13357, 13372, 13358, 13366, 13353, 13341, 13390, 13455, 13429, 13454, 13407, 13425, 13431, 13424, 13458, 13435, 13440, 13430, 13444, 13456, 13446, 13511, 13474, 13496, 13477, 13484, 13508, 13512, 13480, 13483, 13506, 13476, 13502, 13500, 13528, 13541, 13542, 13583, 13588, 13565, 13550, 13549, 13562, 13538, 13625, 13632, 13667, 13644, 13614, 13660, 13637, 13654, 13655, 13624, 13619, 13661, 13721, 13696, 13487, 13706, 13727, 13691, 13694, 13720, 13726, 13742, 13692, 13699, 13737, 13703, 13736, 13786, 13765, 13791, 13764, 13788, 13796, 13780, 13844, 13815, 13846, 13822, 13821, 13851, 13817, 13902, 13904, 20959, 13876, 13878, 13874, 13880, 13931, 13924, 13871, 13932, 13930, 13958, 13952, 13962, 13984, 13972, 13967, 13989, 13998, 14006, 14004, 14018, 14012, 14017, 14019, 14016, 14024, 14030, 14033, 14035, 14039, 14062, 14073, 14080, 14079, 14084, 14089, 14088, 14091, 14093, 14099, 14104, 14102, 13767, 14108, 14118, 14135, 14136, 14158, 14139, 14144, 14159, 14185, 14272, 14216, 14177, 14207, 14217, 14227, 14240, 14259, 14244, 14250, 14256, 14275, 14278, 14292, 14290, 14291, 14346, 14294, 14307, 14347, 14361, 14365, 14450, 14369, 14434, 14411, 14448, 19392, 14418, 14397, 14457, 14469, 14521, 14495, 14507, 14522, 14558, 14523, 14520, 14510, 14533, 14547, 14545, 14551, 14553, 14552, 14565, 14556, 14564, 14559, 14575, 14586, 14585, 14587, 14588, 14589, 14594, 14602, 14608, 14619, 18598, 14629, 14636, 14637, 14642, 14648, 14654, 23250, 14677, 14672, 14670, 14682, 14680, 14690, 14688, 14695, 14700, 14697, 14712, 14721, 14749, 12126, 12203, 14755, 14770, 14790, 14824, 14812, 14733, 14809, 14810, 14885, 14879, 14865, 14876, 14857, 14874, 14912, 14956, 14921, 14901, 14902, 14946, 14954, 15002, 15036, 15038, 15051, 15042, 15037, 15075, 15063, 15078, 15081, 15062, 15098, 15099, 15116, 15115, 15126, 15154, 15056, 15146, 15158, 15166, 15171, 15173, 15168, 15185, 15189, 15194, 15195, 15205, 15209, 15216, 15219, 15221, 15224, 17800, 15226, 15232, 15235, 15270, 15288, 15299, 15303, 15305, 15316, 15312, 15332, 15334, 15330, 15326, 15333, 15339, 15344, 15350, 15347, 15365, 15367, 15368, 15373, 15379, 15392, 15394, 15400, 15416, 15417, 15425, 15430, 15438, 15443, 15440, 15439, 15217, 15468, 15470, 11874, 15478, 15481, 15500, 15505, 15508, 14747, 15531, 15547, 15542, 15548, 15543, 15557, 15550, 15559, 15577, 15593, 15613, 15610, 15597, 15756, 15594, 15627, 15637, 15639, 15708, 15647, 15643, 15633, 15636, 15650, 15642, 15641, 15640, 15692, 15698, 15694, 15691, 15724, 15731, 15734, 15751, 15748, 15746, 15778, 15773, 15788, 15790, 15805, 15760, 15799, 15804, 15817, 15821, 15827, 15826, 15830, 15835, 15851, 15858, 15861, 15883, 15898, 15897, 15889, 15899, 15926, 15927, 15940, 15939, 15936, 15950, 15959, 15956, 15967, 15970, 15972, 15943, 15989, 15990, 15994, 32444, 15999, 16032, 16065, 16066, 16072, 16080, 16079, 16086, 16099, 16093, 16090, 16091, 16098, 16097, 16104, 16105, 16108, 16113, 16115, 16112, 16116, 16120, 16126, 16131, 16137, 16221, 16220, 16139, 16145, 16150, 16169, 16173, 16184, 16193, 16200, 16204, 16206, 16175, 16209, 16214, 16215, 16217, 16225, 16237, 16243, 16247, 16259, 16258, 16255, 16266, 16264, 16273, 16263, 16286, 16281, 16280, 16288, 16296, 16301, 16316, 16342, 16379, 16356, 16376, 16369, 16349, 16563, 16383, 16417, 16480, 16409, 16400, 16425, 16398, 16433, 16411, 16405, 16427, 16422, 16399, 16442, 16474, 16449, 16490, 16503, 16479, 16458, 16454, 16461, 16483, 16451, 16484, 16450, 16492, 16491, 16473, 16513, 16525, 16615, 16515, 16538, 16516, 16539, 16534, 16535, 16530, 16551, 16523, 16609, 16568, 16608, 16595, 16564, 16368, 16573, 16582, 16565, 16600, 16717, 16661, 16646, 16630, 16631, 16640, 16628, 16634, 16643, 16673, 16635, 16625, 16653, 16654, 16711, 16702, 16680, 16679, 16714, 16703, 16700, 16684, 16692, 16701, 16706, 16708, 16755, 16759, 16728, 16729, 16730, 16747, 16756, 16751, 16741, 16753, 16735, 16733, 16723, 16757, 16793, 16790, 16775, 16812, 16788, 16794, 16778, 16785, 16811, 16814, 16844, 16842, 16841, 16887, 16840, 16835, 16838, 16826, 16843, 24441, 16845, 16870, 16867, 16886, 16890, 16884, 16895, 16893, 16892, 16894, 16896, 16904, 16905, 16909, 16908, 16916, 16923, 16926, 16929, 16938, 16942, 16944, 16946, 16947, 16961, 16974, 16990, 16995, 16987, 16992, 17000, 17020, 17026, 17033, 17022, 17042, 17043, 17046, 17108, 17027, 17044, 17111, 17105, 17083, 17103, 17151, 17094, 17620, 17096, 17116, 17100, 17098, 17090, 17095, 17051, 17097, 17164, 17134, 17137, 17191, 17154, 17160, 17135, 17141, 17232, 17214, 17229, 17436, 17231, 17302, 17294, 17280, 17323, 17270, 17315, 17295, 17289, 17311, 17333, 17259, 17257, 17342, 17385, 17344, 17350, 17379, 17353, 17362, 17398, 17348, 17430, 17460, 17414, 17427, 17446, 17462, 17693, 17431, 17448, 17423, 17511, 17519, 17526, 17486, 17706, 17557, 17555, 17573, 17577, 17544, 17596, 17626, 17618, 17605, 17607, 17595, 17624, 17602, 17649, 17639, 25097, 17632, 17633, 17068, 17635, 17647, 17708, 17654, 17652, 17650, 17658, 17664, 17661, 17688, 17692, 17669, 17700, 17699, 17707, 17716, 17717, 17719, 17718, 17720, 21835, 17736, 17750, 17749, 17741, 17752, 17758, 17757, 17778, 17784, 17794, 17795, 27530, 17819, 17823, 17835, 17847, 17859, 17862, 17857, 17860, 17868, 17874, 17883, 17881, 17888, 17889, 17905, 18290, 17930, 17923, 17915, 18291, 17973, 17974, 17972, 17948, 17999, 17988, 17993, 17985, 18014, 18013, 18020, 18023, 18024, 18015, 18018, 18032, 18051, 18056, 18062, 18057, 18052, 18072, 18077, 18113, 18105, 18121, 18110, 18108, 18116, 18104, 18134, 18138, 18144, 17983, 18150, 18153, 18160, 18165, 18167, 18191, 18198, 18206, 18214, 18215, 30520, 18222, 18239, 18230, 18241, 18232, 18231, 18246, 18270, 18272, 18265, 18275, 18276, 18313, 18288, 18345, 18300, 18282, 18316, 18315, 18342, 18337, 18309, 18359, 18415, 18356, 18412, 18355, 18409, 18360, 18404, 18398, 18397, 18402, 18414, 18361, 18382, 18374, 18407, 19100, 18462, 18502, 18473, 18496, 18509, 18482, 18510, 18611, 18475, 18521, 18531, 18551, 18559, 18591, 18575, 18605, 18580, 18589, 18587, 18563, 19118, 18617, 18548, 18613, 18592, 18618, 18703, 18573, 18558, 18689, 18634, 18696, 18648, 18722, 18726, 18657, 18700, 18637, 18644, 18663, 18645, 18742, 18706, 18692, 18647, 18659, 18725, 18681, 18656, 18671, 18728, 18730, 18714, 18723, 18721, 18630, 18809, 18807, 18780, 18808, 18795, 18772, 18814, 18798, 18745, 18804, 18749, 18777, 18736, 18785, 18782, 18781, 18817, 18794, 18866, 18862, 18896, 18879, 18881, 18899, 18878, 18894, 15336, 18890, 18909, 18875, 18883, 18855, 18990, 18833, 18848, 18844, 18837, 18868, 18910, 18920, 18946, 18971, 18943, 19210, 18937, 18930, 18919, 18949, 18865, 18974, 18925, 18964, 18923, 18954, 18962, 19137, 18979, 18963, 19012, 18956, 19058, 18998, 19064, 19015, 19042, 19033, 19046, 19016, 19000, 18978, 19088, 19085, 19104, 19076, 19106, 19107, 19095, 26135, 19131, 19139, 19138, 19128, 19123, 19116, 19166, 19153, 19167, 19114, 19162, 19178, 19195, 19205, 26134, 19194, 19218, 19222, 31537, 19231, 19256, 19255, 22236, 19257, 30958, 19271, 19267, 19273, 19280, 19289, 19284, 19291, 19295, 19297, 19320, 19321, 19327, 19328, 19332, 19331, 19341, 19352, 19349, 19358, 19364, 19370, 19371, 19375, 19378, 19377, 19379, 19383, 19388, 19398, 19403, 19411, 19423, 19436, 19435, 19443, 19439, 32446, 19464, 19475, 19476, 19483, 19492, 19491, 19550, 19541, 19554, 19562, 19586, 19597, 19610, 19585, 19611, 19582, 19560, 19571, 19602, 19600, 19652, 19697, 19667, 19645, 19671, 19653, 19677, 19630, 19633, 19646, 19642, 19675, 19695, 19673, 19690, 19743, 26701, 19766, 19755, 19773, 19768, 19737, 19765, 19763, 19730, 19724, 19811, 19859, 19812, 19802, 19833, 19801, 19854, 19861, 20452, 19845, 19961, 19989, 19978, 19893, 19911, 19942, 19896, 19910, 19948, 19934, 19916, 19944, 19922, 19909, 19962, 19929, 19940, 19925, 19946, 19950, 20013, 20078, 20014, 19993, 20082, 20063, 20030, 20003, 20075, 20011, 20086, 20045, 19999, 20035, 20026, 20046, 20004, 20223, 19997, 20024, 20098, 20138, 20120, 20169, 20151, 20179, 20157, 20143, 20164, 20146, 20180, 20181, 20111, 20133, 20162, 20127, 20289, 20241, 20556, 20204, 20216, 20222, 20287, 20210, 20273, 20207, 20274, 20172, 20286, 20243, 20215, 20358, 20346, 20344, 20353, 20352, 20335, 20315, 20467, 20333, 20354, 20348, 20312, 20366, 20369, 20418, 20326, 20403, 20387, 20385, 20388, 20409, 20422, 20394, 20447, 20437, 20460, 20436, 20440, 20465, 20462, 20443, 20489, 20491, 20474, 20497, 20481, 20495, 20478, 20507, 20506, 20340, 20509, 20504, 20511, 20528, 20542, 20530, 20561, 20579, 20633, 20626, 20655, 20721, 20652, 20664, 20659, 20654, 20703, 20683, 20701, 20697, 20745, 20733, 20764, 20761, 20837, 20821, 20872, 20838, 20834, 20812, 20822, 20844, 20879, 20987, 20868, 20885, 20904, 20908, 20951, 20921, 20926, 20946, 20937, 20948, 20942, 20960, 20972, 20967, 20981, 20988, 20985, 20991, 21005, 21008, 21019, 21032, 21037, 21036, 21040, 21042, 21051, 21052, 21055, 21056, 21062, 21067, 21080, 21108, 21118, 21122, 21121, 21127, 21138, 21142, 21154, 21159, 21177, 21170, 21187, 21190, 21188, 21198, 21202, 21218, 21216, 21217, 21241, 21239, 12303, 21271, 21258, 21276, 21270, 21277, 21300, 21295, 21289, 21285, 21310, 21326, 21327, 32472, 21335, 21354, 21352, 21360, 21368, 21365, 21371, 21370, 21448, 21427, 21454, 21435, 21440, 21477, 21486, 21470, 21666, 21509, 21615, 21541, 21496, 21554, 21562, 21589, 21567, 21599, 21593, 21569, 21596, 21609, 21616, 21603, 21610, 21622, 21630, 21643, 21662, 21671, 21706, 21711, 21716, 21489, 21728, 21731, 21735, 21737, 21742, 21746, 21744, 21745, 21752, 21751, 21764, 21763, 21765, 21772, 21774, 21773, 21781, 21779, 21790, 21798, 21804, 21820, 21828, 21837, 21834, 21833, 21851, 21830, 21850, 21865, 21860, 21863, 21867, 21869, 21880, 21878, 21894, 21895, 21876, 21898, 21897, 21890, 21908, 21914, 21917, 21925, 21923, 21954, 21939, 21955, 21941, 21949, 21944, 21948, 21937, 21965, 21962, 21970, 21977, 21987, 21982, 22014, 22015, 22012, 22017, 22000, 22010, 22002, 22003, 22027, 22029, 22025, 22047, 22055, 22048, 22049, 22050, 22052, 22068, 22064, 22075, 22087, 22088, 22086, 22108, 22104, 22113, 22114, 22120, 22121, 22122, 22119, 22124, 22128, 22130, 22134, 22136, 22140, 22144, 22147, 22152, 22155, 22158, 22166, 22163, 22169, 22170, 22192, 22196, 22200, 22201, 22202, 22210, 22221, 22230, 22226, 22238, 22241, 22245, 22247, 22250, 26159, 22267, 22280, 22279, 22276, 22313, 22308, 22302, 22309, 22310, 22299, 22327, 22328, 22343, 22362, 22376, 22379, 22363, 22373, 22399, 22398, 22393, 22414, 22411, 22417, 22432, 22430, 22448, 22454, 22457, 22463, 22460, 22461, 22459, 22471, 22477, 22487, 22490, 22492, 22499, 22510, 22524, 22540, 22546, 22822, 22560, 22826, 22597, 22670, 22644, 22662, 22652, 22682, 22668, 22691, 22709, 22698, 22703, 22737, 22726, 22731, 22740, 22718, 22716, 22725, 22730, 22764, 22759, 22746, 22781, 22772, 22791, 22802, 22801, 22809, 22828, 22827, 22848, 22880, 22871, 22879, 22874, 22869, 22867, 22906, 22911, 22922, 22941, 22951, 32587, 22954, 22958, 22963, 22969, 22970, 22985, 22997, 23015, 23020, 23009, 23011, 23048, 23053, 23064, 23065, 23072, 23071, 22912, 23089, 23099, 23102, 23095, 23107, 23127, 23113, 23137, 23138, 23145, 32669, 23152, 23161, 23165, 23176, 23191, 23189, 23192, 23190, 23209, 23240, 23216, 23222, 23237, 23236, 23231, 28803, 23239, 23242, 23245, 23247, 23253, 23251, 23257, 23258, 23261, 23265, 23266, 23270, 23277, 23280, 23298, 23311, 23306, 23302, 23347, 23320, 23321, 23326, 23349, 23336, 23350, 23376, 23418, 23300, 23373, 23307, 23372, 23365, 23413, 23397, 23412, 23399, 23408, 23409, 23404, 23406, 23453, 23448, 23455, 23437, 23452, 23450, 23435, 23442, 23439, 23389, 23449, 23499, 23489, 23500, 23503, 23476, 23494, 23517, 23529, 23569, 23572, 23526, 23525, 23648, 23552, 23559, 23571, 23539, 23543, 23575, 23565, 23542, 23587, 23591, 23594, 23583, 23607, 23595, 23613, 23628, 23619, 23636, 23631, 23616, 23632, 23640, 23647, 23652, 23638, 23653, 23660, 23669, 23683, 23696, 23716, 23725, 23714, 23723, 23713, 23720, 23731, 23730, 23729, 23726, 23737, 23741, 23744, 23749, 23746, 23768, 23762, 23772, 23778, 31547, 23791, 23794, 23796, 23798, 23802, 23814, 23810, 23836, 23829, 23818, 23877, 23883, 23854, 23858, 23871, 23861, 23878, 23923, 23894, 23886, 23922, 23912, 23918, 23887, 23907, 23955, 23945, 23899, 23951, 23933, 23963, 23994, 23982, 23971, 23989, 24007, 23997, 23979, 24125, 23970, 23983, 24028, 23992, 23967, 23984, 24024, 24029, 24036, 24030, 24059, 24050, 24033, 24069, 24074, 24099, 24097, 24082, 24113, 24095, 24073, 24075, 24098, 24134, 24166, 24123, 24117, 24121, 24131, 24119, 24114, 24122, 24167, 24157, 24150, 24158, 24153, 24154, 24185, 24170, 24169, 24188, 24187, 24195, 24021, 24189, 28590, 24191, 24200, 24201, 24204, 24210, 24208, 24211, 24212, 24214, 24206, 24219, 24220, 24376, 24378, 24389, 24396, 24397, 24398, 24400, 24401, 24405, 24404, 24408, 24415, 24416, 24424, 24425, 24423, 24440, 24450, 24454, 24451, 24456, 24455, 24460, 24468, 24478, 24477, 24474, 24483, 24495, 24498, 24505, 24494, 24502, 24504, 27505, 24517, 24518, 24522, 24533, 24532, 24545, 24550, 24553, 24563, 24569, 30940, 24582, 24580, 24587, 24594, 24600, 24601, 24604, 24609, 24616, 24639, 24635, 24650, 24646, 24658, 24664, 24666, 24671, 24674, 24680, 24691, 24690, 24688, 24694, 24697, 24701, 24703, 24708, 24710, 24709, 24731, 24723, 24730, 24749, 12688, 24748, 24795, 24805, 24793, 24797, 24772, 24794, 24790, 24841, 24815, 24817, 24859, 24873, 24867, 24879, 24907, 30347, 24902, 24894, 24915, 24913, 24828, 24945, 24942, 24933, 24934, 24948, 24963, 24968, 24970, 24960, 24962, 24992, 24981, 24996, 24995, 24927, 24979, 25001, 25008, 25013, 25022, 25016, 25021, 25024, 25026, 25018, 25033, 25037, 25041, 25049, 25048, 25032, 25050, 25055, 25056, 25063, 25082, 25083, 25086, 25089, 25090, 25093, 25095, 25098, 25101, 25104, 25110, 25129, 25131, 25144, 25139, 25152, 25177, 25176, 25181, 25178, 25183, 25188, 25186, 25192, 25194, 25195, 25134, 25201, 25207, 25208, 25214, 25229, 25234, 25259, 25247, 25275, 25260, 25313, 25315, 25311, 25298, 25332, 25331, 25338, 25491, 25347, 25339, 25337, 25310, 25350, 25308, 25353, 25305, 25397, 25396, 25366, 25394, 25393, 25408, 25401, 25424, 25413, 25391, 25387, 25367, 25368, 25477, 25498, 25514, 25503, 25506, 25494, 25379, 25486, 25479, 25482, 25468, 25525, 25459, 25461, 25504, 25481, 25512, 25588, 25619, 25579, 25550, 25597, 25603, 25560, 25611, 25537, 25591, 25607, 25568, 25586, 25613, 25634, 25632, 25533, 25656, 25862, 25595, 25709, 25642, 25660, 25946, 25732, 25719, 25707, 25773, 25710, 25730, 25705, 25670, 25644, 25711, 25721, 25653, 25802, 25698, 25785, 25791, 25759, 25817, 25805, 25787, 25818, 25808, 25793, 25798, 25814, 25761, 25889, 25855, 25844, 25879, 25880, 25900, 25887, 25877, 25876, 25852, 25920, 25955, 25944, 25928, 25921, 26114, 25931, 25941, 25984, 26020, 25992, 26001, 25994, 26024, 25965, 26004, 26011, 26090, 25991, 26012, 25975, 25982, 26000, 26057, 26042, 26063, 26041, 26064, 26069, 26077, 26085, 26076, 26105, 26122, 26131, 26123, 26110, 26106, 26118, 26146, 26138, 26160, 26175, 26189, 11861, 26196, 26207, 26215, 26225, 26259, 26275, 26281, 26282, 26251, 26252, 26294, 26287, 26308, 26310, 26288, 26313, 26659, 26283, 26324, 26334, 26345, 26348, 26335, 26331, 26351, 26386, 26374, 26376, 26368, 26371, 26363, 26385, 26377, 26381, 26361, 26378, 26420, 26431, 26423, 26427, 26405, 26409, 26394, 26464, 26463, 26488, 26444, 26446, 26484, 26455, 26472, 26478, 26457, 26451, 26467, 26474, 26629, 26530, 26527, 26498, 26543, 26571, 26557, 26560, 26576, 30422, 26539, 26564, 26547, 26567, 26566, 26555, 26607, 26610, 26592, 26639, 26637, 26622, 26614, 26615, 26638, 26578, 26641, 26646, 26645, 26658, 26657, 26673, 26678, 26681, 26663, 26683, 26692, 26690, 26706, 26713, 26718, 26722, 26731, 26753, 26750, 26782, 26741, 26749, 26805, 26738, 26754, 26775, 26770, 26798, 26777, 26786, 26765, 26788, 26800, 26815, 26801, 26819, 26820, 26836, 26840, 26841, 26845, 26873, 26882, 26876, 26868, 26856, 26866, 26884, 26892, 26890, 26899, 26947, 26910, 26917, 26922, 26923, 26945, 26948, 26939, 26934, 26936, 26956, 26909, 26976, 26974, 26982, 26980, 26989, 26986, 26991, 26996, 26999, 27006, 27011, 27016, 27018, 27027, 27032, 27041, 27049, 27046, 27052, 27055, 27058, 27066, 27069, 27071, 27072, 27098, 27100, 27101, 27111, 27124, 27128, 27139, 27158, 27152, 27148, 27163, 27165, 27173, 27190, 27201, 27227, 27218, 27206, 27208, 27260, 27245, 27244, 27234, 27269, 27266, 27268, 27304, 27297, 27281, 27301, 27302, 27290, 27299, 27332, 27341, 27330, 27354, 27371, 27379, 27367, 27364, 27377, 27412, 27360, 27362, 27383, 27358, 27355, 27404, 27399, 27418, 27361, 27414, 27408, 27415, 27424, 27443, 30635, 27430, 27435, 27454, 27432, 27457, 27468, 27471, 27470, 27465, 27478, 27483, 27482, 27499, 27487, 27500, 27503, 27508, 27517, 27520, 27532, 27534, 27538, 27539, 27542, 27545, 27546, 27706, 27713, 27711, 27720, 27724, 27726, 27728, 27733, 27746, 27756, 27768, 27770, 27778, 27785, 27781, 27786, 27789, 27790, 27796, 27772, 27800, 16925, 27821, 27818, 27837, 27826, 27827, 27822, 27830, 27848, 27841, 27876, 27875, 27866, 27901, 27898, 27899, 27908, 27909, 27914, 27911, 27919, 27917, 27920, 32590, 27923, 27853, 27924, 27926, 28007, 28013, 28017, 28019, 28033, 28057, 28098, 28094, 28090, 28111, 28122, 28118, 28108, 28123, 28107, 28138, 28139, 28127, 28131, 28156, 28168, 28169, 28159, 28189, 28190, 28176, 28191, 28226, 28213, 28208, 28212, 28234, 28231, 28233, 28236, 28240, 28232, 28249, 28260, 28256, 28202, 28259, 28245, 28278, 28274, 28284, 28289, 28295, 28293, 28292, 28299, 28298, 28307, 28305, 28308, 28313, 28330, 28321, 28332, 28336, 28358, 28337, 28350, 28357, 28360, 28363, 28379, 28387, 28412, 28411, 28395, 28414, 28426, 28421, 28437, 28434, 28441, 28435, 28444, 28447, 28443, 28428, 28454, 28467, 28475, 28473, 28485, 28482, 28478, 28492, 28489, 28486, 28494, 28503, 28508, 28514, 28515, 28516, 28572, 28575, 28579, 28589, 28591, 28599, 28634, 28645, 28642, 28650, 28655, 28807, 28660, 28677, 28665, 28666, 28689, 28693, 28705, 28685, 28702, 28694, 28683, 28711, 28726, 28725, 28729, 28664, 28751, 28752, 28753, 28754, 28686, 28745, 28734, 28758, 28760, 28766, 28776, 28783, 28790, 30376, 28786, 28802, 28797, 28801, 28800, 28810, 28809, 28815, 28840, 28847, 28849, 28853, 28898, 28900, 16968, 28891, 28930, 28946, 28953, 28978, 28976, 29002, 29014, 29016, 29027, 29029, 29033, 29043, 29042, 29067, 29065, 29058, 29090, 29099, 29103, 29098, 29109, 29108, 29114, 29120, 29121, 29129, 29131, 29136, 29142, 29151, 29153, 29147, 29180, 29173, 29174, 29214, 29183, 29204, 29228, 29205, 29201, 29278, 29271, 29253, 29257, 29284, 29256, 29333, 29247, 29259, 29264, 29340, 29334, 29331, 29339, 29274, 29391, 29369, 29367, 29417, 29455, 29434, 29508, 29486, 29465, 29474, 29466, 29475, 29498, 29493, 29499, 29532, 29536, 29564, 29550, 29526, 29616, 29612, 29613, 29588, 29625, 29654, 29655, 29672, 29669, 29656, 29635, 29661, 29648, 29640, 29668, 29722, 29716, 29715, 29699, 29703, 29712, 29750, 29739, 29749, 29729, 29754, 29761, 29778, 29764, 29787, 29792, 29794, 29790, 29802, 29225, 29808, 29813, 29815, 29821, 29786, 29820, 29822, 29825, 29823, 30082, 30087, 30090, 30100, 30102, 30104, 30105, 30112, 30120, 30119, 30125, 30140, 30139, 30137, 30142, 30154, 20470, 30147, 30157, 30156, 30165, 30164, 30166, 30172, 30177, 30181, 30178, 30241, 30248, 30254, 30255, 30274, 30284, 30287, 30283, 30327, 30300, 30302, 30301, 30303, 30310, 30322, 30316, 30349, 30360, 30357, 30359, 30378, 30375, 30385, 30386, 30384, 30388, 30390, 30392, 30393, 30414, 30411, 30409, 30413, 26957, 30428, 30477, 30421, 30457, 30468, 30470, 30472, 30483, 30478, 30481, 30479, 30486, 30489, 30500, 30506, 30512, 30521, 30525, 30526, 30532, 30534, 30536, 30530, 30537, 30556, 30560, 30564, 30566, 30568, 13010, 30571, 30577, 30585, 30597, 30588, 30593, 30586, 30598, 30603, 30607, 30608, 30620, 30632, 30630, 30627, 30643, 30644, 30659, 30662, 30664, 30667, 30684, 30701, 32591, 30706, 23263, 30710, 30709, 30735, 30732, 30776, 30756, 30753, 30775, 30781, 30790, 30799, 30795, 30827, 30831, 30832, 30833, 30836, 30835, 30890, 30895, 30897, 30902, 30916, 30915, 30918, 30953, 30955, 30979, 30985, 30994, 30996, 31000, 31009, 31005, 31006, 31012, 31008, 31020, 31022, 31037, 31038, 31042, 31049, 31045, 31056, 31051, 31057, 31058, 31052, 31061, 31127, 31128, 31141, 31149, 31150, 31164, 31199, 31195, 31197, 31192, 31185, 31213, 31214, 31217, 31218, 31227, 31224, 31233, 31247, 31237, 31202, 31257, 31275, 31287, 31301, 31298, 31296, 31299, 31294, 31317, 31309, 31323, 31319, 31327, 31330, 31333, 31332, 31337, 31339, 31338, 31405, 31408, 31420, 31424, 31439, 31441, 31443, 31444, 31454, 31455, 31458, 31459, 31462, 31471, 31467, 31470, 31476, 31473, 31479, 31483, 31494, 31512, 31514, 31519, 31522, 31523, 31525, 31527, 31528, 31529, 31530, 31534, 31535, 31538, 31556, 31555, 31567, 31565, 31566, 31569, 31576, 31604, 31635, 31619, 31633, 31638, 31639, 31647, 31648, 31656, 31668, 31680, 31690, 31673, 31686, 31695, 31697, 31698, 31715, 31714, 31716, 31700, 31713, 31802, 31730, 31729, 31728, 31765, 31764, 31753, 31763, 31756, 31750, 31752, 31762, 31754, 31748, 31790, 31771, 31781, 31780, 31777, 31792, 31815, 31794, 31814, 31806, 31834, 31840, 31847, 31862, 31864, 31975, 31980, 31984, 32009, 32008, 31979, 32003, 32006, 32042, 32038, 32175, 32035, 32031, 32068, 32021, 32018, 32065, 32063, 32062, 32070, 32072, 32093, 32094, 32100, 32081, 32080, 32089, 32114, 32137, 32135, 32171, 32111, 32122, 32154, 32164, 32169, 32178, 32196, 32193, 32187, 32184, 32186, 32198, 32207, 32194, 32217, 32211, 32248, 32230, 32237, 32239, 32253, 32282, 32283, 32286, 32373, 32377, 32381, 32385, 32392, 32395, 32396, 32402, 32405, 32401, 32413, 32421, 32425, 32440, 32426, 32429, 30561, 32460, 32462, 32463, 32464, 32468, 32476, 32478, 32477, 32480, 32485, 32488, 32495, 32500, 32502, 32503, 32505, 32507, 32508, 32509, 32519, 32520, 22199, 32533, 32545, 32556, 32574, 32586, 32594, 32596, 32611, 32607, 32608, 32609, 32614, 32615, 32620, 32618, 32631, 32626, 32630, 32661, 32668, 32672, 14383, 18887, 28761, 21604, 12764, 20889, 13907, 15842, 15892, 15896, 15960, 15966, 16062, 32808, 16075, 16121, 16128, 16130, 16135, 16157, 16163, 16180, 16182, 16189, 16192, 16197, 16212, 16216, 16228, 16231, 16253, 16265, 16284, 16295, 16303, 16309, 16311, 16329, 16350, 16353, 16361, 16397, 16404, 16408, 16435, 16437, 16455, 33085, 16541, 16542, 16587, 16596, 16597, 16605, 16632, 16668, 16683, 16688, 16695, 33086, 16781, 33087, 16828, 16825, 33088, 16930, 16958, 16963, 16982, 16986, 17007, 17029, 17092, 17110, 17148, 17162, 17176, 17209, 17219, 17253, 17276, 17381, 17389, 17397, 17424, 17428, 17442, 17529, 17489, 17504, 17517, 17614, 17598, 17599, 17604, 17610, 17616, 17655, 17659, 17698, 17705, 33089, 17767, 17821, 33090, 17920, 17929, 17941, 17950, 17978, 17954, 17956, 17963, 17968, 17969, 17971, 18171, 17992, 17996, 43204, 18009, 18010, 18017, 18021, 18035, 18039, 18040, 18061, 33091, 18080, 18098, 18107, 18118, 18120, 6946, 18139, 18152, 18170, 18195, 32809, 18227, 18278, 18247, 18248, 18299, 18305, 18323, 18328, 18331, 18363, 18425, 18368, 18391, 18428, 18433, 18514, 18461, 18476, 18481, 18523, 18546, 18549, 33092, 18595, 18597, 18610, 18632, 18640, 18664, 18669, 18672, 18673, 18684, 18698, 18761, 43972, 18741, 18754, 18775, 18787, 18788, 18792, 18816, 33044, 18853, 18861, 18895, 7094, 7107, 18914, 18921, 18922, 18933, 18934, 18959, 18965, 44351, 19003, 19006, 19013, 19024, 19030, 19035, 19051, 19059, 44387, 19081, 19092, 19101, 19102, 19109, 19172, 19175, 7183, 32797, 19227, 19230, 19244, 19253, 19270, 19286, 19296, 19301, 19303, 19319, 19330, 19369, 19373, 32880, 19407, 19414, 19415, 19455, 19461, 19472, 19507, 19545, 19548, 19626, 19572, 19574, 19589, 19590, 19608, 19612, 19707, 19654, 19668, 19680, 19691, 19694, 45310, 19716, 19726, 19758, 19761, 19769, 19775, 19800, 19813, 33093, 19842, 19847, 19849, 19860, 19882, 19884, 19903, 19908, 19926, 19930, 19931, 19933, 19964, 33094, 20020, 20036, 20060, 20062, 20139, 20145, 20161, 20167, 20174, 20240, 20250, 33095, 20266, 20271, 20275, 20305, 20313, 20318, 20321, 20322, 20350, 20360, 20364, 20365, 20372, 20384, 20391, 20406, 20412, 20423, 20426, 20473, 20464, 20469, 20485, 20486, 20520, 20554, 20573, 20574, 20558, 20580, 20597, 20613, 20644, 20651, 20663, 20692, 20696, 20708, 20751, 20779, 20766, 20768, 20782, 20784, 20806, 20807, 20817, 33096, 20818, 20828, 20832, 20840, 33045, 20869, 20871, 20882, 20929, 20922, 20932, 20990, 20992, 21013, 21077, 21078, 7743, 21133, 21147, 21182, 21184, 21243, 47089, 21287, 21288, 33046, 21328, 21350, 21372, 21397, 21407, 21408, 21410, 21414, 21419, 21449, 21455, 21462, 21465, 21475, 21481, 21511, 21514, 21530, 21531, 33098, 21542, 21544, 21546, 21547, 21548, 21550, 21551, 21552, 21572, 21574, 21575, 21579, 21591, 21602, 21611, 21613, 21638, 21639, 21641, 21656, 21660, 21663, 21667, 21648, 21670, 21672, 21673, 21685, 21695, 21704, 21705, 21722, 21759, 21761, 21783, 21807, 21871, 21881, 21906, 8050, 21966, 21988, 22016, 22018, 22024, 22037, 22038, 22041, 22046, 22061, 22069, 22083, 22091, 22116, 22117, 22125, 22127, 22129, 22145, 22171, 22173, 22174, 22182, 22186, 22198, 22213, 22220, 22222, 22228, 22246, 22257, 22268, 22282, 22297, 22324, 22326, 22342, 22349, 22350, 22364, 22367, 22370, 22394, 22400, 22420, 22442, 22496, 22573, 49550, 22595, 22606, 22607, 22609, 22632, 22638, 33099, 22704, 49678, 22701, 22756, 22770, 22784, 22775, 22812, 22830, 22833, 22836, 33100, 33101, 22853, 22854, 33102, 33103, 33104, 22876, 33105, 33049, 33050, 22905, 33106, 33107, 33051, 22936, 22961, 22968, 22984, 22986, 50033, 22996, 23006, 23019, 23021, 23043, 33108, 23097, 23133, 23149, 33109, 23173, 23200, 50372, 23219, 23227, 23246, 23275, 23293, 23314, 23341, 23355, 23367, 23374, 23392, 23405, 23407, 23410, 23454, 33110, 23511, 23513, 23553, 23601, 23582, 23584, 23603, 23606, 8804, 51105, 23641, 23661, 23673, 23695, 23700, 23712, 23740, 23765, 23769, 23773, 23815, 23816, 23827, 23837, 23843, 23857, 23873, 23880, 23891, 23900, 23930, 23939, 23947, 23968, 23974, 24002, 24012, 24022, 24035, 33111, 24104, 24072, 24081, 24085, 33113, 24135, 24146, 24161, 24202, 24205, 24391, 33114, 24465, 24471, 24511, 24526, 24539, 24543, 24556, 24558, 24570, 33115, 24596, 24614, 24629, 24631, 24636, 24778, 24791, 24800, 24819, 24856, 24906, 24928, 24935, 24936, 24941, 25019, 25034, 25039, 25047, 33116, 9299, 9307, 25184, 25204, 54015, 25230, 25249, 25251, 25252, 25257, 25262, 25271, 25278, 25279, 25286, 25301, 25341, 25342, 25344, 25345, 25442, 25378, 25389, 25402, 25411, 25415, 25425, 25429, 25469, 25478, 25490, 25496, 25511, 25513, 25535, 25536, 25543, 25551, 25553, 25569, 25578, 25601, 25606, 25610, 33119, 25672, 25695, 25712, 25715, 25733, 25758, 25775, 25780, 25786, 25792, 25794, 54336, 25906, 25886, 25891, 25903, 25945, 25956, 33055, 26029, 25978, 25996, 25999, 26018, 26032, 26059, 26062, 26093, 26130, 26111, 26116, 26117, 26128, 54900, 26136, 26153, 26168, 26199, 26203, 32822, 26210, 9629, 26220, 26229, 26264, 26296, 26362, 26364, 26365, 26379, 26481, 26503, 26504, 26540, 26541, 26549, 9706, 26582, 26604, 26630, 26634, 26640, 26644, 26655, 26776, 26794, 26826, 26830, 55428, 26869, 26908, 33120, 26904, 26905, 26906, 26919, 26928, 26930, 26937, 26944, 27028, 33121, 27092, 27109, 27126, 27154, 27157, 27170, 27191, 27207, 27214, 27229, 27233, 27253, 27257, 27303, 27344, 27359, 27380, 27382, 33058, 33122, 33123, 27462, 27476, 27481, 27497, 27549, 27721, 27752, 33124, 27873, 27892, 27896, 27902, 33125, 27922, 27931, 28079, 28110, 28113, 28119, 28192, 28195, 28221, 28272, 28283, 57719, 28352, 10308, 28410, 28446, 28461, 28470, 28500, 57933, 28582, 28597, 28644, 28648, 28654, 28680, 28717, 33127, 28808, 28821, 28823, 28825, 28827, 28834, 28851, 28862, 28868, 28869, 28871, 28887, 28893, 28894, 28911, 28916, 33062, 28948, 28949, 28950, 28962, 28963, 28967, 28975, 28977, 28980, 28989, 29000, 29019, 29059, 29086, 29100, 29105, 29116, 29143, 29179, 29156, 29157, 29165, 29169, 29191, 29200, 29240, 29241, 29242, 29244, 29248, 29251, 29263, 29304, 29320, 29378, 29387, 29388, 29395, 29408, 29439, 29444, 29471, 29473, 29477, 29512, 29513, 29514, 29540, 29541, 29546, 29552, 29595, 29603, 29626, 29638, 29662, 29663, 29700, 29693, 29747, 29770, 29795, 29803, 29809, 29810, 30094, 30111, 30118, 30121, 30124, 30134, 30141, 30155, 30160, 30163, 10672, 30170, 30174, 30296, 30340, 32988, 30365, 30372, 30373, 30418, 30430, 33128, 30441, 30447, 30515, 30523, 30541, 30542, 30543, 30554, 30574, 30579, 30613, 30638, 30650, 30657, 30665, 30686, 30683, 30708, 33129, 30730, 30750, 30763, 30768, 33130, 30802, 30803, 30806, 30807, 30809, 30810, 32976, 30821, 30828, 30906, 30920, 30951, 31064, 31134, 31234, 31235, 31268, 31277, 31278, 31288, 31306, 31310, 31314, 31414, 31425, 31427, 31438, 31446, 31481, 31490, 31496, 31520, 11287, 31533, 31582, 31609, 31590, 31602, 31605, 31620, 31626, 31631, 31646, 31655, 31681, 31694, 31717, 31736, 31741, 31744, 31779, 31809, 31823, 31824, 31827, 31843, 31845, 31863, 32029, 32030, 32067, 32071, 32082, 32099, 32112, 32124, 32138, 32150, 32192, 32172, 32188, 32215, 63120, 32231, 32263, 32277, 32380, 32414, 32420, 32428, 32431, 32436, 32437, 32451, 32465, 32528, 32569, 32599, 32656, 32660, 32663, 32674, 14840, 15451, 15991, 22054, 24171, 33929, 11778, 11791, 11794, 11817, 11819, 11822, 11840, 11847, 11848, 33954, 11857, 5126, 33956, 11866, 11881, 11933, 5164, 5166, 11961, 11963, 34082, 11964, 11971, 11976, 11984, 12011, 11994, 12017, 12021, 12032, 12054, 12132, 12087, 12094, 12116, 12120, 34195, 12151, 12152, 12154, 12157, 12162, 12165, 12178, 12186, 12262, 12210, 12222, 12229, 12235, 12239, 12242, 5226, 12274, 12288, 12304, 12307, 12316, 12318, 12322, 5224, 12354, 12358, 12366, 12371, 12375, 12387, 12390, 12394, 12400, 12451, 12424, 12434, 12435, 12437, 12438, 12444, 12458, 34347, 12465, 12474, 12475, 12484, 12487, 12531, 34433, 12494, 34417, 12500, 12505, 12513, 12521, 5266, 12552, 34553, 12567, 12571, 34634, 12640, 34825, 12659, 12675, 12683, 5308, 12696, 12707, 12717, 5319, 12732, 35030, 35112, 12787, 12788, 12802, 12818, 12822, 35407, 12885, 12892, 12908, 12919, 12932, 12930, 35591, 12952, 35642, 12964, 12966, 12975, 12986, 12987, 13002, 5407, 13009, 35769, 13047, 13066, 13067, 13092, 13109, 13118, 13122, 35964, 35997, 13159, 13164, 13178, 13220, 13236, 36307, 13239, 13248, 36381, 5469, 5470, 13269, 13274, 5475, 13300, 13301, 13397, 13348, 13352, 5486, 13379, 13410, 13414, 13420, 13450, 13453, 13461, 13472, 13478, 13485, 13486, 13495, 13498, 13503, 13507, 36677, 13548, 13551, 13553, 13555, 13568, 13569, 13577, 13628, 13633, 5542, 13639, 13642, 5544, 13664, 13665, 13668, 36833, 13693, 13698, 13704, 13713, 5573, 13778, 37013, 36973, 13759, 13769, 13772, 13777, 13789, 5594, 13794, 36964, 13801, 13864, 37215, 13831, 13840, 13872, 13879, 5620, 13885, 13887, 13888, 13895, 13918, 13920, 13933, 5637, 13960, 13964, 13973, 13978, 13981, 13992, 13997, 14002, 14021, 14029, 14047, 14056, 14070, 14071, 37377, 14101, 14115, 37461, 14121, 37499, 14149, 14150, 14156, 14157, 37492, 14184, 14191, 14195, 14196, 14197, 14203, 37604, 37591, 14252, 14234, 14237, 14238, 14248, 14295, 37629, 14284, 37686, 37700, 14302, 14310, 14320, 5706, 14328, 14331, 14333, 14340, 14366, 14368, 14375, 14386, 14393, 37828, 14409, 14412, 14439, 14474, 14475, 14477, 14479, 14480, 14484, 14493, 14506, 14513, 37997, 14531, 14541, 14562, 14579, 14580, 14597, 14598, 14603, 14605, 14612, 14628, 38359, 5777, 14653, 5785, 14662, 5782, 54057, 14683, 14687, 38471, 14709, 14710, 14716, 14751, 14766, 14780, 14792, 14797, 14814, 14819, 14820, 14823, 14830, 38662, 38722, 5839, 14860, 14861, 14871, 14887, 14893, 14933, 14949, 14970, 14987, 15004, 15007, 15008, 15010, 15025, 15027, 15029, 15034, 15039, 15066, 15068, 15072, 15077, 15088, 15086, 15093, 15104, 15112, 15127, 15156, 15149, 15180, 15186, 15208, 15215, 15228, 15231, 15233, 15236, 39363, 15254, 15276, 5985, 15296, 5986, 15310, 15318, 5996, 5995, 15345, 15357, 6005, 15363, 15401, 15408, 39510, 15455, 15459, 15463, 15464, 15465, 15472, 39725, 39749, 15484, 39800, 39778, 15496, 15498, 6081, 39841, 39836, 15520, 15522, 15526, 15527, 39826, 15533, 15541, 39863, 15561, 39904, 39987, 15622, 15632, 15659, 15645, 15648, 15652, 15654, 15665, 15673, 15682, 6120, 15713, 15722, 6132, 15728, 40222, 6141, 15752, 6144, 15762, 15764, 15767, 15769, 15792, 15794, 15796, 40310, 15801, 15825, 15831, 15832, 15840, 40442, 15844, 15849, 6191, 15872, 6198, 15890, 15893, 6208, 15903, 15918, 15934, 15945, 6236, 15958, 6241, 15979, 15980, 15981, 15982, 40571, 16037, 16042, 16044, 16057, 16063, 16070, 16082, 16089, 40990, 16125, 16136, 16142, 16156, 41133, 16158, 16199, 16227, 16242, 16254, 16271, 16290, 16292, 16312, 16324, 6394, 16327, 16331, 16338, 16339, 16340, 16354, 16366, 16367, 16371, 16380, 6423, 16407, 16418, 16420, 6426, 16460, 16511, 16522, 16533, 16552, 41459, 16560, 16561, 16574, 16584, 16601, 16603, 16622, 16626, 16629, 16656, 16658, 16659, 16665, 16670, 16698, 6511, 16705, 16710, 16736, 16764, 41563, 16786, 16787, 16791, 16792, 16805, 16808, 16813, 41643, 16853, 16861, 16863, 16885, 41871, 16917, 16931, 16937, 16966, 16972, 16977, 16978, 16993, 16996, 17019, 17005, 17011, 17049, 17062, 17109, 42168, 17149, 17155, 17165, 17168, 42319, 42320, 17202, 17205, 17211, 17212, 17217, 17220, 17230, 42310, 17241, 42525, 42406, 17260, 17284, 17305, 42532, 17300, 17341, 17399, 17364, 17365, 17372, 17376, 17387, 17388, 17394, 17417, 17438, 17445, 17449, 17455, 17498, 17499, 17501, 17523, 17533, 17543, 17553, 17565, 17567, 17611, 17612, 17621, 17623, 42977, 17636, 17637, 17663, 17668, 6766, 17679, 17684, 17686, 6771, 17694, 17714, 17732, 17748, 17771, 17786, 17793, 17796, 17797, 17802, 17842, 17845, 17848, 17855, 17858, 17865, 17876, 6870, 17906, 17913, 17916, 17924, 17928, 17953, 17962, 17989, 18001, 17998, 6890, 43203, 18007, 18011, 18019, 43253, 43190, 18026, 18027, 18028, 18029, 18043, 18048, 18064, 18066, 18073, 6926, 18093, 18097, 18101, 6938, 18111, 6940, 18156, 6871, 18177, 18181, 18194, 43378, 18201, 43475, 43474, 18252, 18253, 18260, 18269, 43472, 43492, 43477, 18292, 18294, 43482, 18322, 43487, 25443, 18448, 18352, 18354, 18371, 18376, 18386, 18393, 18395, 18416, 18423, 43594, 43601, 43595, 18456, 18463, 18477, 43621, 18483, 18491, 18494, 18500, 18501, 18505, 18508, 18517, 18519, 7031, 18539, 18542, 18554, 18556, 18562, 18576, 18582, 7021, 18584, 18585, 18586, 18588, 18602, 18603, 18612, 18619, 18683, 43748, 43866, 33043, 18627, 18629, 18636, 18639, 18646, 18649, 18660, 18661, 18668, 18679, 18691, 18695, 7047, 7048, 43924, 18747, 7053, 18758, 18793, 18796, 18802, 18810, 18815, 18834, 7076, 18838, 18840, 18854, 18864, 18871, 18874, 18876, 18880, 18897, 18902, 44089, 44103, 18992, 44088, 44090, 18915, 18926, 18927, 18931, 7117, 18932, 18942, 18961, 18970, 18973, 44316, 18994, 18995, 18996, 19007, 19014, 19017, 19066, 19022, 19026, 19044, 44300, 19070, 19075, 19083, 7152, 19089, 19103, 19105, 44388, 19115, 19133, 19142, 19156, 19152, 19164, 19165, 44543, 44519, 19180, 19185, 19186, 19187, 19197, 44580, 19211, 19215, 19216, 19217, 44605, 19223, 7206, 19247, 19274, 19288, 19308, 19317, 19322, 19329, 19355, 19374, 44952, 19389, 19390, 19399, 19400, 19401, 19418, 19430, 19431, 19438, 19441, 19458, 19466, 19470, 19509, 19510, 19514, 45183, 19519, 19533, 19547, 19565, 19588, 19593, 7363, 19604, 19605, 19607, 19629, 19650, 19664, 7378, 19670, 19674, 19676, 19689, 19692, 19693, 45312, 19712, 19722, 19748, 19750, 19751, 19559, 19759, 19772, 19803, 19806, 19808, 19824, 19840, 19841, 19850, 19853, 19857, 19864, 45376, 19991, 45562, 45561, 45523, 19883, 19886, 19892, 19906, 19764, 19912, 19918, 19919, 19920, 19935, 19945, 19958, 20022, 19998, 20002, 20007, 7441, 20018, 20028, 20040, 20041, 20043, 20044, 20047, 20049, 20051, 20052, 20055, 20067, 7454, 20115, 20135, 20148, 20159, 20163, 20170, 20185, 20277, 20203, 20217, 20219, 20234, 20236, 20248, 20261, 20278, 20284, 45694, 20306, 20311, 20314, 20320, 20328, 20376, 20349, 20368, 20374, 20414, 20383, 20389, 20399, 7524, 20405, 20424, 20425, 20442, 20446, 20457, 45974, 20476, 20480, 20487, 20490, 20515, 46083, 20537, 20538, 20540, 20547, 20551, 20555, 7578, 20564, 20581, 20585, 20588, 20590, 20598, 20606, 20609, 20614, 20629, 20631, 20667, 46278, 20639, 20657, 46334, 20716, 20682, 20689, 20691, 20700, 20739, 20740, 20742, 20743, 20744, 20748, 7616, 20783, 20785, 20816, 20810, 20819, 20830, 7636, 20886, 20864, 20891, 20896, 20898, 20910, 20911, 20915, 46524, 20939, 20947, 20953, 20956, 20999, 7685, 33097, 21035, 21044, 21048, 21049, 11820, 21058, 21075, 21079, 21091, 46633, 21102, 21103, 21112, 21119, 21134, 46757, 21165, 21166, 21168, 21169, 21185, 7776, 21196, 7782, 7784, 21235, 21242, 21255, 21266, 21272, 21273, 7811, 21305, 21292, 21297, 21299, 21309, 21330, 7828, 21355, 21356, 47254, 21358, 21359, 21361, 21367, 21377, 21381, 21386, 21396, 21400, 21404, 21406, 21413, 21416, 21429, 21431, 21433, 21436, 21439, 21445, 21451, 21473, 21479, 21497, 21523, 21498, 21505, 21540, 21553, 21561, 21587, 21568, 21571, 21581, 21586, 21597, 21617, 21633, 21637, 21640, 47437, 21650, 21655, 21657, 21664, 21665, 21669, 21674, 21675, 21689, 21691, 21690, 21718, 21720, 21726, 21743, 21739, 47702, 21754, 47727, 21792, 21796, 21802, 8023, 47894, 21821, 21822, 21824, 21832, 21838, 21840, 21842, 21868, 21874, 21873, 21882, 21885, 21886, 21889, 48148, 21900, 8053, 21922, 8055, 21936, 21943, 21951, 21952, 21958, 21967, 21971, 21981, 21983, 21984, 21991, 21996, 21998, 22001, 22009, 22019, 22040, 22023, 22031, 8110, 48398, 22035, 22043, 22044, 48439, 22053, 22056, 22076, 22067, 48490, 8137, 22081, 48523, 22089, 22101, 8151, 22126, 22165, 22172, 22177, 22176, 22183, 22184, 22191, 48714, 22217, 48725, 22248, 22252, 48930, 22295, 22298, 22317, 22325, 49065, 8249, 49125, 49101, 22360, 22368, 22378, 49182, 22386, 22396, 22397, 49228, 8280, 22426, 22431, 22434, 22436, 22441, 22494, 22495, 22500, 22502, 22506, 22508, 8339, 22512, 22516, 22523, 49454, 22533, 22534, 22537, 22541, 22553, 22561, 22572, 22599, 22628, 22634, 49625, 22666, 22676, 22692, 22685, 22686, 22687, 22715, 22728, 22732, 22734, 22741, 22752, 22753, 22758, 22777, 22778, 22779, 22782, 49831, 22800, 22811, 22832, 22821, 22843, 22858, 22872, 22875, 8453, 22887, 22898, 22932, 22933, 22934, 22939, 22945, 22953, 22964, 22971, 22978, 22983, 22988, 22989, 22998, 8520, 50089, 50100, 8527, 23050, 23057, 23061, 23067, 23070, 8547, 23085, 23096, 23111, 23116, 23126, 23129, 23132, 23135, 23136, 23143, 23146, 23157, 23160, 23170, 23178, 23184, 23203, 23212, 50388, 8628, 23225, 23228, 23230, 8639, 23244, 23249, 23271, 23272, 23284, 50660, 50659, 23303, 50673, 23357, 23335, 23338, 23342, 23343, 23345, 8678, 8691, 23423, 23361, 8686, 23381, 23417, 23396, 23398, 23401, 23411, 50738, 8711, 23440, 23441, 23451, 8718, 23471, 23477, 23484, 23493, 23498, 50891, 50916, 23508, 23510, 23514, 23530, 23536, 23555, 23563, 23566, 23567, 23590, 23621, 23626, 23633, 23639, 23646, 23649, 23657, 23662, 23663, 23664, 51246, 51286, 51301, 23718, 51298, 23734, 23735, 23743, 51416, 23748, 51394, 23752, 23757, 51432, 23767, 51491, 23782, 23787, 51548, 23797, 23811, 23817, 8902, 23826, 23838, 51680, 51668, 23869, 23870, 23872, 23879, 51724, 51707, 8918, 23897, 23898, 23914, 23920, 8925, 23935, 51735, 23942, 23944, 23948, 23959, 51808, 23965, 23975, 23978, 23990, 23991, 24000, 24023, 24025, 24038, 24049, 24057, 8962, 51949, 33112, 24080, 24087, 24093, 24096, 24103, 24108, 24133, 24179, 24181, 24190, 24198, 24199, 9003, 24209, 24216, 24218, 9027, 24380, 24379, 24382, 24387, 24388, 24399, 5313, 52080, 24402, 52102, 24417, 24419, 24420, 24429, 24445, 24446, 52300, 24464, 12667, 45326, 24470, 24476, 24493, 52482, 24515, 24527, 24547, 24549, 24559, 24562, 24578, 24586, 24584, 24590, 24593, 24598, 24612, 24620, 24624, 24643, 24678, 24689, 24693, 24699, 24729, 24732, 24740, 24743, 24760, 52862, 24773, 24789, 24792, 24806, 52912, 24845, 24821, 24827, 9198, 24885, 24854, 24862, 9200, 24868, 24871, 24876, 53021, 24893, 9224, 24937, 9239, 24961, 9244, 24964, 24965, 9250, 24984, 25010, 25025, 25027, 25046, 25051, 53469, 25060, 53482, 25068, 53585, 25085, 25087, 53615, 25092, 53725, 25113, 25121, 25122, 53790, 25138, 25140, 25148, 25158, 25161, 25157, 53848, 25163, 9334, 25167, 9338, 25175, 53900, 25180, 25187, 53943, 33117, 33118, 25209, 9361, 25213, 25215, 25219, 25226, 25235, 25255, 25256, 25266, 25268, 25274, 25276, 25314, 25320, 25335, 25351, 25352, 25356, 25428, 25371, 25373, 25392, 25404, 25412, 25431, 9406, 25471, 9428, 9395, 25485, 25492, 25493, 25499, 25501, 25545, 25552, 25556, 25565, 25573, 25593, 25615, 25617, 25621, 54131, 25623, 25657, 25674, 25679, 25681, 25682, 25689, 25690, 25692, 54237, 25701, 25718, 25720, 25724, 25729, 9485, 25820, 25751, 25766, 25790, 9480, 25806, 25807, 25811, 54373, 25831, 25834, 25839, 25840, 25841, 25850, 25853, 25868, 25883, 25892, 25893, 25899, 25908, 25935, 25967, 9509, 9539, 25918, 25937, 25939, 25950, 25953, 25954, 54676, 25979, 25981, 25983, 25985, 25990, 26003, 26013, 26015, 54776, 54774, 54775, 26039, 26044, 26055, 26058, 26072, 26073, 26079, 26081, 26086, 26102, 26112, 26129, 26142, 26145, 26148, 26151, 54925, 26169, 26172, 54969, 26176, 33056, 26195, 26198, 26223, 26231, 26234, 26247, 26249, 26253, 26257, 26268, 26269, 26280, 33057, 26289, 26291, 26305, 26307, 26321, 26325, 26327, 26339, 26342, 9656, 26373, 26375, 26382, 26384, 26387, 26393, 26399, 26401, 26403, 26417, 26426, 26430, 26432, 26435, 26449, 26456, 26468, 26469, 26482, 26492, 55131, 55130, 26535, 26505, 26507, 26515, 26528, 55166, 9701, 26558, 55184, 26561, 26574, 26613, 26591, 55241, 26595, 26597, 26598, 26602, 26603, 26605, 26625, 26627, 26635, 26643, 26664, 26670, 26674, 26684, 9743, 26698, 26712, 26719, 26724, 55317, 55316, 26729, 55345, 26735, 26784, 26812, 26813, 26814, 26816, 26834, 55443, 26833, 26835, 26843, 26864, 26865, 9793, 26881, 55566, 26935, 55587, 26946, 26949, 26953, 55634, 9829, 26978, 27008, 27017, 27024, 27039, 27056, 27063, 27094, 27096, 27115, 9889, 27121, 27123, 27133, 27135, 9903, 27153, 27156, 55941, 27169, 27189, 27198, 27205, 27213, 27224, 27310, 27280, 27319, 27326, 27351, 27388, 56196, 27402, 27397, 27405, 27420, 27423, 27437, 27459, 9996, 27473, 27486, 27510, 27519, 27521, 27531, 27540, 27541, 27548, 27550, 27705, 56499, 27709, 56510, 56519, 27717, 27719, 27727, 27732, 27735, 27753, 27757, 27763, 56760, 27795, 27794, 27801, 10084, 27803, 27812, 27862, 27861, 27865, 56864, 27888, 27889, 56976, 27913, 27918, 28012, 28036, 28053, 28070, 57271, 28102, 28104, 28121, 28140, 28172, 10237, 28157, 28166, 57482, 28180, 28182, 28193, 28194, 28199, 57531, 10262, 28214, 28217, 28235, 28244, 28258, 28268, 28269, 28271, 28312, 28318, 28334, 28339, 28341, 28342, 28347, 57730, 28369, 28372, 10318, 28409, 57843, 28416, 28424, 28439, 28459, 28480, 28490, 28504, 57996, 28580, 28596, 33126, 28598, 58069, 28609, 28614, 33060, 28618, 28621, 28627, 28629, 28640, 28657, 28661, 28667, 28674, 28684, 28727, 58219, 28739, 28740, 28765, 58312, 58313, 28805, 28812, 28816, 30237, 28833, 10421, 28848, 28854, 28867, 28872, 58583, 28892, 28895, 58618, 28918, 28914, 28928, 28907, 28926, 28927, 28932, 28934, 28952, 28956, 28958, 28983, 28985, 28986, 28998, 28999, 29015, 29017, 29025, 29028, 29044, 29049, 29061, 29070, 29096, 29102, 29107, 29110, 29123, 29124, 29146, 58697, 58694, 29164, 29166, 29185, 29194, 29206, 29207, 58731, 29235, 29250, 29255, 29258, 29262, 29265, 29270, 29273, 29280, 29281, 29285, 29287, 29288, 58759, 58760, 29308, 29309, 29311, 29321, 29325, 29335, 29337, 29343, 29351, 29355, 58810, 58811, 29362, 29375, 29376, 29382, 29390, 29392, 29399, 29401, 29413, 29415, 29457, 58910, 58921, 29431, 29433, 29435, 29442, 29453, 29461, 29469, 29470, 29479, 29481, 58993, 58947, 29511, 29521, 29527, 29530, 29547, 29553, 29555, 29601, 59033, 59085, 29576, 29579, 29583, 29598, 29685, 59108, 59101, 29681, 29633, 29639, 29660, 29666, 29671, 29705, 29711, 29718, 29719, 29691, 29746, 29748, 29755, 29765, 59329, 59375, 29805, 29807, 30072, 30073, 30086, 30092, 30093, 59408, 30123, 30132, 59505, 30152, 59643, 59679, 30252, 30259, 30260, 59702, 30268, 30273, 30305, 59785, 30338, 59883, 30362, 59954, 10727, 30377, 30383, 30387, 30394, 30397, 10746, 60152, 30424, 30426, 30429, 10756, 30484, 30499, 10793, 30518, 30529, 30535, 30549, 30551, 30555, 30570, 60320, 60337, 30614, 30618, 30622, 30626, 30641, 30642, 30654, 30668, 30673, 30676, 30680, 30681, 30689, 30705, 30724, 30733, 30734, 30740, 30742, 10940, 60560, 30755, 30770, 30771, 30757, 30791, 30822, 30891, 30893, 30896, 60879, 30903, 30904, 30907, 30908, 30911, 30914, 30919, 30923, 30944, 61055, 30945, 30947, 30949, 30954, 30960, 30961, 30963, 30984, 11067, 61168, 30998, 30999, 61209, 31002, 31003, 31004, 61264, 31025, 31026, 31027, 31034, 31035, 31036, 31040, 31041, 31046, 31053, 31054, 31068, 31071, 31072, 31139, 31142, 31161, 31165, 31167, 31171, 31177, 31188, 31193, 31198, 61638, 31216, 31225, 31228, 31242, 31249, 31254, 31258, 31264, 31281, 31286, 31300, 31308, 31320, 11202, 31407, 11210, 31415, 11218, 31417, 61810, 31430, 31440, 31442, 31445, 11240, 31452, 31456, 31461, 31465, 31491, 31500, 31504, 31506, 31510, 31516, 31531, 31539, 31549, 11296, 31563, 31587, 31589, 31595, 31596, 31603, 31606, 31607, 31654, 31660, 31665, 62171, 62269, 31666, 31672, 31678, 31687, 31731, 31704, 31709, 31719, 31722, 31723, 31727, 31726, 62229, 31738, 62346, 31735, 62281, 31766, 31768, 31769, 31770, 31773, 31778, 31783, 31785, 31786, 62404, 31793, 31798, 31799, 31813, 31836, 62441, 31817, 31818, 62427, 31828, 31832, 31835, 31837, 31839, 31849, 31850, 31851, 31853, 31854, 31856, 31858, 31861, 31866, 31974, 31986, 32011, 32002, 62670, 32017, 32023, 32024, 62767, 11460, 62746, 32050, 11473, 32066, 32074, 32095, 32098, 62969, 32105, 32107, 62850, 32115, 32118, 32119, 32126, 32132, 32141, 32153, 32161, 32191, 32181, 32185, 32189, 32195, 32199, 32201, 32214, 32218, 32223, 32224, 32227, 32244, 11527, 32266, 32258, 32269, 32281, 32284, 32285, 32379, 40728, 32384, 32389, 32411, 32424, 63244, 32445, 63415, 32479, 32487, 32494, 32511, 32514, 11639, 32515, 32535, 32537, 32559, 32567, 32570, 32573, 32577, 32581, 32582, 32595, 32597, 32600, 63729, 32605, 63746, 32617, 63770, 32621, 32624, 32629, 63922, 0, 0, 0, 0, 0, 0, 0, 0};
        System.arraycopy(nArray, 0, JISX0213_TO_UCS__MAIN, n, nArray.length);
        return nArray.length;
    }

    protected static char[] decode(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        boolean bl = false;
        int n5 = -1;
        if (n3 >= 289 && n3 <= 382) {
            n3 -= 289;
        } else if (n3 == 545) {
            n3 -= 451;
        } else if (n3 >= 547 && n3 <= 549) {
            n3 -= 452;
        } else if (n3 == 552) {
            n3 -= 454;
        } else if (n3 >= 556 && n3 <= 559) {
            n3 -= 457;
        } else if (n3 >= 622 && n3 <= 638) {
            n3 -= 519;
        } else {
            n5 = 0;
        }
        if (n5 < 0 && n4 >= 33 && n4 <= 126) {
            n4 -= 33;
        } else {
            n5 = 0;
            bl = true;
        }
        if (n5 < 0) {
            n5 = JISX0213_TO_UCS__MAIN[n3 * 94 + n4];
            boolean bl2 = bl = (n5 = JISX0213_TO_UCS__PAGESTART[n5 >> 8] + (n5 & 0xFF)) == 65533;
        }
        if (!bl) {
            if (n5 < 128) {
                int n6 = n5 - 1;
                n5 = JISX0213_TO_UCS__COMBINING[n6][0] << 16;
                n5 |= JISX0213_TO_UCS__COMBINING[n6][1];
            }
            if (n5 > 65535) {
                if ((n5 & 0xFFFF0000) != 131072) {
                    return new char[]{(char)(n5 >> 16 & 0xFFFF), (char)(n5 & 0xFFFF)};
                }
                char[] cArray = new char[2];
                int n7 = n5 - 65536;
                cArray[0] = (char)((n7 >> 10) + 55296);
                cArray[1] = (char)((n7 & 0x3FF) + 56320);
                return cArray;
            }
            return new char[]{(char)n5};
        }
        return new char[]{'\ufffd'};
    }

    static {
        JISX0213_TO_UCS__PAGESTART = new int[]{0, 256, 512, 768, 1024, 7680, 7936, 8192, 8448, 8704, 8960, 9216, 9472, 9728, 9984, 10496, 12288, 12544, 12800, 13056, 13312, 13568, 13824, 14080, 14336, 14592, 14848, 15104, 15360, 15616, 15872, 16128, 16384, 16640, 16896, 17152, 17408, 17664, 17920, 18176, 18432, 18688, 18944, 19200, 19456, 19712, 19968, 20224, 20480, 20736, 20992, 21248, 21504, 21760, 22016, 22272, 22528, 22784, 23040, 23296, 23552, 23808, 24064, 24320, 24576, 24832, 25088, 25344, 25600, 25856, 26112, 26368, 26624, 26880, 27136, 27392, 27648, 27904, 28160, 28416, 28672, 28928, 29184, 29440, 29696, 29952, 30208, 30464, 30720, 30976, 31232, 31488, 31744, 32000, 32256, 32512, 32768, 33024, 33280, 33536, 33792, 34048, 34304, 34560, 34816, 35072, 35328, 35584, 35840, 36096, 36352, 36608, 36864, 37120, 37376, 37632, 37888, 38144, 38400, 38656, 38912, 39168, 39424, 39680, 39936, 40192, 40448, 40704, 63744, 64000, 65024, 65280, 131072, 131456, 131840, 132096, 132352, 132608, 132864, 133120, 133376, 133632, 133888, 134400, 134656, 134912, 135680, 135936, 136192, 136448, 136704, 136960, 137216, 137472, 138240, 138496, 138752, 139008, 139520, 139776, 140032, 140800, 141312, 141568, 141824, 142080, 142336, 142592, 143616, 144128, 144384, 144640, 144896, 145152, 145408, 145920, 146432, 146688, 147200, 147456, 147712, 148224, 148992, 149248, 149504, 150016, 150272, 150528, 150784, 151040, 151552, 151808, 152064, 152576, 152832, 153344, 153856, 154112, 154496, 154880, 155136, 155392, 155648, 156160, 156416, 156672, 157184, 157440, 157696, 157952, 158208, 158720, 159232, 159488, 159872, 160640, 161280, 161536, 162048, 162304, 162560, 162816, 163200, 163584, 163840, 164352, 164736, 165120, 165376, 166144, 166400, 166656, 167168, 167424, 167680, 168448, 168960, 169216, 169472, 169728, 169984, 170496, 171264, 171520, 171776, 172032, 172288, 172928, 173312, 173568};
        JISX0213_TO_UCS__MAIN = new int[11280];
        int n = JIS0213ByteToCharConverter.loadUcsMain1(0);
        JIS0213ByteToCharConverter.loadUcsMain2(n);
    }
}

